/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsMasterWrapperImpl
implements MetricsMasterWrapper {
    private final HMaster master;

    public MetricsMasterWrapperImpl(HMaster master) {
        this.master = master;
    }

    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    public long getSplitPlanCount() {
        return this.master.getRegionNormalizerManager().getSplitPlanCount();
    }

    public long getMergePlanCount() {
        return this.master.getRegionNormalizerManager().getMergePlanCount();
    }

    public long getMasterInitializationTime() {
        return this.master.getMasterFinishedInitializationTime();
    }

    public String getClusterId() {
        return this.master.getClusterId();
    }

    public String getZookeeperQuorum() {
        ZKWatcher zk = this.master.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String[] getCoprocessors() {
        return this.master.getMasterCoprocessors();
    }

    public long getStartTime() {
        return this.master.getMasterStartTime();
    }

    public long getActiveTime() {
        return this.master.getMasterActiveTime();
    }

    public String getRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getOnlineServers().keySet(), (String)";");
    }

    public int getNumRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getOnlineServers().size();
    }

    public String getDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getDeadServers().copyServerNames(), (String)";");
    }

    public int getNumDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDeadServers().size();
    }

    public boolean isRunning() {
        return !this.master.isStopped() && !this.master.isStopping();
    }

    public String getServerName() {
        ServerName serverName = this.master.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }

    public long getNumWALFiles() {
        return this.master.getNumWALFiles();
    }

    public Map<String, Map.Entry<Long, Long>> getTableSpaceUtilization() {
        if (this.master == null) {
            return Collections.emptyMap();
        }
        QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
        if (quotaChore == null) {
            return Collections.emptyMap();
        }
        Map<TableName, SpaceQuotaSnapshot> tableSnapshots = quotaChore.getTableQuotaSnapshots();
        HashMap<String, Map.Entry<Long, Long>> convertedData = new HashMap<String, Map.Entry<Long, Long>>();
        for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : tableSnapshots.entrySet()) {
            convertedData.put(entry.getKey().toString(), this.convertSnapshot(entry.getValue()));
        }
        return convertedData;
    }

    public Map<String, Map.Entry<Long, Long>> getNamespaceSpaceUtilization() {
        QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
        if (quotaChore == null) {
            return Collections.emptyMap();
        }
        Map<String, SpaceQuotaSnapshot> namespaceSnapshots = quotaChore.getNamespaceQuotaSnapshots();
        HashMap<String, Map.Entry<Long, Long>> convertedData = new HashMap<String, Map.Entry<Long, Long>>();
        for (Map.Entry<String, SpaceQuotaSnapshot> entry : namespaceSnapshots.entrySet()) {
            convertedData.put(entry.getKey(), this.convertSnapshot(entry.getValue()));
        }
        return convertedData;
    }

    Map.Entry<Long, Long> convertSnapshot(SpaceQuotaSnapshot snapshot) {
        return new AbstractMap.SimpleImmutableEntry<Long, Long>(snapshot.getUsage(), snapshot.getLimit());
    }
}

