/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FileLink {
    private static final Logger LOG = LoggerFactory.getLogger(FileLink.class);
    public static final String BACK_REFERENCES_DIRECTORY_PREFIX = ".links-";
    private Path[] locations = null;

    protected FileLink() {
        this.locations = null;
    }

    public FileLink(Path originPath, Path ... alternativePaths) {
        this.setLocations(originPath, alternativePaths);
    }

    public FileLink(Collection<Path> locations) {
        this.locations = locations.toArray(new Path[locations.size()]);
    }

    public Path[] getLocations() {
        return this.locations;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append(" locations=[");
        for (int i = 0; i < this.locations.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(this.locations[i].toString());
        }
        str.append("]");
        return str.toString();
    }

    public boolean exists(FileSystem fs) throws IOException {
        for (int i = 0; i < this.locations.length; ++i) {
            if (!fs.exists(this.locations[i])) continue;
            return true;
        }
        return false;
    }

    public Path getAvailablePath(FileSystem fs) throws IOException {
        for (int i = 0; i < this.locations.length; ++i) {
            if (!fs.exists(this.locations[i])) continue;
            return this.locations[i];
        }
        throw new FileNotFoundException(this.toString());
    }

    public FileStatus getFileStatus(FileSystem fs) throws IOException {
        IOException exception = null;
        for (int i = 0; i < this.locations.length; ++i) {
            try {
                return fs.getFileStatus(this.locations[i]);
            }
            catch (FileNotFoundException | AccessControlException e) {
                exception = FileLink.handleAccessLocationException(this, (IOException)e, exception);
                continue;
            }
        }
        throw exception;
    }

    private static IOException handleAccessLocationException(FileLink fileLink, IOException newException, IOException previousException) throws IOException {
        if (newException instanceof RemoteException) {
            newException = ((RemoteException)((Object)newException)).unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class});
        }
        if (newException instanceof FileNotFoundException) {
            if (previousException == null) {
                previousException = new FileNotFoundException(fileLink.toString());
            }
        } else if (newException instanceof AccessControlException) {
            previousException = newException;
        } else {
            throw newException;
        }
        return previousException;
    }

    public FSDataInputStream open(FileSystem fs) throws IOException {
        return new FSDataInputStream((InputStream)new FileLinkInputStream(fs, this));
    }

    public FSDataInputStream open(FileSystem fs, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)new FileLinkInputStream(fs, this, bufferSize));
    }

    protected void setLocations(Path originPath, Path ... alternativePaths) {
        assert (this.locations == null) : "Link locations already set";
        ArrayList<Path> paths = new ArrayList<Path>(alternativePaths.length + 1);
        if (originPath != null) {
            paths.add(originPath);
        }
        for (int i = 0; i < alternativePaths.length; ++i) {
            if (alternativePaths[i] == null) continue;
            paths.add(alternativePaths[i]);
        }
        this.locations = paths.toArray(new Path[0]);
    }

    public static Path getBackReferencesDir(Path storeDir, String fileName) {
        return new Path(storeDir, BACK_REFERENCES_DIRECTORY_PREFIX + fileName);
    }

    public static String getBackReferenceFileName(Path dirPath) {
        return dirPath.getName().substring(BACK_REFERENCES_DIRECTORY_PREFIX.length());
    }

    public static boolean isBackReferencesDir(Path dirPath) {
        if (dirPath == null) {
            return false;
        }
        return dirPath.getName().startsWith(BACK_REFERENCES_DIRECTORY_PREFIX);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            return Arrays.equals(this.locations, ((FileLink)obj).locations);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.locations);
    }

    private static class FileLinkInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable,
    CanSetDropBehind,
    CanSetReadahead,
    CanUnbuffer {
        private FSDataInputStream in = null;
        private Path currentPath = null;
        private long pos = 0L;
        private final FileLink fileLink;
        private final int bufferSize;
        private final FileSystem fs;

        public FileLinkInputStream(FileSystem fs, FileLink fileLink) throws IOException {
            this(fs, fileLink, CommonFSUtils.getDefaultBufferSize((FileSystem)fs));
        }

        public FileLinkInputStream(FileSystem fs, FileLink fileLink, int bufferSize) throws IOException {
            this.bufferSize = bufferSize;
            this.fileLink = fileLink;
            this.fs = fs;
            this.in = this.tryOpen();
        }

        @Override
        public int read() throws IOException {
            int res;
            try {
                res = this.in.read();
            }
            catch (FileNotFoundException e) {
                res = this.tryOpen().read();
            }
            if (res > 0) {
                ++this.pos;
            }
            return res;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            try {
                n = this.in.read(b, off, len);
            }
            catch (FileNotFoundException e) {
                n = this.tryOpen().read(b, off, len);
            }
            if (n > 0) {
                this.pos += (long)n;
            }
            assert (this.in.getPos() == this.pos);
            return n;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            int n;
            try {
                n = this.in.read(position, buffer, offset, length);
            }
            catch (FileNotFoundException e) {
                n = this.tryOpen().read(position, buffer, offset, length);
            }
            return n;
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.readFully(position, buffer, 0, buffer.length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            try {
                this.in.readFully(position, buffer, offset, length);
            }
            catch (FileNotFoundException e) {
                this.tryOpen().readFully(position, buffer, offset, length);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped;
            try {
                skipped = this.in.skip(n);
            }
            catch (FileNotFoundException e) {
                skipped = this.tryOpen().skip(n);
            }
            if (skipped > 0L) {
                this.pos += skipped;
            }
            return skipped;
        }

        @Override
        public int available() throws IOException {
            try {
                return this.in.available();
            }
            catch (FileNotFoundException e) {
                return this.tryOpen().available();
            }
        }

        public void seek(long pos) throws IOException {
            try {
                this.in.seek(pos);
            }
            catch (FileNotFoundException e) {
                this.tryOpen().seek(pos);
            }
            this.pos = pos;
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            boolean res;
            try {
                res = this.in.seekToNewSource(targetPos);
            }
            catch (FileNotFoundException e) {
                res = this.tryOpen().seekToNewSource(targetPos);
            }
            if (res) {
                this.pos = targetPos;
            }
            return res;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public void unbuffer() {
            if (this.in == null) {
                return;
            }
            this.in.unbuffer();
        }

        private FSDataInputStream tryOpen() throws IOException {
            IOException exception = null;
            for (Path path : this.fileLink.getLocations()) {
                if (path.equals((Object)this.currentPath)) continue;
                try {
                    this.in = this.fs.open(path, this.bufferSize);
                    if (this.pos != 0L) {
                        this.in.seek(this.pos);
                    }
                    assert (this.in.getPos() == this.pos) : "Link unable to seek to the right position=" + this.pos;
                    if (LOG.isTraceEnabled()) {
                        if (this.currentPath == null) {
                            LOG.debug("link open path=" + path);
                        } else {
                            LOG.trace("link switch from path=" + this.currentPath + " to path=" + path);
                        }
                    }
                    this.currentPath = path;
                    return this.in;
                }
                catch (FileNotFoundException | RemoteException | AccessControlException e) {
                    exception = FileLink.handleAccessLocationException(this.fileLink, (IOException)e, exception);
                }
            }
            throw exception;
        }

        public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
            this.in.setReadahead(readahead);
        }

        public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
            this.in.setDropBehind(dropCache);
        }
    }
}

