/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MockRegionServerServices;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.ImmutableHRegionInfo;
import org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;

@InterfaceAudience.Public
public class HBaseTestingUtility
extends HBaseZKTestingUtility {
    @Deprecated
    private static final String TEST_DIRECTORY_KEY = "test.build.data";
    public static final String REGIONS_PER_SERVER_KEY = "hbase.test.regions-per-server";
    public static final int DEFAULT_REGIONS_PER_SERVER = 3;
    public static final String PRESPLIT_TEST_TABLE_KEY = "hbase.test.pre-split-table";
    public static final boolean PRESPLIT_TEST_TABLE = true;
    private MiniDFSCluster dfsCluster = null;
    private FsDatasetAsyncDiskServiceFixer dfsClusterFixer = null;
    private volatile HBaseCluster hbaseCluster = null;
    private MiniMRCluster mrCluster = null;
    private volatile boolean miniClusterRunning;
    private String hadoopLogDir;
    private Path dataTestDirOnTestFS = null;
    private final AtomicReference<Connection> connection = new AtomicReference();
    private static String FS_URI;
    public static final List<Object[]> MEMSTORETS_TAGS_PARAMETRIZED;
    public static final Collection<Object[]> BLOOM_AND_COMPRESSION_COMBINATIONS;
    public static final byte[] fam1;
    public static final byte[] fam2;
    public static final byte[] fam3;
    public static final byte[][] COLUMNS;
    private static final int MAXVERSIONS = 3;
    public static final char FIRST_CHAR = 'a';
    public static final char LAST_CHAR = 'z';
    public static final byte[] START_KEY_BYTES;
    public static final String START_KEY;
    public static final byte[][] ROWS;
    public static final byte[][] KEYS;
    public static final byte[][] KEYS_FOR_HBA_CREATE_TABLE;
    private HBaseAdmin hbaseAdmin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static List<Object[]> bloomAndCompressionCombinations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (Compression.Algorithm comprAlgo : HBaseCommonTestingUtility.COMPRESSION_ALGORITHMS) {
            for (BloomType bloomType : BloomType.values()) {
                configurations.add(new Object[]{comprAlgo, bloomType});
            }
        }
        return Collections.unmodifiableList(configurations);
    }

    private static List<Object[]> memStoreTSAndTagsCombination() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        configurations.add(new Object[]{false, false});
        configurations.add(new Object[]{false, true});
        configurations.add(new Object[]{true, false});
        configurations.add(new Object[]{true, true});
        return Collections.unmodifiableList(configurations);
    }

    public static List<Object[]> memStoreTSTagsAndOffheapCombination() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        configurations.add(new Object[]{false, false, true});
        configurations.add(new Object[]{false, false, false});
        configurations.add(new Object[]{false, true, true});
        configurations.add(new Object[]{false, true, false});
        configurations.add(new Object[]{true, false, true});
        configurations.add(new Object[]{true, false, false});
        configurations.add(new Object[]{true, true, true});
        configurations.add(new Object[]{true, true, false});
        return Collections.unmodifiableList(configurations);
    }

    public HBaseTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseTestingUtility(@Nullable Configuration conf) {
        super(conf);
        ChecksumUtil.generateExceptionForChecksumFailureForTest((boolean)true);
        if (this.conf.get("fs.defaultFS") != null) {
            this.conf.set("original.defaultFS", this.conf.get("fs.defaultFS"));
        }
        if (this.conf.get("hbase.rootdir") != null) {
            this.conf.set("original.hbase.dir", this.conf.get("hbase.rootdir"));
        }
        String dataTestDir = this.getDataTestDir().toString();
        this.conf.set("fs.defaultFS", "file:///");
        this.conf.set("hbase.rootdir", "file://" + dataTestDir);
        LOG.debug("Setting {} to {}", (Object)"hbase.rootdir", (Object)dataTestDir);
        this.conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        this.conf.setBoolean("hbase.localcluster.assign.random.ports", this.conf.getBoolean("hbase.localcluster.assign.random.ports", true));
    }

    @Deprecated
    public static HBaseTestingUtility createLocalHTU() {
        return new HBaseTestingUtility();
    }

    @Deprecated
    public static HBaseTestingUtility createLocalHTU(Configuration c) {
        return new HBaseTestingUtility(c);
    }

    public static void closeRegionAndWAL(Region r) throws IOException {
        HBaseTestingUtility.closeRegionAndWAL((HRegion)r);
    }

    public static void closeRegionAndWAL(HRegion r) throws IOException {
        if (r == null) {
            return;
        }
        r.close();
        if (r.getWAL() == null) {
            return;
        }
        r.getWAL().close();
    }

    public Configuration getConfiguration() {
        return super.getConfiguration();
    }

    public void setHBaseCluster(HBaseCluster hbaseCluster) {
        this.hbaseCluster = hbaseCluster;
    }

    protected Path setupDataTestDir() {
        Path testPath = super.setupDataTestDir();
        if (null == testPath) {
            return null;
        }
        this.createSubDirAndSystemProperty("hadoop.log.dir", testPath, "hadoop-log-dir");
        this.createSubDirAndSystemProperty("hadoop.tmp.dir", testPath, "hadoop-tmp-dir");
        this.createSubDir("mapreduce.cluster.local.dir", testPath, "mapred-local-dir");
        return testPath;
    }

    private void createSubDirAndSystemProperty(String propertyName, Path parent, String subDirName) {
        String sysValue = System.getProperty(propertyName);
        if (sysValue != null) {
            LOG.info("System.getProperty(\"" + propertyName + "\") already set to: " + sysValue + " so I do NOT create it in " + parent);
            String confValue = this.conf.get(propertyName);
            if (confValue != null && !confValue.endsWith(sysValue)) {
                LOG.warn(propertyName + " property value differs in configuration and system: Configuration=" + confValue + " while System=" + sysValue + " Erasing configuration value by system value.");
            }
            this.conf.set(propertyName, sysValue);
        } else {
            this.createSubDir(propertyName, parent, subDirName);
            System.setProperty(propertyName, this.conf.get(propertyName));
        }
    }

    private Path getBaseTestDirOnTestFS() throws IOException {
        FileSystem fs = this.getTestFileSystem();
        return new Path(fs.getWorkingDirectory(), "test-data");
    }

    @Deprecated
    public HTableDescriptor getMetaTableDescriptor() {
        return new ImmutableHTableDescriptor(this.getMetaTableDescriptorBuilder().build());
    }

    @Deprecated
    @InterfaceAudience.Private
    public TableDescriptorBuilder getMetaTableDescriptorBuilder() {
        try {
            return FSTableDescriptors.createMetaTableDescriptorBuilder((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create META table descriptor", e);
        }
    }

    public Path getDataTestDirOnTestFS() throws IOException {
        if (this.dataTestDirOnTestFS == null) {
            this.setupDataTestDirOnTestFS();
        }
        return this.dataTestDirOnTestFS;
    }

    public Path getDataTestDirOnTestFS(String subdirName) throws IOException {
        return new Path(this.getDataTestDirOnTestFS(), subdirName);
    }

    private void setupDataTestDirOnTestFS() throws IOException {
        if (this.dataTestDirOnTestFS != null) {
            LOG.warn("Data test on test fs dir already setup in " + this.dataTestDirOnTestFS.toString());
            return;
        }
        this.dataTestDirOnTestFS = this.getNewDataTestDirOnTestFS();
    }

    private Path getNewDataTestDirOnTestFS() throws IOException {
        Path newDataTestDir;
        FileSystem fs = this.getTestFileSystem();
        String randomStr = HBaseTestingUtility.getRandomUUID().toString();
        if (fs.getUri().getScheme().equals(FileSystem.getLocal((Configuration)this.conf).getUri().getScheme())) {
            newDataTestDir = new Path(this.getDataTestDir(), randomStr);
            File dataTestDir = new File(newDataTestDir.toString());
            if (this.deleteOnExit()) {
                dataTestDir.deleteOnExit();
            }
        } else {
            Path base = this.getBaseTestDirOnTestFS();
            newDataTestDir = new Path(base, randomStr);
            if (this.deleteOnExit()) {
                fs.deleteOnExit(newDataTestDir);
            }
        }
        return newDataTestDir;
    }

    public boolean cleanupDataTestDirOnTestFS() throws IOException {
        boolean ret = this.getTestFileSystem().delete(this.dataTestDirOnTestFS, true);
        if (ret) {
            this.dataTestDirOnTestFS = null;
        }
        return ret;
    }

    public boolean cleanupDataTestDirOnTestFS(String subdirName) throws IOException {
        Path cpath = this.getDataTestDirOnTestFS(subdirName);
        return this.getTestFileSystem().delete(cpath, true);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers) throws Exception {
        return this.startMiniDFSCluster(servers, null);
    }

    public MiniDFSCluster startMiniDFSCluster(String[] hosts) throws Exception {
        if (hosts != null && hosts.length != 0) {
            return this.startMiniDFSCluster(hosts.length, hosts);
        }
        return this.startMiniDFSCluster(1, null);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, String[] hosts) throws Exception {
        return this.startMiniDFSCluster(servers, null, hosts);
    }

    private void setFs() throws IOException {
        if (this.dfsCluster == null) {
            LOG.info("Skipping setting fs because dfsCluster is null");
            return;
        }
        DistributedFileSystem fs = this.dfsCluster.getFileSystem();
        CommonFSUtils.setFsDefault((Configuration)this.conf, (Path)new Path(fs.getUri()));
        this.conf.unset("hbase.unsafe.stream.capability.enforce");
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, String[] racks, String[] hosts) throws Exception {
        this.createDirsAndSetProperties();
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        this.dfsCluster = new MiniDFSCluster(0, this.conf, servers, true, true, true, null, racks, hosts, null);
        this.dfsClusterFixer = new FsDatasetAsyncDiskServiceFixer(this.dfsCluster);
        this.dfsClusterFixer.start();
        this.setFs();
        this.dfsCluster.waitClusterUp();
        this.dataTestDirOnTestFS = null;
        String dataTestDir = this.getDataTestDir().toString();
        this.conf.set("hbase.rootdir", dataTestDir);
        LOG.debug("Setting {} to {}", (Object)"hbase.rootdir", (Object)dataTestDir);
        return this.dfsCluster;
    }

    public MiniDFSCluster startMiniDFSClusterForTestWAL(int namenodePort) throws IOException {
        this.createDirsAndSetProperties();
        this.dfsCluster = new MiniDFSCluster(namenodePort, this.conf, 5, false, true, true, null, null, null, null);
        this.dfsClusterFixer = new FsDatasetAsyncDiskServiceFixer(this.dfsCluster);
        this.dfsClusterFixer.start();
        return this.dfsCluster;
    }

    private void createDirsAndSetProperties() throws IOException {
        this.setupClusterTestDir();
        this.conf.set(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        this.createDirAndSetProperty("test.cache.data");
        this.createDirAndSetProperty("hadoop.tmp.dir");
        this.hadoopLogDir = this.createDirAndSetProperty("hadoop.log.dir");
        this.createDirAndSetProperty("mapreduce.cluster.local.dir");
        this.createDirAndSetProperty("mapreduce.cluster.temp.dir");
        this.enableShortCircuit();
        Path root = this.getDataTestDirOnTestFS("hadoop");
        this.conf.set(MapreduceTestingShim.getMROutputDirProp(), new Path(root, "mapred-output-dir").toString());
        this.conf.set("mapreduce.jobtracker.system.dir", new Path(root, "mapred-system-dir").toString());
        this.conf.set("mapreduce.jobtracker.staging.root.dir", new Path(root, "mapreduce-jobtracker-staging-root-dir").toString());
        this.conf.set("mapreduce.job.working.dir", new Path(root, "mapred-working-dir").toString());
        this.conf.set("yarn.app.mapreduce.am.staging-dir", new Path(root, "mapreduce-am-staging-root-dir").toString());
        this.createDirAndSetProperty("yarn.node-labels.fs-store.root-dir");
        this.createDirAndSetProperty("yarn.node-attribute.fs-store.root-dir");
        this.createDirAndSetProperty("yarn.nodemanager.log-dirs");
        this.createDirAndSetProperty("yarn.nodemanager.remote-app-log-dir");
        this.createDirAndSetProperty("yarn.timeline-service.entity-group-fs-store.active-dir");
        this.createDirAndSetProperty("yarn.timeline-service.entity-group-fs-store.done-dir");
        this.createDirAndSetProperty("yarn.nodemanager.remote-app-log-dir");
        this.createDirAndSetProperty("dfs.journalnode.edits.dir");
        this.createDirAndSetProperty("dfs.datanode.shared.file.descriptor.paths");
        this.createDirAndSetProperty("nfs.dump.dir");
        this.createDirAndSetProperty("java.io.tmpdir");
        this.createDirAndSetProperty("dfs.journalnode.edits.dir");
        this.createDirAndSetProperty("dfs.provided.aliasmap.inmemory.leveldb.dir");
        this.createDirAndSetProperty("fs.s3a.committer.staging.tmp.path");
    }

    public boolean isNewVersionBehaviorEnabled() {
        String propName = "hbase.tests.new.version.behavior";
        String v = System.getProperty("hbase.tests.new.version.behavior");
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return false;
    }

    public boolean isReadShortCircuitOn() {
        String propName = "hbase.tests.use.shortcircuit.reads";
        String readOnProp = System.getProperty("hbase.tests.use.shortcircuit.reads");
        if (readOnProp != null) {
            return Boolean.parseBoolean(readOnProp);
        }
        return this.conf.getBoolean("hbase.tests.use.shortcircuit.reads", false);
    }

    private void enableShortCircuit() {
        if (this.isReadShortCircuitOn()) {
            String curUser = System.getProperty("user.name");
            LOG.info("read short circuit is ON for user " + curUser);
            this.conf.set("dfs.block.local-path-access.user", curUser);
            this.conf.setBoolean("dfs.client.read.shortcircuit", true);
            this.conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
        } else {
            LOG.info("read short circuit is OFF");
        }
    }

    private String createDirAndSetProperty(String property) {
        return this.createDirAndSetProperty(property, property);
    }

    private String createDirAndSetProperty(String relPath, String property) {
        String path = this.getDataTestDir(relPath).toString();
        System.setProperty(property, path);
        this.conf.set(property, path);
        new File(path).mkdirs();
        LOG.info("Setting " + property + " to " + path + " in system properties and HBase conf");
        return path;
    }

    public void shutdownMiniDFSCluster() throws IOException {
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
            if (this.dfsClusterFixer != null) {
                this.dfsClusterFixer.shutdown();
                this.dfsClusterFixer = null;
            }
            this.dataTestDirOnTestFS = null;
            CommonFSUtils.setFsDefault((Configuration)this.conf, (Path)new Path("file:///"));
        }
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(boolean createWALDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().createWALDir(createWALDir).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numSlaves, boolean createRootDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(numSlaves).numDataNodes(numSlaves).createRootDir(createRootDir).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numSlaves, boolean createRootDir, boolean createWALDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(numSlaves).numDataNodes(numSlaves).createRootDir(createRootDir).createWALDir(createWALDir).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, boolean createRootDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numSlaves).createRootDir(createRootDir).numDataNodes(numSlaves).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numSlaves).numDataNodes(numSlaves).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts, boolean createRootDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numSlaves).createRootDir(createRootDir).numDataNodes(numSlaves).dataNodeHosts(dataNodeHosts).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numSlaves).numDataNodes(numSlaves).dataNodeHosts(dataNodeHosts).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numRegionServers, int numDataNodes) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numRegionServers).numDataNodes(numDataNodes).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> rsClass) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).masterClass(masterClass).numRegionServers(numSlaves).rsClass(rsClass).numDataNodes(numSlaves).dataNodeHosts(dataNodeHosts).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numRegionServers, int numDataNodes, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> rsClass) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).masterClass(masterClass).numRegionServers(numRegionServers).rsClass(rsClass).numDataNodes(numDataNodes).dataNodeHosts(dataNodeHosts).build();
        return this.startMiniCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniCluster(int numMasters, int numRegionServers, int numDataNodes, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> rsClass, boolean createRootDir, boolean createWALDir) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).masterClass(masterClass).numRegionServers(numRegionServers).rsClass(rsClass).numDataNodes(numDataNodes).dataNodeHosts(dataNodeHosts).createRootDir(createRootDir).createWALDir(createWALDir).build();
        return this.startMiniCluster(option);
    }

    public MiniHBaseCluster startMiniCluster(int numSlaves) throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(numSlaves).numDataNodes(numSlaves).build();
        return this.startMiniCluster(option);
    }

    public MiniHBaseCluster startMiniCluster() throws Exception {
        return this.startMiniCluster(StartMiniClusterOption.builder().build());
    }

    public MiniHBaseCluster startMiniCluster(StartMiniClusterOption option) throws Exception {
        LOG.info("Starting up minicluster with option: {}", (Object)option);
        if (this.miniClusterRunning) {
            throw new IllegalStateException("A mini-cluster is already running");
        }
        this.miniClusterRunning = true;
        this.setupClusterTestDir();
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        if (this.dfsCluster == null) {
            LOG.info("STARTING DFS");
            this.dfsCluster = this.startMiniDFSCluster(option.getNumDataNodes(), option.getDataNodeHosts());
        } else {
            LOG.info("NOT STARTING DFS");
        }
        if (this.getZkCluster() == null) {
            this.startMiniZKCluster(option.getNumZkServers(), new int[0]);
        }
        return this.startMiniHBaseCluster(option);
    }

    public MiniHBaseCluster startMiniHBaseCluster(StartMiniClusterOption option) throws IOException, InterruptedException {
        this.createRootDir(option.isCreateRootDir());
        if (option.isCreateWALDir()) {
            this.createWALRootDir();
        }
        this.setHBaseFsTmpDir();
        if (this.conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", option.getNumRegionServers());
        }
        if (this.conf.getInt("hbase.master.wait.on.regionservers.maxtostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", option.getNumRegionServers());
        }
        Configuration c = new Configuration(this.conf);
        this.hbaseCluster = new MiniHBaseCluster(c, option.getNumMasters(), option.getNumAlwaysStandByMasters(), option.getNumRegionServers(), option.getRsPorts(), option.getMasterClass(), option.getRsClass());
        this.conf.set("hbase.masters", MasterRegistry.getMasterAddr((Configuration)c));
        try (Table t = this.getConnection().getTable(TableName.META_TABLE_NAME);
             ResultScanner s = t.getScanner(new Scan());){
            while (s.next() != null) {
            }
        }
        this.getAdmin();
        LOG.info("Minicluster is up; activeMaster={}", (Object)this.getHBaseCluster().getMaster());
        return (MiniHBaseCluster)this.hbaseCluster;
    }

    public MiniHBaseCluster startMiniHBaseCluster() throws IOException, InterruptedException {
        return this.startMiniHBaseCluster(StartMiniClusterOption.builder().build());
    }

    @Deprecated
    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numRegionServers) throws IOException, InterruptedException {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numRegionServers).build();
        return this.startMiniHBaseCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numRegionServers, List<Integer> rsPorts) throws IOException, InterruptedException {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).numRegionServers(numRegionServers).rsPorts(rsPorts).build();
        return this.startMiniHBaseCluster(option);
    }

    @Deprecated
    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numRegionServers, List<Integer> rsPorts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> rsClass, boolean createRootDir, boolean createWALDir) throws IOException, InterruptedException {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(numMasters).masterClass(masterClass).numRegionServers(numRegionServers).rsClass(rsClass).rsPorts(rsPorts).createRootDir(createRootDir).createWALDir(createWALDir).build();
        return this.startMiniHBaseCluster(option);
    }

    public void restartHBaseCluster(int servers) throws IOException, InterruptedException {
        this.restartHBaseCluster(servers, null);
    }

    public void restartHBaseCluster(int servers, List<Integer> ports) throws IOException, InterruptedException {
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(servers).rsPorts(ports).build();
        this.restartHBaseCluster(option);
        this.invalidateConnection();
    }

    public void restartHBaseCluster(StartMiniClusterOption option) throws IOException, InterruptedException {
        this.closeConnection();
        this.hbaseCluster = new MiniHBaseCluster(this.conf, option.getNumMasters(), option.getNumAlwaysStandByMasters(), option.getNumRegionServers(), option.getRsPorts(), option.getMasterClass(), option.getRsClass());
        Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
        Table t = conn.getTable(TableName.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        LOG.info("HBase has been restarted");
        s.close();
        t.close();
        conn.close();
    }

    public MiniHBaseCluster getMiniHBaseCluster() {
        if (this.hbaseCluster == null || this.hbaseCluster instanceof MiniHBaseCluster) {
            return (MiniHBaseCluster)this.hbaseCluster;
        }
        throw new RuntimeException(this.hbaseCluster + " not an instance of " + MiniHBaseCluster.class.getName());
    }

    public void shutdownMiniCluster() throws IOException {
        LOG.info("Shutting down minicluster");
        this.shutdownMiniHBaseCluster();
        this.shutdownMiniDFSCluster();
        this.shutdownMiniZKCluster();
        this.cleanupTestDir();
        this.miniClusterRunning = false;
        LOG.info("Minicluster is down");
    }

    public void shutdownMiniHBaseCluster() throws IOException {
        this.cleanup();
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.waitUntilShutDown();
            this.hbaseCluster = null;
        }
        if (this.zooKeeperWatcher != null) {
            this.zooKeeperWatcher.close();
            this.zooKeeperWatcher = null;
        }
    }

    public void killMiniHBaseCluster() throws IOException {
        this.cleanup();
        if (this.hbaseCluster != null) {
            this.getMiniHBaseCluster().killAll();
            this.hbaseCluster = null;
        }
        if (this.zooKeeperWatcher != null) {
            this.zooKeeperWatcher.close();
            this.zooKeeperWatcher = null;
        }
    }

    private void cleanup() throws IOException {
        this.closeConnection();
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", -1);
        this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", -1);
    }

    public Path getDefaultRootDirPath(boolean create) throws IOException {
        if (!create) {
            return this.getDataTestDirOnTestFS();
        }
        return this.getNewDataTestDirOnTestFS();
    }

    public Path getDefaultRootDirPath() throws IOException {
        return this.getDefaultRootDirPath(false);
    }

    public Path createRootDir(boolean create) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path hbaseRootdir = this.getDefaultRootDirPath(create);
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)hbaseRootdir);
        fs.mkdirs(hbaseRootdir);
        FSUtils.setVersion((FileSystem)fs, (Path)hbaseRootdir);
        return hbaseRootdir;
    }

    public Path createRootDir() throws IOException {
        return this.createRootDir(false);
    }

    public Path createWALRootDir() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path walDir = this.getNewDataTestDirOnTestFS();
        CommonFSUtils.setWALRootDir((Configuration)this.conf, (Path)walDir);
        fs.mkdirs(walDir);
        return walDir;
    }

    private void setHBaseFsTmpDir() throws IOException {
        String hbaseFsTmpDirInString = this.conf.get("hbase.fs.tmp.dir");
        if (hbaseFsTmpDirInString == null) {
            this.conf.set("hbase.fs.tmp.dir", this.getDataTestDirOnTestFS("hbase-staging").toString());
            LOG.info("Setting hbase.fs.tmp.dir to " + this.conf.get("hbase.fs.tmp.dir"));
        } else {
            LOG.info("The hbase.fs.tmp.dir is set to " + hbaseFsTmpDirInString);
        }
    }

    public void flush() throws IOException {
        this.getMiniHBaseCluster().flushcache();
    }

    public void flush(TableName tableName) throws IOException {
        this.getMiniHBaseCluster().flushcache(tableName);
    }

    public void compact(boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(major);
    }

    public void compact(TableName tableName, boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(tableName, major);
    }

    public Table createTable(TableName tableName, String family) throws IOException {
        return this.createTable(tableName, new String[]{family});
    }

    public Table createTable(TableName tableName, String[] families) throws IOException {
        ArrayList<byte[]> fams = new ArrayList<byte[]>(families.length);
        for (String family : families) {
            fams.add(Bytes.toBytes((String)family));
        }
        return this.createTable(tableName, (byte[][])fams.toArray((T[])new byte[0][]));
    }

    public Table createTable(TableName tableName, byte[] family) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family});
    }

    public Table createMultiRegionTable(TableName tableName, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        return this.createTable(tableName, (byte[][])new byte[][]{family}, splitKeys);
    }

    public Table createTable(TableName tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, (byte[][])null);
    }

    public Table createMultiRegionTable(TableName tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, KEYS_FOR_HBA_CREATE_TABLE);
    }

    public Table createMultiRegionTable(TableName tableName, int replicaCount, byte[][] families) throws IOException {
        return this.createTable(tableName, families, KEYS_FOR_HBA_CREATE_TABLE, replicaCount);
    }

    public Table createTable(TableName tableName, byte[][] families, byte[][] splitKeys) throws IOException {
        return this.createTable(tableName, families, splitKeys, 1, new Configuration(this.getConfiguration()));
    }

    public Table createTable(TableName tableName, byte[][] families, byte[][] splitKeys, int replicaCount) throws IOException {
        return this.createTable(tableName, families, splitKeys, replicaCount, new Configuration(this.getConfiguration()));
    }

    public Table createTable(TableName tableName, byte[][] families, int numVersions, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor desc = this.createTableDescriptor(tableName, families, numVersions);
        this.getAdmin().createTable((TableDescriptor)desc, startKey, endKey, numRegions);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createTable(TableDescriptor htd, byte[][] families, Configuration c) throws IOException {
        return this.createTable(htd, families, (byte[][])null, c);
    }

    public Table createTable(TableDescriptor htd, byte[][] families, byte[][] splitKeys, Configuration c) throws IOException {
        return this.createTable(htd, families, splitKeys, BloomType.NONE, 65536, c);
    }

    public Table createTable(TableDescriptor htd, byte[][] families, byte[][] splitKeys, BloomType type, int blockSize, Configuration c) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)htd);
        for (byte[] family : families) {
            ColumnFamilyDescriptorBuilder cfdb = ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setBloomFilterType(type).setBlocksize(blockSize);
            if (this.isNewVersionBehaviorEnabled()) {
                cfdb.setNewVersionBehavior(true);
            }
            builder.setColumnFamily(cfdb.build());
        }
        TableDescriptor td = builder.build();
        this.getAdmin().createTable(td, splitKeys);
        this.waitUntilAllRegionsAssigned(td.getTableName());
        return this.getConnection().getTable(td.getTableName());
    }

    public Table createTable(TableDescriptor htd, byte[][] splitRows) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)htd);
        if (this.isNewVersionBehaviorEnabled()) {
            for (ColumnFamilyDescriptor family : htd.getColumnFamilies()) {
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)family).setNewVersionBehavior(true).build());
            }
        }
        this.getAdmin().createTable(builder.build(), splitRows);
        this.waitUntilAllRegionsAssigned(htd.getTableName());
        return this.getConnection().getTable(htd.getTableName());
    }

    public Table createTable(TableName tableName, byte[][] families, byte[][] splitKeys, int replicaCount, Configuration c) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setRegionReplication(replicaCount);
        return this.createTable((TableDescriptor)htd, families, splitKeys, c);
    }

    public Table createTable(TableName tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    public Table createTable(TableName tableName, byte[][] families, int numVersions) throws IOException {
        return this.createTable(tableName, families, numVersions, (byte[][])null);
    }

    public Table createTable(TableName tableName, byte[][] families, int numVersions, byte[][] splitKeys) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            desc.addFamily(hcd);
        }
        this.getAdmin().createTable((TableDescriptor)desc, splitKeys);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createMultiRegionTable(TableName tableName, byte[][] families, int numVersions) throws IOException {
        return this.createTable(tableName, families, numVersions, KEYS_FOR_HBA_CREATE_TABLE);
    }

    public Table createTable(TableName tableName, byte[][] families, int numVersions, int blockSize) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions).setBlocksize(blockSize);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            desc.addFamily(hcd);
        }
        this.getAdmin().createTable((TableDescriptor)desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createTable(TableName tableName, byte[][] families, int numVersions, int blockSize, String cpName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions).setBlocksize(blockSize);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            desc.addFamily(hcd);
        }
        if (cpName != null) {
            desc.addCoprocessor(cpName);
        }
        this.getAdmin().createTable((TableDescriptor)desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createTable(TableName tableName, byte[][] families, int[] numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions[i]);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            desc.addFamily(hcd);
            ++i;
        }
        this.getAdmin().createTable((TableDescriptor)desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createTable(TableName tableName, byte[] family, byte[][] splitRows) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        if (this.isNewVersionBehaviorEnabled()) {
            hcd.setNewVersionBehavior(true);
        }
        desc.addFamily(hcd);
        this.getAdmin().createTable((TableDescriptor)desc, splitRows);
        this.waitUntilAllRegionsAssigned(tableName);
        return this.getConnection().getTable(tableName);
    }

    public Table createMultiRegionTable(TableName tableName, byte[] family) throws IOException {
        return this.createTable(tableName, family, KEYS_FOR_HBA_CREATE_TABLE);
    }

    public static void modifyTableSync(Admin admin, TableDescriptor desc) throws IOException, InterruptedException {
        admin.modifyTable(desc);
        Pair<Integer, Integer> status = new Pair<Integer, Integer>(){
            {
                this.setFirst(0);
                this.setSecond(0);
            }
        };
        int i = 0;
        do {
            if ((Integer)(status = admin.getAlterStatus(desc.getTableName())).getSecond() == 0) {
                LOG.debug("All regions updated.");
                break;
            }
            LOG.debug((Integer)status.getSecond() - (Integer)status.getFirst() + "/" + status.getSecond() + " regions updated.");
            Thread.sleep(1000L);
        } while ((Integer)status.getFirst() != 0 && i++ < 500);
        if ((Integer)status.getFirst() != 0) {
            throw new IOException("Failed to update all regions even after 500 seconds.");
        }
    }

    public static void setReplicas(Admin admin, TableName table, int replicaCount) throws IOException, InterruptedException {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(table)).setRegionReplication(replicaCount).build();
        admin.modifyTable(desc);
    }

    public static void setReplicas(AsyncAdmin admin, TableName table, int replicaCount) throws ExecutionException, IOException, InterruptedException {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableDescriptor)((TableDescriptor)admin.getDescriptor(table).get())).setRegionReplication(replicaCount).build();
        admin.modifyTable(desc).get();
    }

    public void deleteTable(TableName tableName) throws IOException {
        try {
            this.getAdmin().disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOG.debug("Table: " + tableName + " already disabled, so just deleting it.");
        }
        this.getAdmin().deleteTable(tableName);
    }

    public void deleteTableIfAny(TableName tableName) throws IOException {
        try {
            this.deleteTable(tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    public TableDescriptorBuilder.ModifyableTableDescriptor createModifyableTableDescriptor(String name) {
        return this.createModifyableTableDescriptor(TableName.valueOf((String)name), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED);
    }

    public TableDescriptorBuilder.ModifyableTableDescriptor createModifyableTableDescriptor(TableName name, int minVersions, int versions, int ttl, KeepDeletedCells keepDeleted) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)name);
        for (byte[] cfName : new byte[][]{fam1, fam2, fam3}) {
            ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])cfName).setMinVersions(minVersions).setMaxVersions(versions).setKeepDeletedCells(keepDeleted).setBlockCacheEnabled(false).setTimeToLive(ttl);
            if (this.isNewVersionBehaviorEnabled()) {
                cfBuilder.setNewVersionBehavior(true);
            }
            builder.setColumnFamily(cfBuilder.build());
        }
        return new TableDescriptorBuilder.ModifyableTableDescriptor(name, builder.build());
    }

    @Deprecated
    public HTableDescriptor createTableDescriptor(String name, int minVersions, int versions, int ttl, KeepDeletedCells keepDeleted) {
        return this.createTableDescriptor(TableName.valueOf((String)name), minVersions, versions, ttl, keepDeleted);
    }

    @Deprecated
    public HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(TableName.valueOf((String)name), 0, 3, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_KEEP_DELETED);
    }

    public HTableDescriptor createTableDescriptor(TableName name, int minVersions, int versions, int ttl, KeepDeletedCells keepDeleted) {
        HTableDescriptor htd = new HTableDescriptor(name);
        for (byte[] cfName : new byte[][]{fam1, fam2, fam3}) {
            HColumnDescriptor hcd = new HColumnDescriptor(cfName).setMinVersions(minVersions).setMaxVersions(versions).setKeepDeletedCells(keepDeleted).setBlockCacheEnabled(false).setTimeToLive(ttl);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            htd.addFamily(hcd);
        }
        return htd;
    }

    public HTableDescriptor createTableDescriptor(TableName name) {
        return this.createTableDescriptor(name, 0, 3, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_KEEP_DELETED);
    }

    public HTableDescriptor createTableDescriptor(TableName tableName, byte[] family) {
        return this.createTableDescriptor(tableName, new byte[][]{family}, 1);
    }

    public HTableDescriptor createTableDescriptor(TableName tableName, byte[][] families, int maxVersions) {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(maxVersions);
            if (this.isNewVersionBehaviorEnabled()) {
                hcd.setNewVersionBehavior(true);
            }
            desc.addFamily(hcd);
        }
        return desc;
    }

    public HRegion createLocalHRegion(TableDescriptor desc, byte[] startKey, byte[] endKey) throws IOException {
        HRegionInfo hri = new HRegionInfo(desc.getTableName(), startKey, endKey);
        return this.createLocalHRegion((RegionInfo)hri, desc);
    }

    public HRegion createLocalHRegion(RegionInfo info, TableDescriptor desc) throws IOException {
        return HBaseTestingUtility.createRegionAndWAL(info, this.getDataTestDir(), this.getConfiguration(), desc);
    }

    public HRegion createLocalHRegion(RegionInfo info, Configuration conf, TableDescriptor desc, WAL wal) throws IOException {
        return HRegion.createHRegion((RegionInfo)info, (Path)this.getDataTestDir(), (Configuration)conf, (TableDescriptor)desc, (WAL)wal);
    }

    public HRegion createLocalHRegion(HRegionInfo info, Configuration conf, HTableDescriptor desc, WAL wal) throws IOException {
        return HRegion.createHRegion((RegionInfo)info, (Path)this.getDataTestDir(), (Configuration)conf, (TableDescriptor)desc, (WAL)wal);
    }

    @Deprecated
    public HRegion createLocalHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        return this.createLocalHRegion(TableName.valueOf((byte[])tableName), startKey, stopKey, conf, isReadOnly, durability, wal, families);
    }

    public HRegion createLocalHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        return this.createLocalHRegionWithInMemoryFlags(tableName, startKey, stopKey, conf, isReadOnly, durability, wal, null, families);
    }

    public HRegion createLocalHRegionWithInMemoryFlags(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, boolean[] compactedMemStore, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setReadOnly(isReadOnly);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            if (compactedMemStore != null && i < compactedMemStore.length) {
                hcd.setInMemoryCompaction(MemoryCompactionPolicy.BASIC);
            } else {
                hcd.setInMemoryCompaction(MemoryCompactionPolicy.NONE);
            }
            ++i;
            hcd.setMaxVersions(Integer.MAX_VALUE);
            htd.addFamily(hcd);
        }
        htd.setDurability(durability);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), startKey, stopKey, false);
        return this.createLocalHRegion(info, conf, htd, wal);
    }

    public Table deleteTableData(TableName tableName) throws IOException {
        Table table = this.getConnection().getTable(tableName);
        Scan scan = new Scan();
        ResultScanner resScan = table.getScanner(scan);
        for (Result res : resScan) {
            Delete del = new Delete(res.getRow());
            table.delete(del);
        }
        resScan = table.getScanner(scan);
        resScan.close();
        return table;
    }

    public Table truncateTable(TableName tableName, boolean preserveRegions) throws IOException {
        Admin admin = this.getAdmin();
        if (!admin.isTableDisabled(tableName)) {
            admin.disableTable(tableName);
        }
        admin.truncateTable(tableName, preserveRegions);
        return this.getConnection().getTable(tableName);
    }

    public Table truncateTable(TableName tableName) throws IOException {
        return this.truncateTable(tableName, false);
    }

    public int loadTable(Table t, byte[] f) throws IOException {
        return this.loadTable(t, new byte[][]{f});
    }

    public int loadTable(Table t, byte[] f, boolean writeToWAL) throws IOException {
        return this.loadTable(t, new byte[][]{f}, null, writeToWAL);
    }

    public int loadTable(Table t, byte[][] f) throws IOException {
        return this.loadTable(t, f, null);
    }

    public int loadTable(Table t, byte[][] f, byte[] value) throws IOException {
        return this.loadTable(t, f, value, true);
    }

    public int loadTable(Table t, byte[][] f, byte[] value, boolean writeToWAL) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] row : ROWS) {
            Put put = new Put(row);
            put.setDurability(writeToWAL ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            for (int i = 0; i < f.length; ++i) {
                byte[] value1 = value != null ? value : row;
                put.addColumn(f[i], f[i], value1);
            }
            puts.add(put);
        }
        t.put(puts);
        return puts.size();
    }

    public int loadRegion(HRegion r, byte[] f) throws IOException {
        return this.loadRegion(r, f, false);
    }

    public int loadRegion(Region r, byte[] f) throws IOException {
        return this.loadRegion((HRegion)r, f);
    }

    public int loadRegion(HRegion r, byte[] f, boolean flush) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.setDurability(Durability.SKIP_WAL);
                    put.addColumn(f, null, k);
                    if (r.getWAL() == null) {
                        put.setDurability(Durability.SKIP_WAL);
                    }
                    int preRowCount = rowCount;
                    int pause = 10;
                    int maxPause = 1000;
                    while (rowCount == preRowCount) {
                        try {
                            r.put(put);
                            ++rowCount;
                        }
                        catch (RegionTooBusyException e) {
                            pause = pause * 2 >= maxPause ? maxPause : pause * 2;
                            Threads.sleep((long)pause);
                        }
                    }
                }
            }
            if (!flush) continue;
            r.flush(true);
        }
        return rowCount;
    }

    public void loadNumericRows(Table t, byte[] f, int startRow, int endRow) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Put put = new Put(data);
            put.addColumn(f, null, data);
            t.put(put);
        }
    }

    public void loadRandomRows(Table t, byte[] f, int rowSize, int totalRows) throws IOException {
        byte[] row = new byte[rowSize];
        for (int i = 0; i < totalRows; ++i) {
            Bytes.random((byte[])row);
            Put put = new Put(row);
            put.addColumn(f, new byte[]{0}, new byte[]{0});
            t.put(put);
        }
    }

    public void verifyNumericRows(Table table, byte[] f, int startRow, int endRow, int replicaId) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            String failMsg = "Failed verification of row :" + i;
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Get get = new Get(data);
            get.setReplicaId(replicaId);
            get.setConsistency(Consistency.TIMELINE);
            Result result = table.get(get);
            Assert.assertTrue((String)failMsg, (boolean)result.containsColumn(f, null));
            Assert.assertEquals((String)failMsg, (long)1L, (long)result.getColumnCells(f, null).size());
            Cell cell = result.getColumnLatestCell(f, null);
            Assert.assertTrue((String)failMsg, (boolean)Bytes.equals((byte[])data, (int)0, (int)data.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
    }

    public void verifyNumericRows(Region region, byte[] f, int startRow, int endRow) throws IOException {
        this.verifyNumericRows((HRegion)region, f, startRow, endRow);
    }

    public void verifyNumericRows(HRegion region, byte[] f, int startRow, int endRow) throws IOException {
        this.verifyNumericRows(region, f, startRow, endRow, true);
    }

    public void verifyNumericRows(Region region, byte[] f, int startRow, int endRow, boolean present) throws IOException {
        this.verifyNumericRows((HRegion)region, f, startRow, endRow, present);
    }

    public void verifyNumericRows(HRegion region, byte[] f, int startRow, int endRow, boolean present) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            String failMsg = "Failed verification of row :" + i;
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Result result = region.get(new Get(data));
            boolean hasResult = result != null && !result.isEmpty();
            Assert.assertEquals((String)(failMsg + result), (Object)present, (Object)hasResult);
            if (!present) continue;
            Assert.assertTrue((String)failMsg, (boolean)result.containsColumn(f, null));
            Assert.assertEquals((String)failMsg, (long)1L, (long)result.getColumnCells(f, null).size());
            Cell cell = result.getColumnLatestCell(f, null);
            Assert.assertTrue((String)failMsg, (boolean)Bytes.equals((byte[])data, (int)0, (int)data.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
    }

    public void deleteNumericRows(Table t, byte[] f, int startRow, int endRow) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Delete delete = new Delete(data);
            delete.addFamily(f);
            t.delete(delete);
        }
    }

    public int countRows(Table table) throws IOException {
        return this.countRows(table, new Scan());
    }

    public int countRows(Table table, Scan scan) throws IOException {
        try (ResultScanner results = table.getScanner(scan);){
            int count = 0;
            while (results.next() != null) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public int countRows(Table table, byte[] ... families) throws IOException {
        Scan scan = new Scan();
        for (byte[] family : families) {
            scan.addFamily(family);
        }
        return this.countRows(table, scan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRows(TableName tableName) throws IOException {
        try (Table table = this.getConnection().getTable(tableName);){
            int n = this.countRows(table);
            return n;
        }
    }

    public int countRows(Region region) throws IOException {
        return this.countRows(region, new Scan());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRows(Region region, Scan scan) throws IOException {
        try (RegionScanner scanner = region.getScanner(scan);){
            int n = this.countRows((InternalScanner)scanner);
            return n;
        }
    }

    public int countRows(InternalScanner scanner) throws IOException {
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            scannedCount += results.size();
            results.clear();
        }
        return scannedCount;
    }

    public String checksumRows(Table table) throws Exception {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (Result res : results) {
            digest.update(res.getRow());
        }
        results.close();
        return digest.toString();
    }

    @Deprecated
    public List<HRegionInfo> createMultiRegionsInMeta(Configuration conf, HTableDescriptor htd, byte[][] startKeys) throws IOException {
        return this.createMultiRegionsInMeta(conf, (TableDescriptor)htd, startKeys).stream().map(ImmutableHRegionInfo::new).collect(Collectors.toList());
    }

    public List<RegionInfo> createMultiRegionsInMeta(Configuration conf, TableDescriptor htd, byte[][] startKeys) throws IOException {
        Table meta = this.getConnection().getTable(TableName.META_TABLE_NAME);
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        ArrayList<RegionInfo> newRegions = new ArrayList<RegionInfo>(startKeys.length);
        MetaTableAccessor.updateTableState((Connection)this.getConnection(), (TableName)htd.getTableName(), (TableState.State)TableState.State.ENABLED);
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(startKeys[i]).setEndKey(startKeys[j]).build();
            MetaTableAccessor.addRegionsToMeta((Connection)this.getConnection(), Collections.singletonList(hri), (int)1);
            newRegions.add(hri);
        }
        meta.close();
        return newRegions;
    }

    public static WAL createWal(Configuration conf, Path rootDir, RegionInfo hri) throws IOException {
        Configuration confForWAL = new Configuration(conf);
        confForWAL.set("hbase.rootdir", rootDir.toString());
        return new WALFactory(confForWAL, "hregion-" + RandomStringUtils.randomNumeric((int)8)).getWAL(hri);
    }

    public static HRegion createRegionAndWAL(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor htd) throws IOException {
        return HBaseTestingUtility.createRegionAndWAL(info, rootDir, conf, htd, true);
    }

    public static HRegion createRegionAndWAL(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor htd, BlockCache blockCache) throws IOException {
        HRegion region = HBaseTestingUtility.createRegionAndWAL(info, rootDir, conf, htd, false);
        region.setBlockCache(blockCache);
        region.initialize();
        return region;
    }

    public static HRegion createRegionAndWAL(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor htd, MobFileCache mobFileCache) throws IOException {
        HRegion region = HBaseTestingUtility.createRegionAndWAL(info, rootDir, conf, htd, false);
        region.setMobFileCache(mobFileCache);
        region.initialize();
        return region;
    }

    public static HRegion createRegionAndWAL(RegionInfo info, Path rootDir, Configuration conf, TableDescriptor htd, boolean initialize) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        WAL wal = HBaseTestingUtility.createWal(conf, rootDir, info);
        return HRegion.createHRegion((RegionInfo)info, (Path)rootDir, (Configuration)conf, (TableDescriptor)htd, (WAL)wal, (boolean)initialize);
    }

    public List<byte[]> getMetaTableRows() throws IOException {
        Table t = this.getConnection().getTable(TableName.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            LOG.info("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow()));
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    public List<byte[]> getMetaTableRows(TableName tableName) throws IOException {
        Table t = this.getConnection().getTable(TableName.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            RegionInfo info = MetaTableAccessor.getRegionInfo((Result)result);
            if (info == null) {
                LOG.error("No region info for row " + Bytes.toString((byte[])result.getRow()));
                continue;
            }
            if (!info.getTable().equals((Object)tableName)) continue;
            LOG.info("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow()) + info);
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    private List<RegionInfo> getRegions(TableName tableName) throws IOException {
        try (Admin admin = this.getConnection().getAdmin();){
            List list = admin.getRegions(tableName);
            return list;
        }
    }

    public HRegionServer getOtherRegionServer(HRegionServer rs) {
        for (JVMClusterUtil.RegionServerThread rst : this.getMiniHBaseCluster().getRegionServerThreads()) {
            if (rst.getRegionServer() == rs) continue;
            return rst.getRegionServer();
        }
        return null;
    }

    public HRegionServer getRSForFirstRegionInTable(TableName tableName) throws IOException, InterruptedException {
        List<RegionInfo> regions = this.getRegions(tableName);
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        LOG.debug("Found " + regions.size() + " regions for table " + tableName);
        byte[] firstRegionName = regions.stream().filter(r -> !r.isOffline()).map(RegionInfo::getRegionName).findFirst().orElseThrow(() -> new IOException("online regions not found in table " + tableName));
        LOG.debug("firstRegionName=" + Bytes.toString((byte[])firstRegionName));
        long pause = this.getConfiguration().getLong("hbase.client.pause", 100L);
        int numRetries = this.getConfiguration().getInt("hbase.client.retries.number", 15);
        RetryCounter retrier = new RetryCounter(numRetries + 1, (long)((int)pause), TimeUnit.MICROSECONDS);
        while (retrier.shouldRetry()) {
            int index = this.getMiniHBaseCluster().getServerWith(firstRegionName);
            if (index != -1) {
                return this.getMiniHBaseCluster().getRegionServerThreads().get(index).getRegionServer();
            }
            retrier.sleepUntilNextRetry();
        }
        return null;
    }

    public MiniMRCluster startMiniMapReduceCluster() throws IOException {
        this.conf.setIfUnset("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", "99.0");
        this.startMiniMapReduceCluster(2);
        return this.mrCluster;
    }

    private void forceChangeTaskLogDir() {
        try {
            Field logDirField = TaskLog.class.getDeclaredField("LOG_DIR");
            logDirField.setAccessible(true);
            Field modifiersField = ReflectionUtils.getModifiersField();
            modifiersField.setAccessible(true);
            modifiersField.setInt(logDirField, logDirField.getModifiers() & 0xFFFFFFEF);
            logDirField.set(null, new File(this.hadoopLogDir, "userlogs"));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void startMiniMapReduceCluster(int servers) throws IOException {
        String yarnRMWebappAddress;
        String mrJobHistoryWebappAddress;
        String schedulerAddress;
        String historyAddress;
        if (this.mrCluster != null) {
            throw new IllegalStateException("MiniMRCluster is already running");
        }
        LOG.info("Starting mini mapreduce cluster...");
        this.setupClusterTestDir();
        this.createDirsAndSetProperties();
        this.forceChangeTaskLogDir();
        this.conf.setFloat("yarn.nodemanager.vmem-pmem-ratio", 8.0f);
        this.conf.setBoolean("mapreduce.map.speculative", false);
        this.conf.setBoolean("mapreduce.reduce.speculative", false);
        if (JVM.getJVMSpecVersion() >= 17) {
            String jvmOpts = this.conf.get("yarn.app.mapreduce.am.command-opts", "");
            this.conf.set("yarn.app.mapreduce.am.command-opts", jvmOpts + " --add-opens java.base/java.lang=ALL-UNNAMED");
        }
        this.mrCluster = new MiniMRCluster(servers, FS_URI != null ? FS_URI : FileSystem.get((Configuration)this.conf).getUri().toString(), 1, null, null, new JobConf(this.conf));
        JobConf jobConf = MapreduceTestingShim.getJobConf(this.mrCluster);
        if (jobConf == null) {
            jobConf = this.mrCluster.createJobConf();
        }
        jobConf.set("mapreduce.cluster.local.dir", this.conf.get("mapreduce.cluster.local.dir"));
        LOG.info("Mini mapreduce cluster started");
        this.conf.set("mapreduce.jobtracker.address", jobConf.get("mapreduce.jobtracker.address"));
        this.conf.set("mapreduce.framework.name", "yarn");
        this.conf.setBoolean("yarn.is.minicluster", true);
        String rmAddress = jobConf.get("yarn.resourcemanager.address");
        if (rmAddress != null) {
            this.conf.set("yarn.resourcemanager.address", rmAddress);
        }
        if ((historyAddress = jobConf.get("mapreduce.jobhistory.address")) != null) {
            this.conf.set("mapreduce.jobhistory.address", historyAddress);
        }
        if ((schedulerAddress = jobConf.get("yarn.resourcemanager.scheduler.address")) != null) {
            this.conf.set("yarn.resourcemanager.scheduler.address", schedulerAddress);
        }
        if ((mrJobHistoryWebappAddress = jobConf.get("mapreduce.jobhistory.webapp.address")) != null) {
            this.conf.set("mapreduce.jobhistory.webapp.address", mrJobHistoryWebappAddress);
        }
        if ((yarnRMWebappAddress = jobConf.get("yarn.resourcemanager.webapp.address")) != null) {
            this.conf.set("yarn.resourcemanager.webapp.address", yarnRMWebappAddress);
        }
    }

    public void shutdownMiniMapReduceCluster() {
        if (this.mrCluster != null) {
            LOG.info("Stopping mini mapreduce cluster...");
            this.mrCluster.shutdown();
            this.mrCluster = null;
            LOG.info("Mini mapreduce cluster stopped");
        }
        this.conf.set("mapreduce.jobtracker.address", "local");
    }

    public RegionServerServices createMockRegionServerService() throws IOException {
        return this.createMockRegionServerService((ServerName)null);
    }

    public RegionServerServices createMockRegionServerService(RpcServerInterface rpc) throws IOException {
        MockRegionServerServices rss = new MockRegionServerServices(this.getZooKeeperWatcher());
        rss.setFileSystem(this.getTestFileSystem());
        rss.setRpcServer(rpc);
        return rss;
    }

    public RegionServerServices createMockRegionServerService(ServerName name) throws IOException {
        MockRegionServerServices rss = new MockRegionServerServices(this.getZooKeeperWatcher(), name);
        rss.setFileSystem(this.getTestFileSystem());
        return rss;
    }

    @Deprecated
    public void enableDebug(Class<?> clazz) {
        Log4jUtils.enableDebug(clazz);
    }

    public void expireMasterSession() throws Exception {
        HMaster master = this.getMiniHBaseCluster().getMaster();
        this.expireSession(master.getZooKeeper(), false);
    }

    public void expireRegionServerSession(int index) throws Exception {
        HRegionServer rs = this.getMiniHBaseCluster().getRegionServer(index);
        this.expireSession(rs.getZooKeeper(), false);
        this.decrementMinRegionServerCount();
    }

    private void decrementMinRegionServerCount() {
        this.decrementMinRegionServerCount(this.getConfiguration());
        for (JVMClusterUtil.MasterThread master : this.getHBaseCluster().getMasterThreads()) {
            this.decrementMinRegionServerCount(master.getMaster().getConfiguration());
        }
    }

    private void decrementMinRegionServerCount(Configuration conf) {
        int currentCount = conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1);
        if (currentCount != -1) {
            conf.setInt("hbase.master.wait.on.regionservers.mintostart", Math.max(currentCount - 1, 1));
        }
    }

    public void expireSession(ZKWatcher nodeZK) throws Exception {
        this.expireSession(nodeZK, false);
    }

    public void expireSession(ZKWatcher nodeZK, boolean checkStatus) throws Exception {
        Configuration c = new Configuration(this.conf);
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        ZooKeeper zk = nodeZK.getRecoverableZooKeeper().getZooKeeper();
        byte[] password = zk.getSessionPasswd();
        long sessionID = zk.getSessionId();
        ZooKeeper monitor = new ZooKeeper(quorumServers, 1000, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                HBaseCommonTestingUtility.LOG.info("Monitor ZKW received event=" + watchedEvent);
            }
        }, sessionID, password);
        ZooKeeper newZK = new ZooKeeper(quorumServers, 1000, (Watcher)EmptyWatcher.instance, sessionID, password);
        long start = EnvironmentEdgeManager.currentTime();
        while (newZK.getState() != ZooKeeper.States.CONNECTED && EnvironmentEdgeManager.currentTime() - start < 1000L) {
            Thread.sleep(1L);
        }
        newZK.close();
        LOG.info("ZK Closed Session 0x" + Long.toHexString(sessionID));
        monitor.close();
        if (checkStatus) {
            this.getConnection().getTable(TableName.META_TABLE_NAME).close();
        }
    }

    public MiniHBaseCluster getHBaseCluster() {
        return this.getMiniHBaseCluster();
    }

    public HBaseCluster getHBaseClusterInterface() {
        return this.hbaseCluster;
    }

    public void invalidateConnection() throws IOException {
        this.closeConnection();
        String masterConfigBefore = this.conf.get("hbase.masters");
        String masterConfAfter = this.getMiniHBaseCluster().conf.get("hbase.masters");
        LOG.info("Invalidated connection. Updating master addresses before: {} after: {}", (Object)masterConfigBefore, (Object)masterConfAfter);
        this.conf.set("hbase.masters", this.getMiniHBaseCluster().conf.get("hbase.masters"));
    }

    public Connection getConnection() throws IOException {
        try {
            return this.connection.updateAndGet(connection -> {
                if (connection == null) {
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)this.conf);
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException("Failed to create connection", ioe);
                    }
                }
                return connection;
            });
        }
        catch (UncheckedIOException exception) {
            throw exception.getCause();
        }
    }

    @Deprecated
    public synchronized HBaseAdmin getHBaseAdmin() throws IOException {
        if (this.hbaseAdmin == null) {
            this.hbaseAdmin = (HBaseAdmin)this.getConnection().getAdmin();
        }
        return this.hbaseAdmin;
    }

    public void closeConnection() throws IOException {
        Connection connection;
        if (this.hbaseAdmin != null) {
            Closeables.close((Closeable)this.hbaseAdmin, (boolean)true);
            this.hbaseAdmin = null;
        }
        if ((connection = (Connection)this.connection.getAndSet(null)) != null) {
            Closeables.close((Closeable)connection, (boolean)true);
        }
    }

    public synchronized Admin getAdmin() throws IOException {
        if (this.hbaseAdmin == null) {
            this.hbaseAdmin = (HBaseAdmin)this.getConnection().getAdmin();
        }
        return this.hbaseAdmin;
    }

    public Hbck getHbck() throws IOException {
        return this.getConnection().getHbck();
    }

    public void unassignRegion(String regionName) throws IOException {
        this.unassignRegion(Bytes.toBytes((String)regionName));
    }

    public void unassignRegion(byte[] regionName) throws IOException {
        this.getAdmin().unassign(regionName, true);
    }

    public void unassignRegionByRow(String row, RegionLocator table) throws IOException {
        this.unassignRegionByRow(Bytes.toBytes((String)row), table);
    }

    public void unassignRegionByRow(byte[] row, RegionLocator table) throws IOException {
        HRegionLocation hrl = table.getRegionLocation(row);
        this.unassignRegion(hrl.getRegionInfo().getRegionName());
    }

    public HRegion getSplittableRegion(TableName tableName, int maxAttempts) {
        List<HRegion> regions = this.getHBaseCluster().getRegions(tableName);
        int regCount = regions.size();
        HashSet<Integer> attempted = new HashSet<Integer>();
        int attempts = 0;
        do {
            if (regCount != (regions = this.getHBaseCluster().getRegions(tableName)).size()) {
                attempted.clear();
            }
            if ((regCount = regions.size()) > 0) {
                int idx = ThreadLocalRandom.current().nextInt(regCount);
                if (attempted.contains(idx)) continue;
                HRegion region = regions.get(idx);
                if (region.checkSplit().isPresent()) {
                    return region;
                }
                attempted.add(idx);
            }
            ++attempts;
        } while (maxAttempts == -1 || attempts < maxAttempts);
        return null;
    }

    public MiniDFSCluster getDFSCluster() {
        return this.dfsCluster;
    }

    public void setDFSCluster(MiniDFSCluster cluster) throws IllegalStateException, IOException {
        this.setDFSCluster(cluster, true);
    }

    public void setDFSCluster(MiniDFSCluster cluster, boolean requireDown) throws IllegalStateException, IOException {
        if (this.dfsCluster != null && requireDown && this.dfsCluster.isClusterUp()) {
            throw new IllegalStateException("DFSCluster is already running! Shut it down first.");
        }
        this.dfsCluster = cluster;
        this.setFs();
    }

    public FileSystem getTestFileSystem() throws IOException {
        return HFileSystem.get((Configuration)this.conf);
    }

    public void waitTableAvailable(TableName table) throws InterruptedException, IOException {
        this.waitTableAvailable(table.getName(), 30000L);
    }

    public void waitTableAvailable(TableName table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitFor(timeoutMillis, this.predicateTableAvailable(table));
    }

    public void waitTableAvailable(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitFor(timeoutMillis, this.predicateTableAvailable(TableName.valueOf((byte[])table)));
    }

    public String explainTableAvailability(TableName tableName) throws IOException {
        String msg = this.explainTableState(tableName, TableState.State.ENABLED) + ", ";
        if (this.getHBaseCluster().getMaster().isAlive()) {
            Map assignments = this.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionAssignments();
            List metaLocations = MetaTableAccessor.getTableRegionsAndLocations((Connection)this.getConnection(), (TableName)tableName);
            for (Pair metaLocation : metaLocations) {
                RegionInfo hri = (RegionInfo)metaLocation.getFirst();
                ServerName sn = (ServerName)metaLocation.getSecond();
                if (!assignments.containsKey(hri)) {
                    msg = msg + ", region " + hri + " not assigned, but found in meta, it expected to be on " + sn;
                    continue;
                }
                if (sn == null) {
                    msg = msg + ",  region " + hri + " assigned,  but has no server in meta";
                    continue;
                }
                if (sn.equals(assignments.get(hri))) continue;
                msg = msg + ",  region " + hri + " assigned,  but has different servers in meta and AM ( " + sn + " <> " + assignments.get(hri);
            }
        }
        return msg;
    }

    public String explainTableState(TableName table, TableState.State state) throws IOException {
        TableState tableState = MetaTableAccessor.getTableState((Connection)this.getConnection(), (TableName)table);
        if (tableState == null) {
            return "TableState in META: No table state in META for table " + table + " last state in meta (including deleted is " + this.findLastTableState(table) + ")";
        }
        if (!tableState.inStates(state)) {
            return "TableState in META: Not " + state + " state, but " + tableState;
        }
        return "TableState in META: OK";
    }

    @Nullable
    public TableState findLastTableState(final TableName table) throws IOException {
        final AtomicReference<Object> lastTableState = new AtomicReference<Object>(null);
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                if (!Arrays.equals(r.getRow(), table.getName())) {
                    return false;
                }
                TableState state = MetaTableAccessor.getTableState((Result)r);
                if (state != null) {
                    lastTableState.set(state);
                }
                return true;
            }
        };
        MetaTableAccessor.scanMeta((Connection)this.getConnection(), null, null, (MetaTableAccessor.QueryType)MetaTableAccessor.QueryType.TABLE, (int)Integer.MAX_VALUE, (MetaTableAccessor.Visitor)visitor);
        return lastTableState.get();
    }

    public void waitTableEnabled(TableName table) throws InterruptedException, IOException {
        this.waitTableEnabled(table, 30000L);
    }

    public void waitTableEnabled(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitTableEnabled(TableName.valueOf((byte[])table), timeoutMillis);
    }

    public void waitTableEnabled(TableName table, long timeoutMillis) throws IOException {
        this.waitFor(timeoutMillis, this.predicateTableEnabled(table));
    }

    public void waitTableDisabled(byte[] table) throws InterruptedException, IOException {
        this.waitTableDisabled(table, 30000L);
    }

    public void waitTableDisabled(TableName table, long millisTimeout) throws InterruptedException, IOException {
        this.waitFor(millisTimeout, this.predicateTableDisabled(table));
    }

    public void waitTableDisabled(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitTableDisabled(TableName.valueOf((byte[])table), timeoutMillis);
    }

    public boolean ensureSomeRegionServersAvailable(int num) throws IOException {
        boolean startedServer = false;
        MiniHBaseCluster hbaseCluster = this.getMiniHBaseCluster();
        for (int i = hbaseCluster.getLiveRegionServerThreads().size(); i < num; ++i) {
            LOG.info("Started new server=" + hbaseCluster.startRegionServer());
            startedServer = true;
        }
        return startedServer;
    }

    public boolean ensureSomeNonStoppedRegionServersAvailable(int num) throws IOException {
        boolean startedServer = this.ensureSomeRegionServersAvailable(num);
        int nonStoppedServers = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.isStopping() || hrs.isStopped()) {
                LOG.info("A region server is stopped or stopping:" + hrs);
                continue;
            }
            ++nonStoppedServers;
        }
        for (int i = nonStoppedServers; i < num; ++i) {
            LOG.info("Started new server=" + this.getMiniHBaseCluster().startRegionServer());
            startedServer = true;
        }
        return startedServer;
    }

    public static User getDifferentUser(Configuration c, String differentiatingSuffix) throws IOException {
        FileSystem currentfs = FileSystem.get((Configuration)c);
        if (!(currentfs instanceof DistributedFileSystem) || User.isHBaseSecurityEnabled((Configuration)c)) {
            return User.getCurrent();
        }
        String username = User.getCurrent().getName() + differentiatingSuffix;
        User user = User.createUserForTesting((Configuration)c, (String)username, (String[])new String[]{"supergroup"});
        return user;
    }

    public static NavigableSet<String> getAllOnlineRegions(MiniHBaseCluster cluster) throws IOException {
        TreeSet<String> online = new TreeSet<String>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            try {
                for (RegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rst.getRegionServer().getRSRpcServices())) {
                    online.add(region.getRegionNameAsString());
                }
            }
            catch (RegionServerStoppedException regionServerStoppedException) {
            }
        }
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            try {
                for (RegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)mt.getMaster().getRSRpcServices())) {
                    online.add(region.getRegionNameAsString());
                }
            }
            catch (RegionServerStoppedException regionServerStoppedException) {
            }
            catch (ServerNotRunningYetException serverNotRunningYetException) {
            }
        }
        return online;
    }

    public static void setMaxRecoveryErrorCount(OutputStream stream, int max) {
        try {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = DFSClient.class.getDeclaredClasses()) {
                String className = clazz.getSimpleName();
                if (!className.equals("DFSOutputStream") || !clazz.isInstance(stream)) continue;
                Field maxRecoveryErrorCountField = stream.getClass().getDeclaredField("maxRecoveryErrorCount");
                maxRecoveryErrorCountField.setAccessible(true);
                maxRecoveryErrorCountField.setInt(stream, max);
                break;
            }
        }
        catch (Exception e) {
            LOG.info("Could not set max recovery field", (Throwable)e);
        }
    }

    public boolean assignRegion(RegionInfo regionInfo) throws IOException, InterruptedException {
        AssignmentManager am = this.getHBaseCluster().getMaster().getAssignmentManager();
        am.assign(regionInfo);
        return AssignmentTestingUtil.waitForAssignment(am, regionInfo);
    }

    public void moveRegionAndWait(RegionInfo destRegion, ServerName destServer) throws InterruptedException, IOException {
        ServerName serverName;
        HMaster master = this.getMiniHBaseCluster().getMaster();
        this.getAdmin().move(destRegion.getEncodedNameAsBytes(), destServer);
        while (true) {
            if ((serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(destRegion)) != null && serverName.equals((Object)destServer)) break;
            Thread.sleep(10L);
        }
        this.assertRegionOnServer(destRegion, serverName, 2000L);
    }

    public void waitUntilAllRegionsAssigned(TableName tableName) throws IOException {
        this.waitUntilAllRegionsAssigned(tableName, this.conf.getLong("hbase.client.sync.wait.timeout.msec", 60000L));
    }

    public void waitUntilAllSystemRegionsAssigned() throws IOException {
        this.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        this.waitUntilAllRegionsAssigned(TableName.NAMESPACE_TABLE_NAME);
    }

    public void waitUntilAllRegionsAssigned(final TableName tableName, long timeout) throws IOException {
        if (!TableName.isMetaTableName((TableName)tableName)) {
            try (final Table meta = this.getConnection().getTable(TableName.META_TABLE_NAME);){
                LOG.debug("Waiting until all regions of table " + tableName + " get assigned. Timeout = " + timeout + "ms");
                this.waitFor(timeout, 200L, true, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

                    public String explainFailure() throws IOException {
                        return HBaseTestingUtility.this.explainTableAvailability(tableName);
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean evaluate() throws IOException {
                        Scan scan = new Scan();
                        scan.addFamily(HConstants.CATALOG_FAMILY);
                        boolean tableFound = false;
                        try (ResultScanner s = meta.getScanner(scan);){
                            Result r;
                            while ((r = s.next()) != null) {
                                byte[] b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                                HRegionInfo info = HRegionInfo.parseFromOrNull((byte[])b);
                                if (info == null || !info.getTable().equals((Object)tableName)) continue;
                                tableFound = true;
                                byte[] server = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                                if (server == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                                byte[] startCode = r.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
                                ServerName serverName = ServerName.valueOf((String)(Bytes.toString((byte[])server).replaceFirst(":", ",") + "," + Bytes.toLong((byte[])startCode)));
                                if (!HBaseTestingUtility.this.getHBaseClusterInterface().isDistributedCluster() && HBaseTestingUtility.this.getHBaseCluster().isKilledRS(serverName)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                if (RegionStateStore.getRegionState((Result)r, (RegionInfo)info) == RegionState.State.OPEN) continue;
                                boolean bl = false;
                                return bl;
                            }
                        }
                        if (tableFound) return tableFound;
                        HBaseCommonTestingUtility.LOG.warn("Didn't find the entries for table " + tableName + " in meta, already deleted?");
                        return tableFound;
                    }
                });
            }
        }
        LOG.info("All regions for table " + tableName + " assigned to meta. Checking AM states.");
        if (!this.getHBaseClusterInterface().isDistributedCluster()) {
            HMaster master = this.getHBaseCluster().getMaster();
            final RegionStates states = master.getAssignmentManager().getRegionStates();
            this.waitFor(timeout, 200L, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

                public String explainFailure() throws IOException {
                    return HBaseTestingUtility.this.explainTableAvailability(tableName);
                }

                public boolean evaluate() throws IOException {
                    List hris = states.getRegionsOfTable(tableName);
                    return hris != null && !hris.isEmpty();
                }
            });
        }
        LOG.info("All regions for table " + tableName + " assigned.");
    }

    public static List<Cell> getFromStoreFile(HStore store, Get get) throws IOException {
        Cell kv;
        Scan scan = new Scan(get);
        InternalScanner scanner = (InternalScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(store.getColumnFamilyDescriptor().getName()), 0L);
        ArrayList<Cell> result = new ArrayList<Cell>();
        scanner.next(result);
        if (!result.isEmpty() && !CellUtil.matchingRows((Cell)(kv = (Cell)result.get(0)), (byte[])get.getRow())) {
            result.clear();
        }
        scanner.close();
        return result;
    }

    public byte[][] getRegionSplitStartKeys(byte[] startKey, byte[] endKey, int numRegions) {
        Assert.assertTrue((numRegions > 3 ? 1 : 0) != 0);
        byte[][] tmpSplitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] result = new byte[tmpSplitKeys.length + 1][];
        System.arraycopy(tmpSplitKeys, 0, result, 1, tmpSplitKeys.length);
        result[0] = HConstants.EMPTY_BYTE_ARRAY;
        return result;
    }

    public static List<Cell> getFromStoreFile(HStore store, byte[] row, NavigableSet<byte[]> columns) throws IOException {
        Get get = new Get(row);
        Map s = get.getFamilyMap();
        s.put(store.getColumnFamilyDescriptor().getName(), columns);
        return HBaseTestingUtility.getFromStoreFile(store, get);
    }

    public static void assertKVListsEqual(String additionalMsg, List<? extends Cell> expected, List<? extends Cell> actual) {
        int i;
        int eLen = expected.size();
        int aLen = actual.size();
        int minLen = Math.min(eLen, aLen);
        for (i = 0; i < minLen && CellComparator.getInstance().compare(expected.get(i), actual.get(i)) == 0; ++i) {
        }
        if (additionalMsg == null) {
            additionalMsg = "";
        }
        if (!additionalMsg.isEmpty()) {
            additionalMsg = ". " + additionalMsg;
        }
        if (eLen != aLen || i != minLen) {
            throw new AssertionError((Object)("Expected and actual KV arrays differ at position " + i + ": " + HBaseTestingUtility.safeGetAsStr(expected, i) + " (length " + eLen + ") vs. " + HBaseTestingUtility.safeGetAsStr(actual, i) + " (length " + aLen + ")" + additionalMsg));
        }
    }

    public static <T> String safeGetAsStr(List<T> lst, int i) {
        if (0 <= i && i < lst.size()) {
            return lst.get(i).toString();
        }
        return "<out_of_range>";
    }

    public String getClusterKey() {
        return this.conf.get("hbase.zookeeper.quorum") + ":" + this.conf.get("hbase.zookeeper.property.clientPort") + ":" + this.conf.get("zookeeper.znode.parent", "/hbase");
    }

    public Table createRandomTable(TableName tableName, Collection<String> families, int maxVersions, int numColsPerRow, int numFlushes, int numRegions, int numRowsPerFlush) throws IOException, InterruptedException {
        LOG.info("\n\nCreating random table " + tableName + " with " + numRegions + " regions, " + numFlushes + " storefiles per region, " + numRowsPerFlush + " rows per flush, maxVersions=" + maxVersions + "\n");
        int numCF = families.size();
        byte[][] cfBytes = new byte[numCF][];
        int cfIndex = 0;
        for (String cf : families) {
            cfBytes[cfIndex++] = Bytes.toBytes((String)cf);
        }
        boolean actualStartKey = false;
        int actualEndKey = Integer.MAX_VALUE;
        int keysPerRegion = Integer.MAX_VALUE / numRegions;
        int splitStartKey = 0 + keysPerRegion;
        int splitEndKey = Integer.MAX_VALUE - keysPerRegion;
        String keyFormat = "%08x";
        Table table = this.createTable(tableName, (byte[][])cfBytes, maxVersions, Bytes.toBytes((String)String.format("%08x", splitStartKey)), Bytes.toBytes((String)String.format("%08x", splitEndKey)), numRegions);
        if (this.hbaseCluster != null) {
            this.getMiniHBaseCluster().flushcache(TableName.META_TABLE_NAME);
        }
        BufferedMutator mutator = this.getConnection().getBufferedMutator(tableName);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int iFlush = 0; iFlush < numFlushes; ++iFlush) {
            for (int iRow = 0; iRow < numRowsPerFlush; ++iRow) {
                byte[] row = Bytes.toBytes((String)String.format("%08x", 0 + ((Random)rand).nextInt(Integer.MAX_VALUE)));
                Put put = new Put(row);
                Delete del = new Delete(row);
                for (int iCol = 0; iCol < numColsPerRow; ++iCol) {
                    byte[] cf = cfBytes[((Random)rand).nextInt(numCF)];
                    long ts = ((Random)rand).nextInt();
                    byte[] qual = Bytes.toBytes((String)("col" + iCol));
                    if (((Random)rand).nextBoolean()) {
                        byte[] value = Bytes.toBytes((String)("value_for_row_" + iRow + "_cf_" + Bytes.toStringBinary((byte[])cf) + "_col_" + iCol + "_ts_" + ts + "_random_" + ((Random)rand).nextLong()));
                        put.addColumn(cf, qual, ts, value);
                        continue;
                    }
                    if (((Random)rand).nextDouble() < 0.8) {
                        del.addColumn(cf, qual, ts);
                        continue;
                    }
                    del.addColumns(cf, qual, ts);
                }
                if (!put.isEmpty()) {
                    mutator.mutate((Mutation)put);
                }
                if (del.isEmpty()) continue;
                mutator.mutate((Mutation)del);
            }
            LOG.info("Initiating flush #" + iFlush + " for table " + tableName);
            mutator.flush();
            if (this.hbaseCluster == null) continue;
            this.getMiniHBaseCluster().flushcache(table.getName());
        }
        mutator.close();
        return table;
    }

    public static int randomFreePort() {
        return HBaseCommonTestingUtility.randomFreePort();
    }

    public static String randomMultiCastAddress() {
        return "226.1.1." + ThreadLocalRandom.current().nextInt(254);
    }

    public static void waitForHostPort(String host, int port) throws IOException {
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        IOException savedException = null;
        LOG.info("Waiting for server at " + host + ":" + port);
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                Socket sock = new Socket(InetAddress.getByName(host), port);
                sock.close();
                savedException = null;
                LOG.info("Server at " + host + ":" + port + " is available");
                break;
            }
            catch (UnknownHostException e) {
                throw new IOException("Failed to look up " + host, e);
            }
            catch (IOException e) {
                savedException = e;
                Threads.sleepWithoutInterrupt((long)200L);
                continue;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableName tableName, byte[] columnFamily, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, tableName, columnFamily, compression, dataBlockEncoding, 3, 1, Durability.USE_DEFAULT);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableName tableName, byte[] columnFamily, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding, int numRegionsPerServer, int regionReplication, Durability durability) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setDurability(durability);
        desc.setRegionReplication(regionReplication);
        HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
        hcd.setDataBlockEncoding(dataBlockEncoding);
        hcd.setCompressionType(compression);
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, (TableDescriptor)desc, (ColumnFamilyDescriptor)hcd, numRegionsPerServer);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableName tableName, byte[][] columnFamilies, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding, int numRegionsPerServer, int regionReplication, Durability durability) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setDurability(durability);
        desc.setRegionReplication(regionReplication);
        HColumnDescriptor[] hcds = new HColumnDescriptor[columnFamilies.length];
        for (int i = 0; i < columnFamilies.length; ++i) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamilies[i]);
            hcd.setDataBlockEncoding(dataBlockEncoding);
            hcd.setCompressionType(compression);
            hcds[i] = hcd;
        }
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, (TableDescriptor)desc, (ColumnFamilyDescriptor[])hcds, numRegionsPerServer);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableDescriptor desc, ColumnFamilyDescriptor hcd) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, desc, hcd, 3);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableDescriptor desc, ColumnFamilyDescriptor hcd, int numRegionsPerServer) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, desc, new ColumnFamilyDescriptor[]{hcd}, numRegionsPerServer);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableDescriptor desc, ColumnFamilyDescriptor[] hcds, int numRegionsPerServer) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, desc, hcds, (RegionSplitter.SplitAlgorithm)new RegionSplitter.HexStringSplit(), numRegionsPerServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createPreSplitLoadTestTable(Configuration conf, TableDescriptor td, ColumnFamilyDescriptor[] cds, RegionSplitter.SplitAlgorithm splitter, int numRegionsPerServer) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)td);
        for (ColumnFamilyDescriptor cd : cds) {
            if (td.hasColumnFamily(cd.getName())) continue;
            builder.setColumnFamily(cd);
        }
        td = builder.build();
        int totalNumberOfRegions = 0;
        Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = unmanagedConnection.getAdmin();
        try {
            int numberOfServers = admin.getRegionServers().size();
            if (numberOfServers == 0) {
                throw new IllegalStateException("No live regionservers");
            }
            totalNumberOfRegions = numberOfServers * numRegionsPerServer;
            LOG.info("Number of live regionservers: " + numberOfServers + ", pre-splitting table into " + totalNumberOfRegions + " regions (regions per server: " + numRegionsPerServer + ")");
            byte[][] splits = splitter.split(totalNumberOfRegions);
            admin.createTable(td, splits);
        }
        catch (MasterNotRunningException e) {
            LOG.error("Master not running", (Throwable)e);
            throw new IOException(e);
        }
        catch (TableExistsException e) {
            LOG.warn("Table " + td.getTableName() + " already exists, continuing");
        }
        finally {
            admin.close();
            unmanagedConnection.close();
        }
        return totalNumberOfRegions;
    }

    public static int getMetaRSPort(Connection connection) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(TableName.META_TABLE_NAME);){
            int n = locator.getRegionLocation(Bytes.toBytes((String)"")).getPort();
            return n;
        }
    }

    public void assertRegionOnServer(RegionInfo hri, ServerName server, long timeout) throws IOException, InterruptedException {
        long timeoutTime = EnvironmentEdgeManager.currentTime() + timeout;
        while (true) {
            List regions;
            if ((regions = this.getAdmin().getRegions(server)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0)) {
                return;
            }
            long now = EnvironmentEdgeManager.currentTime();
            if (now > timeoutTime) break;
            Thread.sleep(10L);
        }
        Assert.fail((String)("Could not find region " + hri.getRegionNameAsString() + " on server " + server));
    }

    public void assertRegionOnlyOnServer(RegionInfo hri, ServerName server, long timeout) throws IOException, InterruptedException {
        long timeoutTime = EnvironmentEdgeManager.currentTime() + timeout;
        while (true) {
            List regions;
            if ((regions = this.getAdmin().getRegions(server)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0)) {
                List<JVMClusterUtil.RegionServerThread> rsThreads = this.getHBaseCluster().getLiveRegionServerThreads();
                for (JVMClusterUtil.RegionServerThread rsThread : rsThreads) {
                    HRegionServer rs = rsThread.getRegionServer();
                    if (server.equals((Object)rs.getServerName())) continue;
                    Collection hrs = rs.getOnlineRegionsLocalContext();
                    for (HRegion r2 : hrs) {
                        Assert.assertTrue((String)"Region should not be double assigned", (r2.getRegionInfo().getRegionId() != hri.getRegionId() ? 1 : 0) != 0);
                    }
                }
                return;
            }
            long now = EnvironmentEdgeManager.currentTime();
            if (now > timeoutTime) break;
            Thread.sleep(10L);
        }
        Assert.fail((String)("Could not find region " + hri.getRegionNameAsString() + " on server " + server));
    }

    public HRegion createTestRegion(String tableName, ColumnFamilyDescriptor cd) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(cd).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build();
        return HBaseTestingUtility.createRegionAndWAL(info, this.getDataTestDir(), this.getConfiguration(), td);
    }

    public HRegion createTestRegion(String tableName, ColumnFamilyDescriptor cd, BlockCache blockCache) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(cd).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build();
        return HBaseTestingUtility.createRegionAndWAL(info, this.getDataTestDir(), this.getConfiguration(), td, blockCache);
    }

    public void setFileSystemURI(String fsURI) {
        FS_URI = fsURI;
    }

    public Waiter.ExplainingPredicate<IOException> predicateNoRegionsInTransition() {
        return new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                RegionStates regionStates = HBaseTestingUtility.this.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                return "found in transition: " + regionStates.getRegionsInTransition().toString();
            }

            public boolean evaluate() throws IOException {
                HMaster master = HBaseTestingUtility.this.getMiniHBaseCluster().getMaster();
                if (master == null) {
                    return false;
                }
                AssignmentManager am = master.getAssignmentManager();
                if (am == null) {
                    return false;
                }
                return !am.hasRegionsInTransition();
            }
        };
    }

    public Waiter.Predicate<IOException> predicateTableEnabled(final TableName tableName) {
        return new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return HBaseTestingUtility.this.explainTableState(tableName, TableState.State.ENABLED);
            }

            public boolean evaluate() throws IOException {
                return HBaseTestingUtility.this.getAdmin().tableExists(tableName) && HBaseTestingUtility.this.getAdmin().isTableEnabled(tableName);
            }
        };
    }

    public Waiter.Predicate<IOException> predicateTableDisabled(final TableName tableName) {
        return new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return HBaseTestingUtility.this.explainTableState(tableName, TableState.State.DISABLED);
            }

            public boolean evaluate() throws IOException {
                return HBaseTestingUtility.this.getAdmin().isTableDisabled(tableName);
            }
        };
    }

    public Waiter.Predicate<IOException> predicateTableAvailable(final TableName tableName) {
        return new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return HBaseTestingUtility.this.explainTableAvailability(tableName);
            }

            public boolean evaluate() throws IOException {
                boolean tableAvailable = HBaseTestingUtility.this.getAdmin().isTableAvailable(tableName);
                if (tableAvailable) {
                    try (Table table = HBaseTestingUtility.this.getConnection().getTable(tableName);){
                        TableDescriptor htd = table.getDescriptor();
                        for (HRegionLocation loc : HBaseTestingUtility.this.getConnection().getRegionLocator(tableName).getAllRegionLocations()) {
                            Scan scan = new Scan().withStartRow(loc.getRegionInfo().getStartKey()).withStopRow(loc.getRegionInfo().getEndKey()).setOneRowLimit().setMaxResultsPerColumnFamily(1).setCacheBlocks(false);
                            for (byte[] family : htd.getColumnFamilyNames()) {
                                scan.addFamily(family);
                            }
                            ResultScanner scanner = table.getScanner(scan);
                            Throwable throwable = null;
                            try {
                                scanner.next();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (scanner == null) continue;
                                if (throwable != null) {
                                    try {
                                        scanner.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                scanner.close();
                            }
                        }
                    }
                }
                return tableAvailable;
            }
        };
    }

    public void waitUntilNoRegionsInTransition(long timeout) throws IOException {
        this.waitFor(timeout, (Waiter.Predicate)this.predicateNoRegionsInTransition());
    }

    public void waitUntilNoRegionsInTransition() throws IOException {
        this.waitUntilNoRegionsInTransition(900000L);
    }

    public void waitLabelAvailable(long timeoutMillis, final String ... labels) {
        final VisibilityLabelsCache labelsCache = VisibilityLabelsCache.get();
        this.waitFor(timeoutMillis, (Waiter.Predicate)new Waiter.ExplainingPredicate<RuntimeException>(){

            public boolean evaluate() {
                for (String label : labels) {
                    if (labelsCache.getLabelOrdinal(label) != 0) continue;
                    return false;
                }
                return true;
            }

            public String explainFailure() {
                for (String label : labels) {
                    if (labelsCache.getLabelOrdinal(label) != 0) continue;
                    return label + " is not available yet";
                }
                return "";
            }
        });
    }

    public static List<HColumnDescriptor> generateColumnDescriptors() {
        return HBaseTestingUtility.generateColumnDescriptors("");
    }

    public static List<HColumnDescriptor> generateColumnDescriptors(String prefix) {
        ArrayList<HColumnDescriptor> htds = new ArrayList<HColumnDescriptor>();
        long familyId = 0L;
        for (Compression.Algorithm compressionType : HBaseTestingUtility.getSupportedCompressionAlgorithms()) {
            for (DataBlockEncoding encodingType : DataBlockEncoding.values()) {
                for (BloomType bloomType : BloomType.values()) {
                    String name = String.format("%s-cf-!@#&-%d!@#", prefix, familyId);
                    HColumnDescriptor htd = new HColumnDescriptor(name);
                    htd.setCompressionType(compressionType);
                    htd.setDataBlockEncoding(encodingType);
                    htd.setBloomFilterType(bloomType);
                    htds.add(htd);
                    ++familyId;
                }
            }
        }
        return htds;
    }

    public static Compression.Algorithm[] getSupportedCompressionAlgorithms() {
        String[] allAlgos = HFile.getSupportedCompressionAlgorithms();
        ArrayList<Compression.Algorithm> supportedAlgos = new ArrayList<Compression.Algorithm>();
        for (String algoName : allAlgos) {
            try {
                Compression.Algorithm algo = Compression.getCompressionAlgorithmByName((String)algoName);
                algo.getCompressor();
                supportedAlgos.add(algo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supportedAlgos.toArray(new Compression.Algorithm[supportedAlgos.size()]);
    }

    public Result getClosestRowBefore(Region r, byte[] row, byte[] family) throws IOException {
        Scan scan = new Scan(row);
        scan.setSmall(true);
        scan.setCaching(1);
        scan.setReversed(true);
        scan.addFamily(family);
        try (RegionScanner scanner = r.getScanner(scan);){
            ArrayList cells = new ArrayList(1);
            scanner.next(cells);
            if (r.getRegionInfo().isMetaRegion() && !this.isTargetTable(row, (Cell)cells.get(0))) {
                Result result = null;
                return result;
            }
            Result result = Result.create(cells);
            return result;
        }
    }

    private boolean isTargetTable(byte[] inRow, Cell c) {
        String inputRowString = Bytes.toString((byte[])inRow);
        int i = inputRowString.indexOf(44);
        String outputRowString = Bytes.toString((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength());
        int o = outputRowString.indexOf(44);
        return inputRowString.substring(0, i).equals(outputRowString.substring(0, o));
    }

    public MiniKdc setupMiniKdc(File keytabFile) throws Exception {
        boolean bindException;
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        MiniKdc kdc = null;
        File dir = null;
        int numTries = 0;
        do {
            try {
                bindException = false;
                dir = new File(this.getDataTestDir("kdc").toUri().getPath());
                kdc = new MiniKdc(conf, dir);
                kdc.start();
            }
            catch (BindException e) {
                FileUtils.deleteDirectory(dir);
                if (++numTries == 3) {
                    LOG.error("Failed setting up MiniKDC. Tried " + numTries + " times.");
                    throw e;
                }
                LOG.error("BindException encountered when setting up MiniKdc. Trying again.");
                bindException = true;
            }
        } while (bindException);
        HBaseKerberosUtils.setKeytabFileForTesting((String)keytabFile.getAbsolutePath());
        return kdc;
    }

    public int getNumHFiles(TableName tableName, byte[] family) {
        int numHFiles = 0;
        for (JVMClusterUtil.RegionServerThread regionServerThread : this.getMiniHBaseCluster().getRegionServerThreads()) {
            numHFiles += this.getNumHFilesForRS(regionServerThread.getRegionServer(), tableName, family);
        }
        return numHFiles;
    }

    public int getNumHFilesForRS(HRegionServer rs, TableName tableName, byte[] family) {
        int numHFiles = 0;
        for (Region region : rs.getRegions(tableName)) {
            numHFiles += region.getStore(family).getStorefilesCount();
        }
        return numHFiles;
    }

    public void verifyTableDescriptorIgnoreTableName(TableDescriptor ltd, TableDescriptor rtd) {
        Assert.assertEquals((long)ltd.getValues().hashCode(), (long)rtd.getValues().hashCode());
        List<ColumnFamilyDescriptor> ltdFamilies = Arrays.asList(ltd.getColumnFamilies());
        List<ColumnFamilyDescriptor> rtdFamilies = Arrays.asList(rtd.getColumnFamilies());
        Assert.assertEquals((long)ltdFamilies.size(), (long)rtdFamilies.size());
        Iterator it = ltdFamilies.iterator();
        Iterator it2 = rtdFamilies.iterator();
        while (it.hasNext()) {
            Assert.assertEquals((long)0L, (long)ColumnFamilyDescriptor.COMPARATOR.compare(it.next(), it2.next()));
        }
    }

    public static void await(long sleepMillis, BooleanSupplier condition) throws InterruptedException {
        try {
            while (!condition.getAsBoolean()) {
                Thread.sleep(sleepMillis);
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof AssertionError) {
                throw (AssertionError)((Object)e.getCause());
            }
            throw e;
        }
    }

    static {
        MEMSTORETS_TAGS_PARAMETRIZED = HBaseTestingUtility.memStoreTSAndTagsCombination();
        BLOOM_AND_COMPRESSION_COMBINATIONS = HBaseTestingUtility.bloomAndCompressionCombinations();
        fam1 = Bytes.toBytes((String)"colfamily11");
        fam2 = Bytes.toBytes((String)"colfamily21");
        fam3 = Bytes.toBytes((String)"colfamily31");
        COLUMNS = new byte[][]{fam1, fam2, fam3};
        START_KEY_BYTES = new byte[]{97, 97, 97};
        START_KEY = new String(START_KEY_BYTES, HConstants.UTF8_CHARSET);
        ROWS = new byte[(int)Math.pow(26.0, 3.0)][3];
        int i = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    HBaseTestingUtility.ROWS[i][0] = b1;
                    HBaseTestingUtility.ROWS[i][1] = b2;
                    HBaseTestingUtility.ROWS[i][2] = b3;
                    ++i;
                }
            }
        }
        KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};
        KEYS_FOR_HBA_CREATE_TABLE = new byte[][]{Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy"), Bytes.toBytes((String)"zzz")};
    }

    public static class SeenRowTracker {
        int dim = 26;
        int[][][] seenRows = new int[this.dim][this.dim][this.dim];
        byte[] startRow;
        byte[] stopRow;

        public SeenRowTracker(byte[] startRow, byte[] stopRow) {
            this.startRow = startRow;
            this.stopRow = stopRow;
        }

        void reset() {
            for (byte[] row : ROWS) {
                this.seenRows[this.i((byte)row[0])][this.i((byte)row[1])][this.i((byte)row[2])] = 0;
            }
        }

        int i(byte b) {
            return b - 97;
        }

        public void addRow(byte[] row) {
            int[] nArray = this.seenRows[this.i(row[0])][this.i(row[1])];
            int n = this.i(row[2]);
            nArray[n] = nArray[n] + 1;
        }

        public void validate() {
            for (byte b1 = 97; b1 <= 122; b1 = (byte)((byte)(b1 + 1))) {
                for (byte b2 = 97; b2 <= 122; b2 = (byte)((byte)(b2 + 1))) {
                    for (byte b3 = 97; b3 <= 122; b3 = (byte)(b3 + 1)) {
                        int count = this.seenRows[this.i(b1)][this.i(b2)][this.i(b3)];
                        int expectedCount = 0;
                        if (Bytes.compareTo((byte[])new byte[]{b1, b2, b3}, (byte[])this.startRow) >= 0 && Bytes.compareTo((byte[])new byte[]{b1, b2, b3}, (byte[])this.stopRow) < 0) {
                            expectedCount = 1;
                        }
                        if (count == expectedCount) continue;
                        String row = new String(new byte[]{b1, b2, b3}, StandardCharsets.UTF_8);
                        throw new RuntimeException("Row:" + row + " has a seen count of " + count + " instead of " + expectedCount);
                    }
                }
            }
        }
    }

    private static final class FsDatasetAsyncDiskServiceFixer
    extends Thread {
        private volatile boolean stopped = false;
        private final MiniDFSCluster cluster;

        FsDatasetAsyncDiskServiceFixer(MiniDFSCluster cluster) {
            super("FsDatasetAsyncDiskServiceFixer");
            this.setDaemon(true);
            this.cluster = cluster;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                try {
                    for (DataNode dn : this.cluster.getDataNodes()) {
                        FsDatasetSpi dataset = dn.getFSDataset();
                        Field service = dataset.getClass().getDeclaredField("asyncDiskService");
                        service.setAccessible(true);
                        Object asyncDiskService = service.get(dataset);
                        Field group = asyncDiskService.getClass().getDeclaredField("threadGroup");
                        group.setAccessible(true);
                        ThreadGroup threadGroup = (ThreadGroup)group.get(asyncDiskService);
                        if (!threadGroup.isDaemon()) continue;
                        threadGroup.setDaemon(false);
                    }
                }
                catch (Exception e) {
                    HBaseCommonTestingUtility.LOG.warn("failed to reset thread pool timeout for FsDatasetAsyncDiskService", (Throwable)e);
                }
            }
        }

        void shutdown() {
            this.stopped = true;
            this.interrupt();
        }
    }
}

