/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncTableUseMetaReplicas {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableUseMetaReplicas.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"Replica");
    private static byte[] FAMILY = Bytes.toBytes((String)"Family");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"Qual");
    private static byte[] ROW = Bytes.toBytes((String)"Row");
    private static byte[] VALUE = Bytes.toBytes((String)"Value");
    private static volatile boolean FAIL_PRIMARY_SCAN = false;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.storefile.refresh.period", 1000);
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{FailPrimaryMetaScanCp.class.getName()});
        UTIL.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
        try (ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)conf);){
            RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(UTIL, registry);
        }
        var2_2 = null;
        try (Table table = UTIL.createTable(TABLE_NAME, FAMILY);){
            table.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        UTIL.flush(TableName.META_TABLE_NAME);
        Thread.sleep(2000L);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDownAfterTest() {
        FAIL_PRIMARY_SCAN = false;
    }

    private void testRead(boolean useMetaReplicas) throws IOException, InterruptedException, ExecutionException {
        FAIL_PRIMARY_SCAN = true;
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", useMetaReplicas);
        conf.setLong("hbase.client.meta.replica.scan.timeout", TimeUnit.SECONDS.toMicros(1L));
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();){
            Result result = (Result)FutureUtils.get((Future)conn.getTableBuilder(TABLE_NAME).setOperationTimeout(3L, TimeUnit.SECONDS).build().get(new Get(ROW)));
            Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
        }
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testNotUseMetaReplicas() throws IOException, InterruptedException, ExecutionException {
        this.testRead(false);
    }

    @Test
    public void testUseMetaReplicas() throws IOException, InterruptedException, ExecutionException {
        this.testRead(true);
    }

    public static final class FailPrimaryMetaScanCp
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
            RegionInfo region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo();
            if (FAIL_PRIMARY_SCAN && TableName.isMetaTableName((TableName)region.getTable()) && region.getReplicaId() == 0) {
                throw new IOException("Inject error");
            }
        }
    }
}

