/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestSimpleRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleRpcServer.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final int NUM_ROWS = 100;
    private static final int MIN_LEN = 1000;
    private static final int MAX_LEN = 1000000;
    protected static final LoadTestKVGenerator GENERATOR = new LoadTestKVGenerator(1000, 1000000);
    protected static HBaseTestingUtility TEST_UTIL;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setupClass() throws Exception {
        if (TEST_UTIL == null) {
            TEST_UTIL = new HBaseTestingUtility();
        }
        TEST_UTIL.getConfiguration().set("hbase.rpc.server.impl", SimpleRpcServer.class.getName());
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSimpleRpcServer() throws Exception {
        this.doTest(this.name.getTableName());
    }

    protected void doTest(TableName tableName) throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName()).build();
        try (Table table = TEST_UTIL.createTable(desc, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());){
            byte[] rowKey;
            int i;
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                byte[] v = GENERATOR.generateRandomSizeValue((byte[][])new byte[][]{rowKey, QUALIFIER});
                table.put(new Put(rowKey).addColumn(FAMILY, QUALIFIER, v));
            }
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                Result r = table.get(new Get(rowKey).addColumn(FAMILY, QUALIFIER));
                Assert.assertNotNull((String)"Result was empty", (Object)r);
                byte[] v = r.getValue(FAMILY, QUALIFIER);
                Assert.assertNotNull((String)"Result did not contain expected value", (Object)v);
                Assert.assertTrue((String)"Value was not verified", (boolean)LoadTestKVGenerator.verify((byte[])v, (byte[][])new byte[][]{rowKey, QUALIFIER}));
            }
        }
    }
}

