/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ServerTask;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionsRecoveryChore;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionsRecoveryChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionsRecoveryChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionsRecoveryChore.class);
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private static final String UTF_8_CHARSET = StandardCharsets.UTF_8.name();
    private HMaster hMaster;
    private AssignmentManager assignmentManager;
    private RegionsRecoveryChore regionsRecoveryChore;
    private static int regionNo;
    public static final byte[][] REGION_NAME_LIST;

    private Configuration getCustomConf() {
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setInt("hbase.master.regions.recovery.check.interval", 100);
        return conf;
    }

    @Before
    public void setUp() throws Exception {
        this.hMaster = (HMaster)Mockito.mock(HMaster.class);
        this.assignmentManager = (AssignmentManager)Mockito.mock(AssignmentManager.class);
    }

    @After
    public void tearDown() throws Exception {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hMaster});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.assignmentManager});
    }

    @Test
    public void testRegionReopensWithStoreRefConfig() throws Exception {
        regionNo = 0;
        ClusterMetrics clusterMetrics = TestRegionsRecoveryChore.getClusterMetrics(4);
        Map serverMetricsMap = clusterMetrics.getLiveServerMetrics();
        LOG.debug("All Region Names with refCount....");
        for (ServerMetrics serverMetrics : serverMetricsMap.values()) {
            Map regionMetricsMap = serverMetrics.getRegionMetrics();
            for (RegionMetrics regionMetrics : regionMetricsMap.values()) {
                LOG.debug("name: " + new String(regionMetrics.getRegionName()) + " refCount: " + regionMetrics.getStoreRefCount());
            }
        }
        Mockito.when((Object)this.hMaster.getClusterMetrics()).thenReturn((Object)clusterMetrics);
        Mockito.when((Object)this.hMaster.getAssignmentManager()).thenReturn((Object)this.assignmentManager);
        for (Object regionName : (Object)REGION_NAME_LIST) {
            Mockito.when((Object)this.assignmentManager.getRegionInfo((byte[])regionName)).thenReturn((Object)TestRegionsRecoveryChore.getRegionInfo((byte[])regionName));
        }
        StoppableImplementation stoppable = new StoppableImplementation();
        Configuration configuration = this.getCustomConf();
        configuration.setInt("hbase.regions.recovery.store.file.ref.count", 300);
        this.regionsRecoveryChore = new RegionsRecoveryChore((Stoppable)stoppable, configuration, this.hMaster);
        this.regionsRecoveryChore.chore();
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)2))).reopenRegions((TableName)Mockito.any(), Mockito.anyList(), Mockito.anyLong(), Mockito.anyLong());
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)1))).getClusterMetrics();
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)3))).getAssignmentManager();
        ((AssignmentManager)Mockito.verify((Object)this.assignmentManager, (VerificationMode)Mockito.times((int)3))).getRegionInfo((byte[])Mockito.any());
    }

    @Test
    public void testRegionReopensWithLessThreshold() throws Exception {
        regionNo = 0;
        ClusterMetrics clusterMetrics = TestRegionsRecoveryChore.getClusterMetrics(4);
        Map serverMetricsMap = clusterMetrics.getLiveServerMetrics();
        LOG.debug("All Region Names with refCount....");
        for (ServerMetrics serverMetrics : serverMetricsMap.values()) {
            Map regionMetricsMap = serverMetrics.getRegionMetrics();
            for (RegionMetrics regionMetrics : regionMetricsMap.values()) {
                LOG.debug("name: " + new String(regionMetrics.getRegionName()) + " refCount: " + regionMetrics.getStoreRefCount());
            }
        }
        Mockito.when((Object)this.hMaster.getClusterMetrics()).thenReturn((Object)clusterMetrics);
        Mockito.when((Object)this.hMaster.getAssignmentManager()).thenReturn((Object)this.assignmentManager);
        for (Object regionName : (Object)REGION_NAME_LIST) {
            Mockito.when((Object)this.assignmentManager.getRegionInfo((byte[])regionName)).thenReturn((Object)TestRegionsRecoveryChore.getRegionInfo((byte[])regionName));
        }
        StoppableImplementation stoppable = new StoppableImplementation();
        Configuration configuration = this.getCustomConf();
        configuration.setInt("hbase.regions.recovery.store.file.ref.count", 400);
        this.regionsRecoveryChore = new RegionsRecoveryChore((Stoppable)stoppable, configuration, this.hMaster);
        this.regionsRecoveryChore.chore();
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)1))).reopenRegions((TableName)Mockito.any(), Mockito.anyList(), Mockito.anyLong(), Mockito.anyLong());
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)1))).getClusterMetrics();
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)1))).getAssignmentManager();
        ((AssignmentManager)Mockito.verify((Object)this.assignmentManager, (VerificationMode)Mockito.times((int)1))).getRegionInfo((byte[])Mockito.any());
    }

    @Test
    public void testRegionReopensWithoutStoreRefConfig() throws Exception {
        regionNo = 0;
        ClusterMetrics clusterMetrics = TestRegionsRecoveryChore.getClusterMetrics(10);
        Map serverMetricsMap = clusterMetrics.getLiveServerMetrics();
        LOG.debug("All Region Names with refCount....");
        for (ServerMetrics serverMetrics : serverMetricsMap.values()) {
            Map regionMetricsMap = serverMetrics.getRegionMetrics();
            for (RegionMetrics regionMetrics : regionMetricsMap.values()) {
                LOG.debug("name: " + new String(regionMetrics.getRegionName()) + " refCount: " + regionMetrics.getStoreRefCount());
            }
        }
        Mockito.when((Object)this.hMaster.getClusterMetrics()).thenReturn((Object)clusterMetrics);
        Mockito.when((Object)this.hMaster.getAssignmentManager()).thenReturn((Object)this.assignmentManager);
        for (Object regionName : (Object)REGION_NAME_LIST) {
            Mockito.when((Object)this.assignmentManager.getRegionInfo((byte[])regionName)).thenReturn((Object)TestRegionsRecoveryChore.getRegionInfo((byte[])regionName));
        }
        StoppableImplementation stoppable = new StoppableImplementation();
        Configuration configuration = this.getCustomConf();
        configuration.unset("hbase.regions.recovery.store.file.ref.count");
        this.regionsRecoveryChore = new RegionsRecoveryChore((Stoppable)stoppable, configuration, this.hMaster);
        this.regionsRecoveryChore.chore();
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)0))).reopenRegions((TableName)Mockito.any(), Mockito.anyList(), Mockito.anyLong(), Mockito.anyLong());
        ((HMaster)Mockito.verify((Object)this.hMaster, (VerificationMode)Mockito.times((int)0))).getAssignmentManager();
        ((AssignmentManager)Mockito.verify((Object)this.assignmentManager, (VerificationMode)Mockito.times((int)0))).getRegionInfo((byte[])Mockito.any());
    }

    private static ClusterMetrics getClusterMetrics(final int noOfLiveServer) {
        ClusterMetrics clusterMetrics = new ClusterMetrics(){

            @Nullable
            public String getHBaseVersion() {
                return null;
            }

            public List<ServerName> getDeadServerNames() {
                return null;
            }

            public List<ServerName> getUnknownServerNames() {
                return null;
            }

            public Map<ServerName, ServerMetrics> getLiveServerMetrics() {
                HashMap<ServerName, ServerMetrics> liveServerMetrics = new HashMap<ServerName, ServerMetrics>();
                for (int i = 0; i < noOfLiveServer; ++i) {
                    ServerName serverName = ServerName.valueOf((String)("rs_" + i), (int)16010, (long)12345L);
                    liveServerMetrics.put(serverName, TestRegionsRecoveryChore.getServerMetrics(i + 3));
                }
                return liveServerMetrics;
            }

            @Nullable
            public ServerName getMasterName() {
                return null;
            }

            public List<ServerName> getBackupMasterNames() {
                return null;
            }

            public List<RegionState> getRegionStatesInTransition() {
                return null;
            }

            @Nullable
            public String getClusterId() {
                return null;
            }

            public List<String> getMasterCoprocessorNames() {
                return null;
            }

            @Nullable
            public Boolean getBalancerOn() {
                return null;
            }

            public int getMasterInfoPort() {
                return 0;
            }

            public List<ServerName> getServersName() {
                return null;
            }

            public Map<TableName, RegionStatesCount> getTableRegionStatesCount() {
                return null;
            }

            public List<ServerTask> getMasterTasks() {
                return null;
            }
        };
        return clusterMetrics;
    }

    private static ServerMetrics getServerMetrics(final int noOfRegions) {
        ServerMetrics serverMetrics = new ServerMetrics(){

            public ServerName getServerName() {
                return null;
            }

            public long getRequestCountPerSecond() {
                return 0L;
            }

            public long getRequestCount() {
                return 0L;
            }

            public Size getUsedHeapSize() {
                return null;
            }

            public Size getMaxHeapSize() {
                return null;
            }

            public int getInfoServerPort() {
                return 0;
            }

            public List<ReplicationLoadSource> getReplicationLoadSourceList() {
                return null;
            }

            public Map<String, List<ReplicationLoadSource>> getReplicationLoadSourceMap() {
                return null;
            }

            @Nullable
            public ReplicationLoadSink getReplicationLoadSink() {
                return null;
            }

            public Map<byte[], RegionMetrics> getRegionMetrics() {
                HashMap<byte[], RegionMetrics> regionMetricsMap = new HashMap<byte[], RegionMetrics>();
                for (int i = 0; i < noOfRegions; ++i) {
                    byte[] regionName = Bytes.toBytes((String)("region" + regionNo + "_" + i));
                    regionMetricsMap.put(regionName, TestRegionsRecoveryChore.getRegionMetrics(regionName, 100 * i));
                    ++regionNo;
                }
                return regionMetricsMap;
            }

            public Map<byte[], UserMetrics> getUserMetrics() {
                return new HashMap<byte[], UserMetrics>();
            }

            public Set<String> getCoprocessorNames() {
                return null;
            }

            public long getReportTimestamp() {
                return 0L;
            }

            public long getLastReportTimestamp() {
                return 0L;
            }

            public List<ServerTask> getTasks() {
                return null;
            }
        };
        return serverMetrics;
    }

    private static RegionMetrics getRegionMetrics(final byte[] regionName, final int compactedStoreRefCount) {
        RegionMetrics regionMetrics = new RegionMetrics(){

            public byte[] getRegionName() {
                return regionName;
            }

            public int getStoreCount() {
                return 0;
            }

            public int getStoreFileCount() {
                return 0;
            }

            public Size getStoreFileSize() {
                return null;
            }

            public Size getMemStoreSize() {
                return null;
            }

            public long getReadRequestCount() {
                return 0L;
            }

            public long getWriteRequestCount() {
                return 0L;
            }

            public long getFilteredReadRequestCount() {
                return 0L;
            }

            public Size getStoreFileIndexSize() {
                return null;
            }

            public Size getStoreFileRootLevelIndexSize() {
                return null;
            }

            public Size getStoreFileUncompressedDataIndexSize() {
                return null;
            }

            public Size getBloomFilterSize() {
                return null;
            }

            public long getCompactingCellCount() {
                return 0L;
            }

            public long getCompactedCellCount() {
                return 0L;
            }

            public long getCompletedSequenceId() {
                return 0L;
            }

            public Map<byte[], Long> getStoreSequenceId() {
                return null;
            }

            public Size getUncompressedStoreFileSize() {
                return null;
            }

            public float getDataLocality() {
                return 0.0f;
            }

            public long getLastMajorCompactionTimestamp() {
                return 0L;
            }

            public int getStoreRefCount() {
                return compactedStoreRefCount;
            }

            public int getMaxCompactedStoreFileRefCount() {
                return compactedStoreRefCount;
            }

            public float getDataLocalityForSsd() {
                return 0.0f;
            }

            public long getBlocksLocalWeight() {
                return 0L;
            }

            public long getBlocksLocalWithSsdWeight() {
                return 0L;
            }

            public long getBlocksTotalWeight() {
                return 0L;
            }

            public CompactionState getCompactionState() {
                return null;
            }
        };
        return regionMetrics;
    }

    private static RegionInfo getRegionInfo(final byte[] regionNameBytes) {
        RegionInfo regionInfo = new RegionInfo(){

            public String getShortNameToLog() {
                return null;
            }

            public long getRegionId() {
                return 0L;
            }

            public byte[] getRegionName() {
                return new byte[0];
            }

            public String getRegionNameAsString() {
                try {
                    return new String(regionNameBytes, UTF_8_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }

            public String getEncodedName() {
                return null;
            }

            public byte[] getEncodedNameAsBytes() {
                return new byte[0];
            }

            public byte[] getStartKey() {
                return new byte[0];
            }

            public byte[] getEndKey() {
                return new byte[0];
            }

            public TableName getTable() {
                String regionName;
                try {
                    regionName = new String(regionNameBytes, UTF_8_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    regionName = "";
                }
                int regionNo = Integer.parseInt(regionName.split("_")[1]);
                TableName tableName = TableName.valueOf((String)("table_" + regionNo % 3));
                return tableName;
            }

            public int getReplicaId() {
                return 0;
            }

            public boolean isSplit() {
                return false;
            }

            public boolean isOffline() {
                return false;
            }

            public boolean isSplitParent() {
                return false;
            }

            public boolean isMetaRegion() {
                return false;
            }

            public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
                return false;
            }

            public boolean containsRow(byte[] row) {
                return false;
            }
        };
        return regionInfo;
    }

    static {
        REGION_NAME_LIST = new byte[][]{{114, 101, 103, 105, 111, 110, 50, 49, 95, 51}, {114, 101, 103, 105, 111, 110, 50, 53, 95, 51}, {114, 101, 103, 105, 111, 110, 50, 54, 95, 52}, {114, 101, 103, 105, 111, 110, 51, 50, 95, 53}, {114, 101, 103, 105, 111, 110, 51, 49, 95, 52}, {114, 101, 103, 105, 111, 110, 51, 48, 95, 51}, {114, 101, 103, 105, 111, 110, 50, 48, 95, 50}, {114, 101, 103, 105, 111, 110, 50, 52, 95, 50}, {114, 101, 103, 105, 111, 110, 50, 57, 95, 50}, {114, 101, 103, 105, 111, 110, 51, 53, 95, 50}, {114, 101, 103, 105, 111, 110, 49, 48, 56, 95, 49, 49}};
    }

    private static class StoppableImplementation
    implements Stoppable {
        private volatile boolean stop = false;

        private StoppableImplementation() {
        }

        public void stop(String why) {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }
    }
}

