/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReopenTableRegionsProcedureBackoff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReopenTableRegionsProcedureBackoff.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReopenTableRegionsProcedureBackoff.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"Backoff");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, CF);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryBackoff() throws IOException, InterruptedException {
        long openSeqNum;
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        RegionInfo regionInfo = (RegionInfo)UTIL.getAdmin().getRegions(TABLE_NAME).get(0);
        RegionStateNode regionNode = am.getRegionStates().getRegionStateNode(regionInfo);
        TransitRegionStateProcedure trsp = TransitRegionStateProcedure.unassign((MasterProcedureEnv)((MasterProcedureEnv)procExec.getEnvironment()), (RegionInfo)regionInfo);
        regionNode.lock();
        try {
            openSeqNum = regionNode.getOpenSeqNum();
            regionNode.setState(RegionState.State.OPENING, new RegionState.State[0]);
            regionNode.setOpenSeqNum(-1L);
            regionNode.setProcedure(trsp);
        }
        finally {
            regionNode.unlock();
        }
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME);
        procExec.submitProcedure((Procedure)proc);
        UTIL.waitFor(10000L, () -> proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        long oldTimeout = 0L;
        int timeoutIncrements = 0;
        while (true) {
            long timeout;
            if ((timeout = (long)proc.getTimeout()) > oldTimeout) {
                LOG.info("Timeout incremented, was {}, now is {}, increments={}", new Object[]{timeout, oldTimeout, timeoutIncrements});
                oldTimeout = timeout;
                if (++timeoutIncrements > 3) break;
            }
            Thread.sleep(1000L);
        }
        regionNode.lock();
        try {
            regionNode.setState(RegionState.State.OPEN, new RegionState.State[0]);
            regionNode.setOpenSeqNum(openSeqNum);
            regionNode.unsetProcedure(trsp);
        }
        finally {
            regionNode.unlock();
        }
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)60000L);
        Assert.assertTrue((regionNode.getOpenSeqNum() > openSeqNum ? 1 : 0) != 0);
    }
}

