/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestHBaseFsckReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckReplication.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.write.hbck1.lock.file", false);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        ReplicationPeerStorage peerStorage = ReplicationStorageFactory.getReplicationPeerStorage((ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)UTIL.getConfiguration());
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)UTIL.getConfiguration());
        String peerId1 = "1";
        String peerId2 = "2";
        peerStorage.addPeer(peerId1, ReplicationPeerConfig.newBuilder().setClusterKey("key").build(), true);
        peerStorage.addPeer(peerId2, ReplicationPeerConfig.newBuilder().setClusterKey("key").build(), true);
        for (int i = 0; i < 10; ++i) {
            queueStorage.addWAL(ServerName.valueOf((String)"localhost", (int)(10000 + i), (long)(100000 + i)), peerId1, "file-" + i);
        }
        queueStorage.addWAL(ServerName.valueOf((String)"localhost", (int)10000, (long)100000L), peerId2, "file");
        HBaseFsck fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), true);
        HbckTestingUtil.assertNoErrors(fsck);
        Assert.assertEquals((long)10L, (long)queueStorage.getListOfReplicators().size());
        peerStorage.removePeer(peerId1);
        Assert.assertEquals((long)10L, (long)queueStorage.getListOfReplicators().size());
        fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(fsck, (HbckErrorReporter.ERROR_CODE[])Stream.generate(() -> HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE).limit(10L).toArray(HbckErrorReporter.ERROR_CODE[]::new));
        Assert.assertEquals((long)10L, (long)queueStorage.getListOfReplicators().size());
        fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), true);
        HbckTestingUtil.assertErrors(fsck, (HbckErrorReporter.ERROR_CODE[])Stream.generate(() -> HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE).limit(10L).toArray(HbckErrorReporter.ERROR_CODE[]::new));
        List replicators = queueStorage.getListOfReplicators();
        Assert.assertEquals((long)1L, (long)replicators.size());
        Assert.assertEquals((Object)ServerName.valueOf((String)"localhost", (int)10000, (long)100000L), replicators.get(0));
        for (String queueId : queueStorage.getAllQueues((ServerName)replicators.get(0))) {
            Assert.assertEquals((Object)peerId2, (Object)queueId);
        }
    }
}

