/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestSnapshotWithTTLFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotWithTTLFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotWithTTLFromClient.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "test";
    private static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final TableName CLONED_TABLE_NAME = TableName.valueOf((String)"clonedTable");
    private static final String TTL_KEY = "TTL";
    private static final int CHORE_INTERVAL_SECS = 30;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotWithTTLFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    protected static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.master.cleaner.snapshot.interval", 1800000);
    }

    @Before
    public void setup() throws Exception {
        this.createTable();
    }

    protected void createTable() throws Exception {
        UTIL.createTable(TABLE_NAME, (byte[][])new byte[][]{TEST_FAM});
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTableIfAny(TABLE_NAME);
        UTIL.deleteTableIfAny(CLONED_TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testRestoreSnapshotWithTTLSuccess() throws Exception {
        String snapshotName = "nonExpiredTTLRestoreSnapshotTest";
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        this.createSnapshotWithTTL(TABLE_NAME, snapshotName, 60);
        Admin admin = UTIL.getAdmin();
        admin.disableTable(TABLE_NAME);
        admin.deleteTable(TABLE_NAME);
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        admin.restoreSnapshot(snapshotName);
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
    }

    @Test
    public void testRestoreSnapshotFailsDueToTTLExpired() throws Exception {
        String snapshotName = "expiredTTLRestoreSnapshotTest";
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        this.createSnapshotWithTTL(TABLE_NAME, snapshotName, 1);
        Admin admin = UTIL.getAdmin();
        admin.disableTable(TABLE_NAME);
        admin.deleteTable(TABLE_NAME);
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        Threads.sleep((long)2000L);
        try {
            admin.restoreSnapshot(snapshotName);
            Assert.fail((String)"Restore snapshot succeeded even though TTL has expired.");
        }
        catch (SnapshotTTLExpiredException e) {
            LOG.info("Correctly failed to restore a TTL expired snapshot table:" + e.getMessage());
        }
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
    }

    @Test
    public void testCloneSnapshotWithTTLSuccess() throws Exception {
        String snapshotName = "nonExpiredTTLCloneSnapshotTest";
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        this.createSnapshotWithTTL(TABLE_NAME, snapshotName, 60);
        Admin admin = UTIL.getAdmin();
        admin.cloneSnapshot(snapshotName, CLONED_TABLE_NAME);
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(CLONED_TABLE_NAME));
    }

    @Test
    public void testCloneSnapshotFailsDueToTTLExpired() throws Exception {
        String snapshotName = "expiredTTLCloneSnapshotTest";
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        this.createSnapshotWithTTL(TABLE_NAME, snapshotName, 1);
        Admin admin = UTIL.getAdmin();
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        Threads.sleep((long)2000L);
        try {
            admin.cloneSnapshot(snapshotName, CLONED_TABLE_NAME);
            Assert.fail((String)"Clone snapshot succeeded even though TTL has expired.");
        }
        catch (SnapshotTTLExpiredException e) {
            LOG.info("Correctly failed to clone a TTL expired snapshot table:" + e.getMessage());
        }
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(CLONED_TABLE_NAME));
    }

    private void createSnapshotWithTTL(TableName tableName, String snapshotName, int snapshotTTL) throws IOException {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        Table table = UTIL.getConnection().getTable(tableName);
        UTIL.loadTable(table, TEST_FAM);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TTL_KEY, snapshotTTL);
        SnapshotTestingUtils.snapshot(UTIL.getAdmin(), snapshotName, tableName, SnapshotType.FLUSH, 3, props);
        LOG.debug("Snapshot completed.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshotName, tableName);
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((long)snapshotTTL, (long)snapshots.get(0).getTtl());
    }
}

