/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDefaultStoreEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultStoreEngine.class);

    @Test
    public void testCustomParts() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.defaultengine.compactor.class", DummyCompactor.class.getName());
        conf.set("hbase.hstore.defaultengine.compactionpolicy.class", DummyCompactionPolicy.class.getName());
        conf.set("hbase.hstore.defaultengine.storeflusher.class", DummyStoreFlusher.class.getName());
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        mockStore.conf = conf;
        Mockito.when((Object)mockStore.getRegionInfo()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO);
        Mockito.when((Object)mockStore.getHRegion()).thenReturn((Object)mockRegion);
        StoreEngine se = StoreEngine.create((HStore)mockStore, (Configuration)conf, (CellComparator)CellComparatorImpl.COMPARATOR);
        Assert.assertTrue((boolean)(se instanceof DefaultStoreEngine));
        Assert.assertTrue((boolean)(se.getCompactionPolicy() instanceof DummyCompactionPolicy));
        Assert.assertTrue((boolean)(se.getStoreFlusher() instanceof DummyStoreFlusher));
        Assert.assertTrue((boolean)(se.getCompactor() instanceof DummyCompactor));
    }

    public static class DummyCompactionPolicy
    extends RatioBasedCompactionPolicy {
        public DummyCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
            super(conf, storeConfigInfo);
        }
    }

    public static class DummyCompactor
    extends DefaultCompactor {
        public DummyCompactor(Configuration conf, HStore store) {
            super(conf, store);
        }
    }

    public static class DummyStoreFlusher
    extends DefaultStoreFlusher {
        public DummyStoreFlusher(Configuration conf, HStore store) {
            super(conf, store);
        }
    }
}

