/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.CompressedWALTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestCompressedWALValueCompression
extends CompressedWALTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompressedWALValueCompression.class);
    @Rule
    public TestName name = new TestName();
    private final Compression.Algorithm compression;

    @Parameterized.Parameters(name="{index}: compression={0}")
    public static List<Object[]> params() {
        return HBaseTestingUtility.COMPRESSION_ALGORITHMS_PARAMETERIZED;
    }

    public TestCompressedWALValueCompression(Compression.Algorithm algo) {
        this.compression = algo;
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.wal.enablecompression", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.wal.value.enablecompression", true);
        TEST_UTIL.getConfiguration().set("hbase.regionserver.wal.value.compression.type", this.compression.getName());
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[^a-zA-Z0-9]", "_"));
        this.doTest(tableName);
    }
}

