/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.NormalUserScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.RawScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class UserScanQueryMatcher
extends ScanQueryMatcher {
    protected final boolean hasNullColumn;
    protected final Filter filter;
    protected final byte[] stopRow;
    protected final TimeRange tr;
    private final int versionsAfterFilter;
    private int count = 0;
    private Cell curColCell = null;

    private static Cell createStartKey(Scan scan, ScanInfo scanInfo) {
        if (scan.includeStartRow()) {
            return UserScanQueryMatcher.createStartKeyFromRow(scan.getStartRow(), scanInfo);
        }
        return PrivateCellUtil.createLastOnRow((byte[])scan.getStartRow());
    }

    protected UserScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, long oldestUnexpiredTS, long now) {
        super(UserScanQueryMatcher.createStartKey(scan, scanInfo), scanInfo, columns, oldestUnexpiredTS, now);
        this.hasNullColumn = hasNullColumn;
        this.filter = scan.getFilter();
        this.versionsAfterFilter = this.filter != null ? (scan.isRaw() ? scan.getMaxVersions() : Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions())) : 0;
        this.stopRow = scan.getStopRow();
        TimeRange timeRange = (TimeRange)scan.getColumnFamilyTimeRange().get(scanInfo.getFamily());
        this.tr = timeRange == null ? scan.getTimeRange() : timeRange;
    }

    @Override
    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    @Override
    public boolean isUserScan() {
        return true;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Cell getNextKeyHint(Cell cell) throws IOException {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextCellHint(cell);
    }

    @Override
    public void beforeShipped() throws IOException {
        super.beforeShipped();
        if (this.curColCell != null) {
            this.curColCell = KeyValueUtil.toNewKeyCell((Cell)this.curColCell);
        }
    }

    protected final ScanQueryMatcher.MatchCode matchColumn(Cell cell, long timestamp, byte typeByte) throws IOException {
        int tsCmp = this.tr.compare(timestamp);
        if (tsCmp > 0) {
            return ScanQueryMatcher.MatchCode.SKIP;
        }
        if (tsCmp < 0) {
            return this.columns.getNextRowOrNextColumn(cell);
        }
        ScanQueryMatcher.MatchCode matchCode = this.columns.checkColumn(cell, typeByte);
        if (matchCode != ScanQueryMatcher.MatchCode.INCLUDE) {
            return matchCode;
        }
        matchCode = this.columns.checkVersions(cell, timestamp, typeByte, false);
        switch (matchCode) {
            case SKIP: {
                return ScanQueryMatcher.MatchCode.SKIP;
            }
            case SEEK_NEXT_COL: {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
        }
        assert (matchCode == ScanQueryMatcher.MatchCode.INCLUDE || matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL || matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        return this.filter == null ? matchCode : this.mergeFilterResponse(cell, matchCode, this.filter.filterCell(cell));
    }

    private final ScanQueryMatcher.MatchCode mergeFilterResponse(Cell cell, ScanQueryMatcher.MatchCode matchCode, Filter.ReturnCode filterResponse) {
        switch (filterResponse) {
            case SKIP: {
                if (matchCode == ScanQueryMatcher.MatchCode.INCLUDE) {
                    return ScanQueryMatcher.MatchCode.SKIP;
                }
                if (matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                    return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
                }
                if (matchCode != ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) break;
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            case NEXT_COL: {
                if (matchCode == ScanQueryMatcher.MatchCode.INCLUDE || matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                    return this.columns.getNextRowOrNextColumn(cell);
                }
                if (matchCode != ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) break;
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            case NEXT_ROW: {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            case SEEK_NEXT_USING_HINT: {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_USING_HINT;
            }
            case INCLUDE: {
                break;
            }
            case INCLUDE_AND_NEXT_COL: {
                if (matchCode != ScanQueryMatcher.MatchCode.INCLUDE) break;
                matchCode = ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
                break;
            }
            case INCLUDE_AND_SEEK_NEXT_ROW: {
                matchCode = ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW;
                break;
            }
            default: {
                throw new RuntimeException("UNEXPECTED");
            }
        }
        assert (matchCode == ScanQueryMatcher.MatchCode.INCLUDE || matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL || matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        if (this.curColCell == null || !CellUtil.matchingRowColumn((Cell)cell, (Cell)this.curColCell)) {
            this.count = 0;
            this.curColCell = cell;
        }
        ++this.count;
        if (this.count > this.versionsAfterFilter) {
            matchCode = matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW ? ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW : ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        if (matchCode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL || matchCode == ScanQueryMatcher.MatchCode.SEEK_NEXT_COL) {
            this.columns.doneWithColumn(cell);
        }
        return matchCode;
    }

    protected abstract boolean isGet();

    protected abstract boolean moreRowsMayExistsAfter(int var1);

    @Override
    public boolean moreRowsMayExistAfter(Cell cell) {
        if (this.isGet()) {
            return false;
        }
        if (this.stopRow == null || this.stopRow.length == 0) {
            return true;
        }
        return this.moreRowsMayExistsAfter(this.rowComparator.compareRows(cell, this.stopRow, 0, this.stopRow.length));
    }

    public static UserScanQueryMatcher create(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long oldestUnexpiredTS, long now, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        boolean hasNullColumn = columns == null || columns.size() == 0 || ((byte[])columns.first()).length == 0;
        Pair<DeleteTracker, ColumnTracker> trackers = UserScanQueryMatcher.getTrackers(regionCoprocessorHost, columns, scanInfo, oldestUnexpiredTS, scan);
        DeleteTracker deleteTracker = (DeleteTracker)trackers.getFirst();
        ColumnTracker columnTracker = (ColumnTracker)trackers.getSecond();
        if (scan.isRaw()) {
            return RawScanQueryMatcher.create(scan, scanInfo, columnTracker, hasNullColumn, oldestUnexpiredTS, now);
        }
        return NormalUserScanQueryMatcher.create(scan, scanInfo, columnTracker, deleteTracker, hasNullColumn, oldestUnexpiredTS, now);
    }
}

