/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.MigrationStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class StoreFileTrackerValidationUtils {
    private StoreFileTrackerValidationUtils() {
    }

    private static void checkForNewFamily(Configuration conf, TableDescriptor table, ColumnFamilyDescriptor family) throws IOException {
        Configuration mergedConf = StoreUtils.createStoreConfiguration(conf, table, family);
        Class<? extends StoreFileTracker> tracker = StoreFileTrackerFactory.getTrackerClass(mergedConf);
        if (MigrationStoreFileTracker.class.isAssignableFrom(tracker)) {
            throw new DoNotRetryIOException("Should not use " + (Object)((Object)StoreFileTrackerFactory.Trackers.MIGRATION) + " as store file tracker for new family " + family.getNameAsString() + " of table " + table.getTableName());
        }
    }

    public static void checkForCreateTable(Configuration conf, TableDescriptor table) throws IOException {
        for (ColumnFamilyDescriptor family : table.getColumnFamilies()) {
            StoreFileTrackerValidationUtils.checkForNewFamily(conf, table, family);
        }
    }

    public static void checkForModifyTable(Configuration conf, TableDescriptor oldTable, TableDescriptor newTable, boolean isTableDisabled) throws IOException {
        for (ColumnFamilyDescriptor newFamily : newTable.getColumnFamilies()) {
            ColumnFamilyDescriptor oldFamily = oldTable.getColumnFamily(newFamily.getName());
            if (oldFamily == null) {
                StoreFileTrackerValidationUtils.checkForNewFamily(conf, newTable, newFamily);
                continue;
            }
            Configuration oldConf = StoreUtils.createStoreConfiguration(conf, oldTable, oldFamily);
            Configuration newConf = StoreUtils.createStoreConfiguration(conf, newTable, newFamily);
            Class<? extends StoreFileTracker> oldTracker = StoreFileTrackerFactory.getTrackerClass(oldConf);
            Class<? extends StoreFileTracker> newTracker = StoreFileTrackerFactory.getTrackerClass(newConf);
            if (MigrationStoreFileTracker.class.isAssignableFrom(oldTracker)) {
                Class<? extends StoreFileTracker> oldSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(oldConf);
                Class<? extends StoreFileTracker> oldDstTracker = MigrationStoreFileTracker.getDstTrackerClass(oldConf);
                if (oldTracker.equals(newTracker)) {
                    Class<? extends StoreFileTracker> newSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(newConf);
                    if (!oldSrcTracker.equals(newSrcTracker)) {
                        throw new DoNotRetryIOException("The src tracker has been changed from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldSrcTracker) + " to " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
                    }
                    Class<? extends StoreFileTracker> newDstTracker = MigrationStoreFileTracker.getDstTrackerClass(newConf);
                    if (oldDstTracker.equals(newDstTracker)) continue;
                    throw new DoNotRetryIOException("The dst tracker has been changed from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldDstTracker) + " to " + StoreFileTrackerFactory.getStoreFileTrackerName(newDstTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
                }
                if (isTableDisabled) {
                    throw new TableNotEnabledException("Should not change store file tracker implementation from " + StoreFileTrackerFactory.Trackers.MIGRATION.name() + " while table " + newTable.getTableName() + " is disabled");
                }
                if (newTracker.equals(oldDstTracker)) continue;
                throw new DoNotRetryIOException("Should migrate tracker to " + StoreFileTrackerFactory.getStoreFileTrackerName(oldDstTracker) + " but got " + StoreFileTrackerFactory.getStoreFileTrackerName(newTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            if (oldTracker.equals(newTracker)) continue;
            if (!MigrationStoreFileTracker.class.isAssignableFrom(newTracker)) {
                throw new DoNotRetryIOException("Should change to " + (Object)((Object)StoreFileTrackerFactory.Trackers.MIGRATION) + " first when migrating from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            Class<? extends StoreFileTracker> newSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(newConf);
            if (!oldTracker.equals(newSrcTracker)) {
                throw new DoNotRetryIOException("Should use src tracker " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " first but got " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " when migrating from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            Class<? extends StoreFileTracker> newDstTracker = MigrationStoreFileTracker.getDstTrackerClass(newConf);
            if (!newSrcTracker.equals(newDstTracker)) continue;
            throw new DoNotRetryIOException("The src tracker and dst tracker are both " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
        }
    }

    public static void validatePreRestoreSnapshot(TableDescriptor currentTableDesc, TableDescriptor snapshotTableDesc, Configuration baseConf) throws RestoreSnapshotException {
        for (ColumnFamilyDescriptor cfDesc : currentTableDesc.getColumnFamilies()) {
            Class<? extends StoreFileTracker> snapSFT;
            ColumnFamilyDescriptor snapCFDesc = snapshotTableDesc.getColumnFamily(cfDesc.getName());
            if (snapCFDesc == null) continue;
            Configuration currentCompositeConf = StoreUtils.createStoreConfiguration(baseConf, currentTableDesc, cfDesc);
            Configuration snapCompositeConf = StoreUtils.createStoreConfiguration(baseConf, snapshotTableDesc, snapCFDesc);
            Class<? extends StoreFileTracker> currentSFT = StoreFileTrackerFactory.getTrackerClass(currentCompositeConf);
            if (currentSFT == (snapSFT = StoreFileTrackerFactory.getTrackerClass(snapCompositeConf))) continue;
            throw new RestoreSnapshotException("Restoring Snapshot is not possible because  the config for column family " + cfDesc.getNameAsString() + " has incompatible configuration. Current SFT: " + currentSFT + " SFT from snapshot: " + snapSFT);
        }
    }
}

