/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.RecoverySnapshotUtils;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TruncateRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.TruncateRegionState> {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateRegionProcedure.class);
    private String recoverySnapshotName;

    public TruncateRegionProcedure() {
    }

    public TruncateRegionProcedure(MasterProcedureEnv env, RegionInfo hri) throws HBaseIOException {
        super(env, hri);
        TruncateRegionProcedure.checkOnline(env, this.getRegion());
    }

    public TruncateRegionProcedure(MasterProcedureEnv env, RegionInfo region, ProcedurePrepareLatch latch) throws HBaseIOException {
        super(env, region, latch);
        this.preflightChecks(env, true);
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateRegionState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case TRUNCATE_REGION_PRE_OPERATION: {
                    if (!this.prepareTruncate()) {
                        assert (this.isFailed()) : "the truncate should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    TruncateRegionProcedure.checkOnline(env, this.getRegion());
                    assert (this.getRegion().getReplicaId() == 0 || this.isFailed()) : "Can't truncate replicas directly. Replicas are auto-truncated when their primary is truncated.";
                    this.preTruncate(env);
                    if (RecoverySnapshotUtils.isRecoveryEnabled(env)) {
                        this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_SNAPSHOT);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_MAKE_OFFLINE);
                    break;
                }
                case TRUNCATE_REGION_SNAPSHOT: {
                    this.recoverySnapshotName = RecoverySnapshotUtils.generateSnapshotName(this.getTableName());
                    SnapshotProcedure snapshotProcedure = RecoverySnapshotUtils.createSnapshotProcedure(env, this.getTableName(), this.recoverySnapshotName, env.getMasterServices().getTableDescriptors().get(this.getTableName()));
                    this.addChildProcedure((Procedure[])new SnapshotProcedure[]{snapshotProcedure});
                    LOG.debug("Creating recovery snapshot {} for table {} before truncating region {}", new Object[]{this.recoverySnapshotName, this.getTableName(), this.getRegion().getRegionNameAsString()});
                    this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_MAKE_OFFLINE);
                    break;
                }
                case TRUNCATE_REGION_MAKE_OFFLINE: {
                    this.addChildProcedure((Procedure[])new TransitRegionStateProcedure[]{this.createUnAssignProcedures(env)});
                    this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_REMOVE);
                    break;
                }
                case TRUNCATE_REGION_REMOVE: {
                    this.deleteRegionFromFileSystem(env);
                    this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_MAKE_ONLINE);
                    break;
                }
                case TRUNCATE_REGION_MAKE_ONLINE: {
                    this.createRegionOnFileSystem(env);
                    this.addChildProcedure((Procedure[])new TransitRegionStateProcedure[]{this.createAssignProcedures(env)});
                    this.setNextState(MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_POST_OPERATION);
                    break;
                }
                case TRUNCATE_REGION_POST_OPERATION: {
                    this.postTruncate(env);
                    LOG.debug("truncate '" + this.getTableName() + "' completed");
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-truncate-region", e);
            }
            LOG.warn("Retriable error trying to truncate region=" + this.getRegion().getRegionNameAsString() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegionOnFileSystem(MasterProcedureEnv env) throws IOException {
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getRegion());
        regionNode.lock();
        try {
            MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
            Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
            HRegionFileSystem.createRegionOnFileSystem(env.getMasterConfiguration(), mfs.getFileSystem(), tableDir, this.getRegion());
        }
        finally {
            regionNode.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRegionFromFileSystem(MasterProcedureEnv env) throws IOException {
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getRegion());
        try {
            regionNode.lock();
            MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
            Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
            HRegionFileSystem.deleteRegionFromFileSystem(env.getMasterConfiguration(), mfs.getFileSystem(), tableDir, this.getRegion());
        }
        finally {
            regionNode.unlock();
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.TruncateRegionState state) throws IOException {
        switch (state) {
            case TRUNCATE_REGION_PRE_OPERATION: {
                return;
            }
            case TRUNCATE_REGION_SNAPSHOT: {
                if (this.recoverySnapshotName != null) {
                    RecoverySnapshotUtils.deleteRecoverySnapshot(env, this.recoverySnapshotName, this.getTableName());
                    this.recoverySnapshotName = null;
                }
                return;
            }
            case TRUNCATE_REGION_MAKE_OFFLINE: {
                RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getRegion());
                if (regionNode == null) {
                    this.addChildProcedure((Procedure[])new TransitRegionStateProcedure[]{this.createAssignProcedures(env)});
                }
                return;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.TruncateRegionState state) {
        switch (state) {
            case TRUNCATE_REGION_PRE_OPERATION: 
            case TRUNCATE_REGION_SNAPSHOT: 
            case TRUNCATE_REGION_MAKE_OFFLINE: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.TruncateRegionState getState(int stateId) {
        return MasterProcedureProtos.TruncateRegionState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.TruncateRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.TruncateRegionState getInitialState() {
        return MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_PRE_OPERATION;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (region=");
        sb.append(this.getRegion().getRegionNameAsString());
        sb.append(")");
    }

    private boolean prepareTruncate() throws IOException {
        if (this.getTableName().equals((Object)TableName.META_TABLE_NAME)) {
            throw new IOException("Can't truncate region in catalog tables");
        }
        return true;
    }

    private void preTruncate(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTruncateRegionAction(this.getRegion(), this.getUser());
        }
    }

    private void postTruncate(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postTruncateRegionAction(this.getRegion(), this.getUser());
        }
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_TRUNCATE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.TruncateRegionStateData.Builder state = MasterProcedureProtos.TruncateRegionStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.getRegion()));
        if (this.recoverySnapshotName != null) {
            state.setSnapshotName(this.recoverySnapshotName);
        }
        serializer.serialize((Message)state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.TruncateRegionStateData state = (MasterProcedureProtos.TruncateRegionStateData)serializer.deserialize(MasterProcedureProtos.TruncateRegionStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(state.getUserInfo()));
        this.setRegion(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)state.getRegionInfo()));
        if (state.hasSnapshotName()) {
            this.recoverySnapshotName = state.getSnapshotName();
        }
    }

    private TransitRegionStateProcedure createUnAssignProcedures(MasterProcedureEnv env) throws IOException {
        return env.getAssignmentManager().createOneUnassignProcedure(this.getRegion(), true);
    }

    private TransitRegionStateProcedure createAssignProcedures(MasterProcedureEnv env) {
        return env.getAssignmentManager().createOneAssignProcedure(this.getRegion(), true);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        if (RecoverySnapshotUtils.isRecoveryEnabled(env)) {
            return false;
        }
        return super.holdLock(env);
    }
}

