/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.BalancerDecision;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.namequeues.BalancerDecisionDetails;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RecentLogs;
import org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Queues;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BalancerDecisionQueueService
implements NamedQueueService {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerDecisionQueueService.class);
    private final boolean isBalancerDecisionRecording;
    private static final String BALANCER_DECISION_QUEUE_SIZE = "hbase.master.balancer.decision.queue.size";
    private static final int DEFAULT_BALANCER_DECISION_QUEUE_SIZE = 250;
    private static final int REGION_PLANS_THRESHOLD_PER_BALANCER = 15;
    private final Queue<RecentLogs.BalancerDecision> balancerDecisionQueue;

    public BalancerDecisionQueueService(Configuration conf) {
        this.isBalancerDecisionRecording = conf.getBoolean("hbase.master.balancer.decision.buffer.enabled", false);
        if (!this.isBalancerDecisionRecording) {
            this.balancerDecisionQueue = null;
            return;
        }
        int queueSize = conf.getInt(BALANCER_DECISION_QUEUE_SIZE, 250);
        EvictingQueue evictingQueue = EvictingQueue.create((int)queueSize);
        this.balancerDecisionQueue = Queues.synchronizedQueue((Queue)evictingQueue);
    }

    @Override
    public NamedQueuePayload.NamedQueueEvent getEvent() {
        return NamedQueuePayload.NamedQueueEvent.BALANCE_DECISION;
    }

    @Override
    public void consumeEventFromDisruptor(NamedQueuePayload namedQueuePayload) {
        if (!this.isBalancerDecisionRecording) {
            return;
        }
        if (!(namedQueuePayload instanceof BalancerDecisionDetails)) {
            LOG.warn("BalancerDecisionQueueService: NamedQueuePayload is not of type BalancerDecisionDetails.");
            return;
        }
        BalancerDecisionDetails balancerDecisionDetails = (BalancerDecisionDetails)namedQueuePayload;
        BalancerDecision balancerDecisionRecords = balancerDecisionDetails.getBalancerDecision();
        List regionPlans = balancerDecisionRecords.getRegionPlans();
        List regionPlansList = regionPlans.size() > 15 ? Lists.partition((List)regionPlans, (int)15) : Collections.singletonList(regionPlans);
        for (List regionPlansPerBalancer : regionPlansList) {
            RecentLogs.BalancerDecision balancerDecision = RecentLogs.BalancerDecision.newBuilder().setInitTotalCost(balancerDecisionRecords.getInitTotalCost()).setInitialFunctionCosts(balancerDecisionRecords.getInitialFunctionCosts()).setComputedTotalCost(balancerDecisionRecords.getComputedTotalCost()).setFinalFunctionCosts(balancerDecisionRecords.getFinalFunctionCosts()).setComputedSteps(balancerDecisionRecords.getComputedSteps()).addAllRegionPlans((Iterable)regionPlansPerBalancer).build();
            this.balancerDecisionQueue.add(balancerDecision);
        }
    }

    @Override
    public boolean clearNamedQueue() {
        if (!this.isBalancerDecisionRecording) {
            return false;
        }
        LOG.debug("Received request to clean up balancer decision queue.");
        this.balancerDecisionQueue.clear();
        return true;
    }

    @Override
    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        if (!this.isBalancerDecisionRecording) {
            return null;
        }
        List<RecentLogs.BalancerDecision> balancerDecisions = Arrays.stream(this.balancerDecisionQueue.toArray(new RecentLogs.BalancerDecision[0])).collect(Collectors.toList());
        Collections.reverse(balancerDecisions);
        int limit = balancerDecisions.size();
        if (request.getBalancerDecisionsRequest().hasLimit()) {
            limit = Math.min(request.getBalancerDecisionsRequest().getLimit(), balancerDecisions.size());
        }
        balancerDecisions = balancerDecisions.subList(0, limit);
        NamedQueueGetResponse namedQueueGetResponse = new NamedQueueGetResponse();
        namedQueueGetResponse.setNamedQueueEvent(1);
        namedQueueGetResponse.setBalancerDecisions(balancerDecisions);
        return namedQueueGetResponse;
    }

    @Override
    public void persistAll(Connection connection) {
    }
}

