/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.NoOpRetryableCallerInterceptor;
import org.apache.hadoop.hbase.client.PreemptiveFastFailInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RetryingCallerInterceptorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingCallerInterceptorFactory.class);
    private Configuration conf;
    private final boolean failFast;
    public static final RetryingCallerInterceptor NO_OP_INTERCEPTOR = new NoOpRetryableCallerInterceptor(null);

    public RetryingCallerInterceptorFactory(Configuration conf) {
        this.conf = conf;
        this.failFast = conf.getBoolean("hbase.client.fast.fail.mode.enabled", false);
    }

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Convert thrown exception to unchecked")
    public RetryingCallerInterceptor build() {
        RetryingCallerInterceptor ret = NO_OP_INTERCEPTOR;
        if (this.failFast) {
            try {
                Class<?> c = this.conf.getClass("hbase.client.fast.fail.interceptor.impl", PreemptiveFastFailInterceptor.class);
                Constructor<?> constructor = c.getDeclaredConstructor(Configuration.class);
                constructor.setAccessible(true);
                ret = (RetryingCallerInterceptor)constructor.newInstance(this.conf);
            }
            catch (Exception e) {
                ret = new PreemptiveFastFailInterceptor(this.conf);
            }
        }
        LOG.trace("Using " + ret.toString() + " for intercepting the RpcRetryingCaller");
        return ret;
    }
}

