/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.MetricSet;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.metrics.impl.CounterImpl;
import org.apache.hadoop.hbase.metrics.impl.DropwizardMeter;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hadoop.hbase.metrics.impl.TimerImpl;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricRegistryImpl
implements MetricRegistry {
    private final MetricRegistryInfo info;
    private final ConcurrentMap<String, Metric> metrics;

    public MetricRegistryImpl(MetricRegistryInfo info) {
        this.info = info;
        this.metrics = new ConcurrentHashMap<String, Metric>();
    }

    @Override
    public Timer timer(String name) {
        return (Timer)CollectionUtils.computeIfAbsent(this.metrics, name, this::createTimer);
    }

    protected Timer createTimer() {
        return new TimerImpl();
    }

    @Override
    public Histogram histogram(String name) {
        return (Histogram)CollectionUtils.computeIfAbsent(this.metrics, name, this::createHistogram);
    }

    protected Histogram createHistogram() {
        return new HistogramImpl();
    }

    @Override
    public Meter meter(String name) {
        return (Meter)CollectionUtils.computeIfAbsent(this.metrics, name, this::createMeter);
    }

    protected Meter createMeter() {
        return new DropwizardMeter();
    }

    @Override
    public Counter counter(String name) {
        return (Counter)CollectionUtils.computeIfAbsent(this.metrics, name, this::createCounter);
    }

    protected Counter createCounter() {
        return new CounterImpl();
    }

    @Override
    public Optional<Metric> get(String name) {
        return Optional.ofNullable(this.metrics.get(name));
    }

    @Override
    public Metric register(String name, Metric metric) {
        return CollectionUtils.computeIfAbsent(this.metrics, name, () -> metric);
    }

    @Override
    public <T> Gauge<T> register(String name, Gauge<T> gauge) {
        return (Gauge)this.register(name, (Metric)gauge);
    }

    @Override
    public void registerAll(MetricSet metricSet) {
        metricSet.getMetrics().forEach(this::register);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean remove(String name) {
        return this.metrics.remove(name) != null;
    }

    @Override
    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }
}

