/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.AuthenticationProviderSelector;
import org.apache.hadoop.hbase.security.provider.BuiltInProviderSelector;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SimpleSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Authentication"})
@InterfaceStability.Evolving
public final class SaslClientAuthenticationProviders {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientAuthenticationProviders.class);
    public static final String SELECTOR_KEY = "hbase.client.sasl.provider.class";
    public static final String EXTRA_PROVIDERS_KEY = "hbase.client.sasl.provider.extras";
    private static final AtomicReference<SaslClientAuthenticationProviders> providersRef = new AtomicReference();
    private final Collection<SaslClientAuthenticationProvider> providers;
    private final AuthenticationProviderSelector selector;

    private SaslClientAuthenticationProviders(Collection<SaslClientAuthenticationProvider> providers, AuthenticationProviderSelector selector) {
        this.providers = providers;
        this.selector = selector;
    }

    public int getNumRegisteredProviders() {
        return this.providers.size();
    }

    public static synchronized SaslClientAuthenticationProviders getInstance(Configuration conf) {
        SaslClientAuthenticationProviders providers = providersRef.get();
        if (providers == null) {
            providers = SaslClientAuthenticationProviders.instantiate(conf);
            providersRef.set(providers);
        }
        return providers;
    }

    public static synchronized void reset() {
        providersRef.set(null);
    }

    static void addProviderIfNotExists(SaslClientAuthenticationProvider provider, HashMap<Byte, SaslClientAuthenticationProvider> providers) {
        Byte code = provider.getSaslAuthMethod().getCode();
        SaslClientAuthenticationProvider existingProvider = providers.get(code);
        if (existingProvider != null) {
            throw new RuntimeException("Already registered authentication provider with " + code + " " + existingProvider.getClass());
        }
        providers.put(code, provider);
    }

    static AuthenticationProviderSelector instantiateSelector(Configuration conf, Collection<SaslClientAuthenticationProvider> providers) {
        Class<AuthenticationProviderSelector> clz = conf.getClass(SELECTOR_KEY, BuiltInProviderSelector.class, AuthenticationProviderSelector.class);
        try {
            AuthenticationProviderSelector selector = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            selector.configure(conf, providers);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loaded ProviderSelector {}", selector.getClass());
            }
            return selector;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate " + clz + " as the ProviderSelector defined by " + SELECTOR_KEY, e);
        }
    }

    static void addExplicitProviders(Configuration conf, HashMap<Byte, SaslClientAuthenticationProvider> providers) {
        for (String implName : conf.getStringCollection(EXTRA_PROVIDERS_KEY)) {
            SaslClientAuthenticationProvider provider;
            Class<?> clz;
            try {
                clz = Class.forName(implName);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to load SaslClientAuthenticationProvider {}", (Object)implName, (Object)e);
                continue;
            }
            if (!SaslClientAuthenticationProvider.class.isAssignableFrom(clz)) {
                LOG.warn("Ignoring SaslClientAuthenticationProvider {} because it is not an instance of SaslClientAuthenticationProvider", clz);
                continue;
            }
            try {
                provider = (SaslClientAuthenticationProvider)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Failed to instantiate SaslClientAuthenticationProvider {}", clz, (Object)e);
                continue;
            }
            SaslClientAuthenticationProviders.addProviderIfNotExists(provider, providers);
        }
    }

    static SaslClientAuthenticationProviders instantiate(Configuration conf) {
        ServiceLoader<SaslClientAuthenticationProvider> loader = ServiceLoader.load(SaslClientAuthenticationProvider.class);
        HashMap<Byte, SaslClientAuthenticationProvider> providerMap = new HashMap<Byte, SaslClientAuthenticationProvider>();
        for (SaslClientAuthenticationProvider provider2 : loader) {
            SaslClientAuthenticationProviders.addProviderIfNotExists(provider2, providerMap);
        }
        SaslClientAuthenticationProviders.addExplicitProviders(conf, providerMap);
        Collection<SaslClientAuthenticationProvider> providers = Collections.unmodifiableCollection(providerMap.values());
        if (LOG.isTraceEnabled()) {
            String loadedProviders = providers.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(", "));
            LOG.trace("Found SaslClientAuthenticationProviders {}", (Object)loadedProviders);
        }
        AuthenticationProviderSelector selector = SaslClientAuthenticationProviders.instantiateSelector(conf, providers);
        return new SaslClientAuthenticationProviders(providers, selector);
    }

    public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> getSimpleProvider() {
        Optional<SaslClientAuthenticationProvider> optional = this.providers.stream().filter(p -> p instanceof SimpleSaslClientAuthenticationProvider).findFirst();
        return new Pair<SaslClientAuthenticationProvider, Object>(optional.get(), null);
    }

    public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> selectProvider(String clusterId, User clientUser) {
        return this.selector.selectProvider(clusterId, clientUser);
    }

    public String toString() {
        return this.providers.stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", ", "providers=[", "], selector=")) + this.selector.getClass();
    }
}

