/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="If exception, presume HAS_NEW_DNS_GET_DEFAULT_HOST_API false")
public final class DNS {
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static final String UNSAFE_RS_HOSTNAME_KEY = "hbase.unsafe.regionserver.hostname";
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static final String MASTER_HOSTNAME_KEY = "hbase.master.hostname";
    private static boolean HAS_NEW_DNS_GET_DEFAULT_HOST_API;
    private static Method GET_DEFAULT_HOST_METHOD;
    @Deprecated
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static final String RS_HOSTNAME_KEY = "hbase.regionserver.hostname";

    private DNS() {
    }

    public static String getDefaultHost(String strInterface, String nameserver) throws UnknownHostException {
        if (HAS_NEW_DNS_GET_DEFAULT_HOST_API) {
            try {
                return (String)GET_DEFAULT_HOST_METHOD.invoke(null, strInterface, nameserver, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke DNS.getDefaultHost via reflection", e);
            }
        }
        return org.apache.hadoop.net.DNS.getDefaultHost(strInterface, nameserver);
    }

    public static String getHostname(@NonNull Configuration conf, @NonNull ServerType serverType) throws UnknownHostException {
        String hostname;
        switch (serverType) {
            case MASTER: {
                hostname = conf.get(MASTER_HOSTNAME_KEY);
                break;
            }
            case REGIONSERVER: {
                hostname = conf.get(UNSAFE_RS_HOSTNAME_KEY);
                break;
            }
            default: {
                hostname = null;
            }
        }
        if (hostname == null || hostname.isEmpty()) {
            return Strings.domainNamePointerToHostName(DNS.getDefaultHost(conf.get("hbase." + serverType.getName() + ".dns.interface", "default"), conf.get("hbase." + serverType.getName() + ".dns.nameserver", "default")));
        }
        return hostname;
    }

    static {
        try {
            GET_DEFAULT_HOST_METHOD = org.apache.hadoop.net.DNS.class.getMethod("getDefaultHost", String.class, String.class, Boolean.TYPE);
            HAS_NEW_DNS_GET_DEFAULT_HOST_API = true;
        }
        catch (Exception e) {
            HAS_NEW_DNS_GET_DEFAULT_HOST_API = false;
        }
        Configuration.addDeprecation(RS_HOSTNAME_KEY, UNSAFE_RS_HOSTNAME_KEY);
    }

    public static enum ServerType {
        MASTER("master"),
        REGIONSERVER("regionserver");

        private String name;

        private ServerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

