/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@Deprecated
public class ReplicationAdmin
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationAdmin.class);
    public static final String TNAME = "tableName";
    public static final String CFNAME = "columnFamilyName";
    public static final String REPLICATIONTYPE = "replicationType";
    public static final String REPLICATIONGLOBAL = Integer.toString(1);
    private final Connection connection;
    private Admin admin;

    public ReplicationAdmin(Configuration conf) throws IOException {
        this.connection = ConnectionFactory.createConnection(conf);
        this.admin = this.connection.getAdmin();
    }

    @Deprecated
    public void addPeer(String id, ReplicationPeerConfig peerConfig, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs != null) {
            peerConfig.setTableCFsMap(tableCfs);
        }
        this.admin.addReplicationPeer(id, peerConfig);
    }

    @Deprecated
    public void addPeer(String id, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        this.admin.addReplicationPeer(id, peerConfig);
    }

    @Deprecated
    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        return ReplicationPeerConfigUtil.parseTableCFsFromConfig(tableCFsConfig);
    }

    @Deprecated
    public void updatePeerConfig(String id, ReplicationPeerConfig peerConfig) throws IOException {
        this.admin.updateReplicationPeerConfig(id, peerConfig);
    }

    @Deprecated
    public void removePeer(String id) throws IOException {
        this.admin.removeReplicationPeer(id);
    }

    @Deprecated
    public void enablePeer(String id) throws IOException {
        this.admin.enableReplicationPeer(id);
    }

    @Deprecated
    public void disablePeer(String id) throws IOException {
        this.admin.disableReplicationPeer(id);
    }

    @Deprecated
    public int getPeersCount() throws IOException {
        return this.admin.listReplicationPeers().size();
    }

    @Deprecated
    public Map<String, ReplicationPeerConfig> listPeerConfigs() throws IOException {
        List<ReplicationPeerDescription> peers = this.admin.listReplicationPeers();
        TreeMap<String, ReplicationPeerConfig> result = new TreeMap<String, ReplicationPeerConfig>();
        for (ReplicationPeerDescription peer : peers) {
            result.put(peer.getPeerId(), peer.getPeerConfig());
        }
        return result;
    }

    @Deprecated
    public ReplicationPeerConfig getPeerConfig(String id) throws IOException {
        return this.admin.getReplicationPeerConfig(id);
    }

    @Deprecated
    public String getPeerTableCFs(String id) throws IOException {
        ReplicationPeerConfig peerConfig = this.admin.getReplicationPeerConfig(id);
        return ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap());
    }

    @Deprecated
    public void appendPeerTableCFs(String id, String tableCfs) throws ReplicationException, IOException {
        this.appendPeerTableCFs(id, ReplicationPeerConfigUtil.parseTableCFsFromConfig(tableCfs));
    }

    @Deprecated
    public void appendPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        this.admin.appendReplicationPeerTableCFs(id, this.copyTableCFs(tableCfs));
    }

    @Deprecated
    public void removePeerTableCFs(String id, String tableCf) throws ReplicationException, IOException {
        this.removePeerTableCFs(id, ReplicationPeerConfigUtil.parseTableCFsFromConfig(tableCf));
    }

    @Deprecated
    public void removePeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
        this.admin.removeReplicationPeerTableCFs(id, this.copyTableCFs(tableCfs));
    }

    private Map<TableName, List<String>> copyTableCFs(Map<TableName, ? extends Collection<String>> tableCfs) {
        HashMap<TableName, List<String>> newTableCfs = new HashMap<TableName, List<String>>();
        if (tableCfs != null) {
            tableCfs.forEach((table, cfs) -> {
                List cfr_ignored_0 = newTableCfs.put((TableName)table, cfs != null ? Lists.newArrayList(cfs) : null);
            });
        }
        return newTableCfs;
    }

    @Deprecated
    public void setPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws IOException {
        ReplicationPeerConfig peerConfig = this.getPeerConfig(id);
        peerConfig.setTableCFsMap(tableCfs);
        this.updatePeerConfig(id, peerConfig);
    }

    @Deprecated
    public boolean getPeerState(String id) throws ReplicationException, IOException {
        List<ReplicationPeerDescription> peers = this.admin.listReplicationPeers(Pattern.compile(id));
        if (peers.isEmpty() || !id.equals(peers.get(0).getPeerId())) {
            throw new ReplicationPeerNotFoundException(id);
        }
        return peers.get(0).isEnabled();
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.admin.close();
    }

    @Deprecated
    public List<HashMap<String, String>> listReplicated() throws IOException {
        ArrayList<HashMap<String, String>> replicationColFams = new ArrayList<HashMap<String, String>>();
        this.admin.listReplicatedTableCFs().forEach(tableCFs -> {
            String table = tableCFs.getTable().getNameAsString();
            tableCFs.getColumnFamilyMap().forEach((cf, scope) -> {
                HashMap<String, String> replicationEntry = new HashMap<String, String>();
                replicationEntry.put(TNAME, table);
                replicationEntry.put(CFNAME, (String)cf);
                replicationEntry.put(REPLICATIONTYPE, REPLICATIONGLOBAL);
                replicationColFams.add(replicationEntry);
            });
        });
        return replicationColFams;
    }

    @Deprecated
    public void enableTableRep(TableName tableName) throws IOException {
        this.admin.enableTableReplication(tableName);
    }

    @Deprecated
    public void disableTableRep(TableName tableName) throws IOException {
        this.admin.disableTableReplication(tableName);
    }

    @InterfaceAudience.Private
    @Deprecated
    List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return this.admin.listReplicationPeers();
    }
}

