/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class StoreEngine<SF extends StoreFlusher, CP extends CompactionPolicy, C extends Compactor, SFM extends StoreFileManager> {
    protected SF storeFlusher;
    protected CP compactionPolicy;
    protected C compactor;
    protected SFM storeFileManager;
    public static final String STORE_ENGINE_CLASS_KEY = "hbase.hstore.engine.class";
    private static final Class<? extends StoreEngine<?, ?, ?, ?>> DEFAULT_STORE_ENGINE_CLASS = DefaultStoreEngine.class;

    public CompactionPolicy getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public Compactor getCompactor() {
        return this.compactor;
    }

    public StoreFileManager getStoreFileManager() {
        return this.storeFileManager;
    }

    public StoreFlusher getStoreFlusher() {
        return this.storeFlusher;
    }

    public abstract boolean needsCompaction(List<HStoreFile> var1);

    public abstract CompactionContext createCompaction() throws IOException;

    protected abstract void createComponents(Configuration var1, HStore var2, CellComparator var3) throws IOException;

    private void createComponentsOnce(Configuration conf, HStore store, CellComparator cellComparator) throws IOException {
        assert (this.compactor == null && this.compactionPolicy == null && this.storeFileManager == null && this.storeFlusher == null);
        this.createComponents(conf, store, cellComparator);
        assert (this.compactor != null && this.compactionPolicy != null && this.storeFileManager != null && this.storeFlusher != null);
    }

    public static StoreEngine<?, ?, ?, ?> create(HStore store, Configuration conf, CellComparator cellComparator) throws IOException {
        String className = conf.get(STORE_ENGINE_CLASS_KEY, DEFAULT_STORE_ENGINE_CLASS.getName());
        try {
            StoreEngine se = (StoreEngine)ReflectionUtils.instantiateWithCustomCtor(className, new Class[0], new Object[0]);
            se.createComponentsOnce(conf, store, cellComparator);
            return se;
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured store engine '" + className + "'", e);
        }
    }
}

