/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.backup.example.HFileArchiveManager;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKTableArchiveClient
extends Configured {
    private static final String ZOOKEEPER_ZNODE_HFILE_ARCHIVE_KEY = "zookeeper.znode.hfile.archive";
    private ClusterConnection connection;

    public ZKTableArchiveClient(Configuration conf, ClusterConnection connection) {
        super(conf);
        this.connection = connection;
    }

    public void enableHFileBackupAsync(byte[] table) throws IOException, KeeperException {
        this.createHFileArchiveManager().enableHFileBackup(table).stop();
    }

    public void disableHFileBackup(String table) throws IOException, KeeperException {
        this.disableHFileBackup(Bytes.toBytes(table));
    }

    public void disableHFileBackup(byte[] table) throws IOException, KeeperException {
        this.createHFileArchiveManager().disableHFileBackup(table).stop();
    }

    public void disableHFileBackup() throws IOException, KeeperException {
        this.createHFileArchiveManager().disableHFileBackup().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getArchivingEnabled(byte[] table) throws IOException, KeeperException {
        HFileArchiveManager manager = this.createHFileArchiveManager();
        try {
            boolean bl = manager.isArchivingEnabled(table);
            return bl;
        }
        finally {
            manager.stop();
        }
    }

    public boolean getArchivingEnabled(String table) throws IOException, KeeperException {
        return this.getArchivingEnabled(Bytes.toBytes(table));
    }

    private synchronized HFileArchiveManager createHFileArchiveManager() throws KeeperException, IOException {
        return new HFileArchiveManager(this.connection, this.getConf());
    }

    public static String getArchiveZNode(Configuration conf, ZKWatcher zooKeeper) {
        return ZNodePaths.joinZNode(zooKeeper.getZNodePaths().baseZNode, conf.get(ZOOKEEPER_ZNODE_HFILE_ARCHIVE_KEY, "hfilearchive"));
    }
}

