/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReadPointCalculationLock {
    private final boolean useReadWriteLockForReadPoints;
    private Lock lock;
    private ReadWriteLock readWriteLock;

    ReadPointCalculationLock(Configuration conf) {
        this.useReadWriteLockForReadPoints = conf.getBoolean("hbase.region.readpoints.read.write.lock.enable", false);
        if (this.useReadWriteLockForReadPoints) {
            this.readWriteLock = new ReentrantReadWriteLock();
        } else {
            this.lock = new ReentrantLock();
        }
    }

    void lock(LockType lockType) {
        if (this.useReadWriteLockForReadPoints) {
            assert (this.lock == null);
            if (lockType == LockType.CALCULATION_LOCK) {
                this.readWriteLock.writeLock().lock();
            } else {
                this.readWriteLock.readLock().lock();
            }
        } else {
            assert (this.readWriteLock == null);
            this.lock.lock();
        }
    }

    void unlock(LockType lockType) {
        if (this.useReadWriteLockForReadPoints) {
            assert (this.lock == null);
            if (lockType == LockType.CALCULATION_LOCK) {
                this.readWriteLock.writeLock().unlock();
            } else {
                this.readWriteLock.readLock().unlock();
            }
        } else {
            assert (this.readWriteLock == null);
            this.lock.unlock();
        }
    }

    public static enum LockType {
        CALCULATION_LOCK,
        RECORDING_LOCK;

    }
}

