/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.jcodings.IntHolder;
import org.apache.hadoop.hbase.shaded.org.joni.Matcher;
import org.apache.hadoop.hbase.shaded.org.joni.Regex;

final class Search {
    static final Forward SLOW_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; s2 += enc.length(text, s2, textEnd)) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            int n = s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            byte[] buf = matcher.icbuf();
            for (int s2 = textP; s2 < end; s2 += enc.length(text, s2, textEnd)) {
                if (!Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            byte[] buf = matcher.icbuf();
            while (s2 >= textP) {
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (target[targetP] != toLowerTable[text[s2] & 0xFF]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (target[targetP] == toLowerTable[text[s2] & 0xFF]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    static final Forward BM_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int tlen1 = tail - targetP;
            int end = textRange + tlen1;
            int s2 = textP + tlen1;
            if (end > textEnd) {
                end = textEnd;
            }
            while (s2 < end) {
                int p = s2;
                int t = tail;
                while (text[p] == target[t]) {
                    if (t == targetP) {
                        return p;
                    }
                    --p;
                    --t;
                }
                if (s2 + 1 >= end) break;
                s2 += regex.map[text[s2 + 1] & 0xFF];
            }
            return -1;
        }
    };
    static final Backward BM_BACKWARD = new Backward(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return SLOW_BACKWARD.search(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes, int p, int end) {
            int i;
            int[] skip;
            if (regex.intMapBackward == null) {
                regex.intMapBackward = skip = new int[256];
            } else {
                skip = regex.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < 256; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[bytes[i] & 0xFF] = i;
            }
        }
    };
    static final Forward BM_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int tlen1 = tail - targetP;
            int end = textRange + tlen1;
            int s2 = textP + tlen1;
            if (end > textEnd) {
                end = textEnd;
            }
            while (s2 < end) {
                int p = s2 - tlen1;
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, p, s2 + 1, enc, buf, regex.caseFoldFlag)) {
                    return p;
                }
                if (s2 + 1 >= end) break;
                s2 += regex.map[text[s2 + 1] & 0xFF];
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s2 = textP;
            while (s2 < end) {
                int se;
                int p = se = s2 + tlen1;
                int t = tail;
                while (text[p] == target[t]) {
                    if (t == targetP) {
                        return s2;
                    }
                    --p;
                    --t;
                }
                if (s2 + 1 >= end) break;
                byte skip = regex.map[text[se + 1] & 0xFF];
                t = s2;
                while ((s2 += enc.length(text, s2, textEnd)) - t < skip && s2 < end) {
                }
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex.exact;
            int end = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s2 = textP;
            while (s2 < end) {
                int se = s2 + tlen1;
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, se + 1, enc, buf, regex.caseFoldFlag)) {
                    return s2;
                }
                if (s2 + 1 >= end) break;
                byte skip = regex.map[text[se + 1] & 0xFF];
                int t = s2;
                while ((s2 += enc.length(text, s2, textEnd)) - t < skip && s2 < end) {
                }
            }
            return -1;
        }
    };
    static final Forward MAP_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; s2 += enc.length(text, s2, textEnd)) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward MAP_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward MAP_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward MAP_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    Search() {
    }

    private static boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes, int p, int end, Encoding enc, byte[] buf, int caseFoldFlag) {
        IntHolder holder = new IntHolder();
        holder.value = p;
        while (tP < tEnd) {
            int lowlen = enc.mbcCaseFold(caseFoldFlag, bytes, holder, end, buf);
            if (lowlen == 1) {
                if (t[tP++] == buf[0]) continue;
                return false;
            }
            int q = 0;
            while (lowlen > 0) {
                if (t[tP++] != buf[q++]) {
                    return false;
                }
                --lowlen;
            }
        }
        return true;
    }

    static abstract class Backward {
        Backward() {
        }

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }

    static abstract class Forward {
        Forward() {
        }

        abstract String getName();

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5);
    }
}

