/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.spark.FamilyHFileWriteOptions;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.spark.KeyFamilyQualifier;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public final class JavaHBaseBulkLoadExample {
    private JavaHBaseBulkLoadExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("JavaHBaseBulkLoadExample  {outputPath}");
            return;
        }
        String tableName = "bulkload-table-test";
        String columnFamily1 = "f1";
        String columnFamily2 = "f2";
        SparkConf sparkConf = new SparkConf().setAppName("JavaHBaseBulkLoadExample " + tableName);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1," + columnFamily1 + ",b,1");
            list.add("3," + columnFamily1 + ",a,2");
            list.add("3," + columnFamily1 + ",b,1");
            list.add("3," + columnFamily2 + ",a,1");
            list.add("2," + columnFamily2 + ",a,3");
            list.add("2," + columnFamily2 + ",b,3");
            JavaRDD rdd = jsc.parallelize(list);
            Configuration conf = HBaseConfiguration.create();
            JavaHBaseContext hbaseContext = new JavaHBaseContext(jsc, conf);
            hbaseContext.bulkLoad(rdd, TableName.valueOf((String)tableName), new BulkLoadFunction(), args[0], new HashMap<byte[], FamilyHFileWriteOptions>(), false, 0x280000000L);
        }
        finally {
            jsc.stop();
        }
    }

    public static class BulkLoadFunction
    implements Function<String, Pair<KeyFamilyQualifier, byte[]>> {
        public Pair<KeyFamilyQualifier, byte[]> call(String v1) throws Exception {
            if (v1 == null) {
                return null;
            }
            String[] strs = v1.split(",");
            if (strs.length != 4) {
                return null;
            }
            KeyFamilyQualifier kfq = new KeyFamilyQualifier(Bytes.toBytes((String)strs[0]), Bytes.toBytes((String)strs[1]), Bytes.toBytes((String)strs[2]));
            return new Pair((Object)kfq, (Object)Bytes.toBytes((String)strs[3]));
        }
    }
}

