/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasources.hbase;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hbase.spark.AvroSerdes$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.execution.SparkSqlSerializer$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Object hbaseFieldToScalaType(Field f, byte[] src, int offset, int length2) {
        Object object;
        if (f.exeSchema().isDefined()) {
            GenericRecord m = AvroSerdes$.MODULE$.deserialize(src, (Schema)f.exeSchema().get());
            Option n = f.avroToCatalyst().map((Function1)new Serializable(m){
                public static final long serialVersionUID = 0L;
                private final GenericRecord m$1;

                public final Object apply(Function1<Object, Object> x$1) {
                    return x$1.apply((Object)this.m$1);
                }
                {
                    this.m$1 = m$1;
                }
            });
            object = n.get();
        } else {
            Object object2;
            DataType dataType = f.dt();
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            DataType dataType2 = dataType;
            if (!(booleanType$ != null ? !booleanType$.equals(dataType2) : dataType2 != null)) {
                object2 = BoxesRunTime.boxToBoolean((boolean)this.toBoolean(src, offset));
            } else {
                ByteType$ byteType$ = ByteType$.MODULE$;
                DataType dataType3 = dataType;
                if (!(byteType$ != null ? !byteType$.equals(dataType3) : dataType3 != null)) {
                    object2 = BoxesRunTime.boxToByte((byte)src[offset]);
                } else {
                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    DataType dataType4 = dataType;
                    if (!(doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null)) {
                        object2 = BoxesRunTime.boxToDouble((double)Bytes.toDouble((byte[])src, (int)offset));
                    } else {
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        DataType dataType5 = dataType;
                        if (!(floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null)) {
                            object2 = BoxesRunTime.boxToFloat((float)Bytes.toFloat((byte[])src, (int)offset));
                        } else {
                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                            DataType dataType6 = dataType;
                            if (!(integerType$ != null ? !integerType$.equals(dataType6) : dataType6 != null)) {
                                object2 = BoxesRunTime.boxToInteger((int)Bytes.toInt((byte[])src, (int)offset));
                            } else {
                                boolean bl;
                                LongType$ longType$ = LongType$.MODULE$;
                                DataType dataType7 = dataType;
                                if (!(longType$ != null ? !longType$.equals(dataType7) : dataType7 != null)) {
                                    bl = true;
                                } else {
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType8 = dataType;
                                    bl = !(timestampType$ != null ? !timestampType$.equals(dataType8) : dataType8 != null);
                                }
                                if (bl) {
                                    object2 = BoxesRunTime.boxToLong((long)Bytes.toLong((byte[])src, (int)offset));
                                } else {
                                    ShortType$ shortType$ = ShortType$.MODULE$;
                                    DataType dataType9 = dataType;
                                    if (!(shortType$ != null ? !shortType$.equals(dataType9) : dataType9 != null)) {
                                        object2 = BoxesRunTime.boxToShort((short)Bytes.toShort((byte[])src, (int)offset));
                                    } else {
                                        StringType$ stringType$ = StringType$.MODULE$;
                                        DataType dataType10 = dataType;
                                        if (!(stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null)) {
                                            object2 = this.toUTF8String(src, offset, length2);
                                        } else {
                                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                            DataType dataType11 = dataType;
                                            if (!(binaryType$ != null ? !binaryType$.equals(dataType11) : dataType11 != null)) {
                                                byte[] newArray = new byte[length2];
                                                System.arraycopy(src, offset, newArray, 0, length2);
                                                object2 = newArray;
                                            } else {
                                                object2 = SparkSqlSerializer$.MODULE$.deserialize(src, ClassTag$.MODULE$.Any());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            object = object2;
        }
        return object;
    }

    public byte[] toBytes(Object input, Field field) {
        block14: {
            byte[] byArray;
            block3: {
                byte[] byArray2;
                block5: {
                    Object object;
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block4: {
                                                        block2: {
                                                            if (!field.schema().isDefined()) break block2;
                                                            Object record = field.catalystToAvro().apply(input);
                                                            byArray = AvroSerdes$.MODULE$.serialize(record, (Schema)field.schema().get());
                                                            break block3;
                                                        }
                                                        object = input;
                                                        if (!(object instanceof Boolean)) break block4;
                                                        boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                                        byArray2 = Bytes.toBytes((boolean)bl);
                                                        break block5;
                                                    }
                                                    if (!(object instanceof Byte)) break block6;
                                                    byte by = BoxesRunTime.unboxToByte((Object)object);
                                                    byArray2 = new byte[]{by};
                                                    break block5;
                                                }
                                                if (!(object instanceof byte[])) break block7;
                                                byte[] byArray3 = (byte[])object;
                                                byArray2 = byArray3;
                                                break block5;
                                            }
                                            if (!(object instanceof Double)) break block8;
                                            double d = BoxesRunTime.unboxToDouble((Object)object);
                                            byArray2 = Bytes.toBytes((double)d);
                                            break block5;
                                        }
                                        if (!(object instanceof Float)) break block9;
                                        float f = BoxesRunTime.unboxToFloat((Object)object);
                                        byArray2 = Bytes.toBytes((float)f);
                                        break block5;
                                    }
                                    if (!(object instanceof Integer)) break block10;
                                    int n = BoxesRunTime.unboxToInt((Object)object);
                                    byArray2 = Bytes.toBytes((int)n);
                                    break block5;
                                }
                                if (!(object instanceof Long)) break block11;
                                long l = BoxesRunTime.unboxToLong((Object)object);
                                byArray2 = Bytes.toBytes((long)l);
                                break block5;
                            }
                            if (!(object instanceof Short)) break block12;
                            short s = BoxesRunTime.unboxToShort((Object)object);
                            byArray2 = Bytes.toBytes((short)s);
                            break block5;
                        }
                        if (!(object instanceof UTF8String)) break block13;
                        UTF8String uTF8String = (UTF8String)object;
                        byArray2 = uTF8String.getBytes();
                        break block5;
                    }
                    if (!(object instanceof String)) break block14;
                    String string = (String)object;
                    byArray2 = Bytes.toBytes((String)string);
                }
                byArray = byArray2;
            }
            return byArray;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.dt()})));
    }

    public boolean toBoolean(byte[] input, int offset) {
        return input[offset] != 0;
    }

    public UTF8String toUTF8String(byte[] input, int offset, int length2) {
        return UTF8String.fromBytes((byte[])((byte[])Predef$.MODULE$.byteArrayOps(input).slice(offset, offset + length2)));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

