/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hive.hbase.HBaseTableSnapshotInputFormatUtil;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class HBaseSplit
extends FileSplit
implements InputSplit {
    private final TableSplit tableSplit;
    private final InputSplit snapshotSplit;
    private boolean isTableSplit;

    public HBaseSplit() {
        super((Path)null, 0L, 0L, (String[])null);
        this.tableSplit = new TableSplit();
        this.snapshotSplit = HBaseTableSnapshotInputFormatUtil.createTableSnapshotRegionSplit();
    }

    public HBaseSplit(TableSplit tableSplit, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.tableSplit = tableSplit;
        this.snapshotSplit = HBaseTableSnapshotInputFormatUtil.createTableSnapshotRegionSplit();
        this.isTableSplit = true;
    }

    public HBaseSplit(InputSplit snapshotSplit, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.tableSplit = new TableSplit();
        this.snapshotSplit = snapshotSplit;
        this.isTableSplit = false;
    }

    public TableSplit getTableSplit() {
        assert (this.isTableSplit);
        return this.tableSplit;
    }

    public InputSplit getSnapshotSplit() {
        assert (!this.isTableSplit);
        return this.snapshotSplit;
    }

    public String toString() {
        return "" + (this.isTableSplit ? this.tableSplit : this.snapshotSplit);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.isTableSplit = in.readBoolean();
        if (this.isTableSplit) {
            this.tableSplit.readFields(in);
        } else {
            this.snapshotSplit.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.isTableSplit);
        if (this.isTableSplit) {
            this.tableSplit.write(out);
        } else {
            this.snapshotSplit.write(out);
        }
    }

    public long getLength() {
        long val = 0L;
        try {
            val = this.isTableSplit ? this.tableSplit.getLength() : this.snapshotSplit.getLength();
            return val;
        }
        finally {
            return val;
        }
    }

    public String[] getLocations() throws IOException {
        return this.isTableSplit ? this.tableSplit.getLocations() : this.snapshotSplit.getLocations();
    }
}

