/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.beeline.BeeLine;

public class QFileClient {
    private String username;
    private String password;
    private String jdbcUrl;
    private String jdbcDriver;
    private final File hiveRootDirectory;
    private File qFileDirectory;
    private File outputDirectory;
    private File expectedDirectory;
    private final File scratchDirectory;
    private final File warehouseDirectory;
    private File testDataDirectory;
    private File testScriptDirectory;
    private String qFileName;
    private String testname;
    private File qFile;
    private File outputFile;
    private File expectedFile;
    private PrintStream beelineOutputStream;
    private BeeLine beeLine;
    private RegexFilterSet filterSet;
    private boolean hasErrors = false;
    private static Log LOG = LogFactory.getLog((String)QFileClient.class.getName());

    public QFileClient(HiveConf hiveConf, String hiveRootDirectory, String qFileDirectory, String outputDirectory, String expectedDirectory) {
        this.hiveRootDirectory = new File(hiveRootDirectory);
        this.qFileDirectory = new File(qFileDirectory);
        this.outputDirectory = new File(outputDirectory);
        this.expectedDirectory = new File(expectedDirectory);
        this.scratchDirectory = new File(hiveConf.getVar(HiveConf.ConfVars.SCRATCHDIR));
        this.warehouseDirectory = new File(hiveConf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE));
    }

    void initFilterSet() {
        String currentTimePrefix = Long.toString(System.currentTimeMillis()).substring(0, 4);
        String userName = System.getProperty("user.name");
        String timePattern = "(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{2} \\d{2}:\\d{2}:\\d{2} \\w+ 20\\d{2}";
        String unixTimePattern = "\\D" + currentTimePrefix + "\\d{6}\\D";
        String unixTimeMillisPattern = "\\D" + currentTimePrefix + "\\d{9}\\D";
        String operatorPattern = "\"(CONDITION|COPY|DEPENDENCY_COLLECTION|DDL|EXPLAIN|FETCH|FIL|FS|FUNCTION|GBY|HASHTABLEDUMMY|HASTTABLESINK|JOIN|LATERALVIEWFORWARD|LIM|LVJ|MAP|MAPJOIN|MAPRED|MAPREDLOCAL|MOVE|OP|RS|SCR|SEL|STATS|TS|UDTF|UNION)_\\d+\"";
        this.filterSet = new RegexFilterSet().addFilter(this.scratchDirectory.toString() + "[\\w\\-/]+", "!!{hive.exec.scratchdir}!!").addFilter(this.warehouseDirectory.toString(), "!!{hive.metastore.warehouse.dir}!!").addFilter(this.expectedDirectory.toString(), "!!{expectedDirectory}!!").addFilter(this.outputDirectory.toString(), "!!{outputDirectory}!!").addFilter(this.qFileDirectory.toString(), "!!{qFileDirectory}!!").addFilter(this.hiveRootDirectory.toString(), "!!{hive.root}!!").addFilter("file:/\\w\\S+", "file:/!!ELIDED!!").addFilter("pfile:/\\w\\S+", "pfile:/!!ELIDED!!").addFilter("hdfs:/\\w\\S+", "hdfs:/!!ELIDED!!").addFilter("last_modified_by=\\w+", "last_modified_by=!!ELIDED!!").addFilter(timePattern, "!!TIMESTAMP!!").addFilter("(\\D)" + currentTimePrefix + "\\d{6}(\\D)", "$1!!UNIXTIME!!$2").addFilter("(\\D)" + currentTimePrefix + "\\d{9}(\\D)", "$1!!UNIXTIMEMILLIS!!$2").addFilter(userName, "!!{user.name}!!").addFilter(operatorPattern, "\"$1_!!ELIDED!!\"");
    }

    public QFileClient setUsername(String username) {
        this.username = username;
        return this;
    }

    public QFileClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public QFileClient setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public QFileClient setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public QFileClient setQFileName(String qFileName) {
        this.qFileName = qFileName;
        this.qFile = new File(this.qFileDirectory, qFileName);
        this.testname = StringUtils.substringBefore((String)qFileName, (String)".");
        this.expectedFile = new File(this.expectedDirectory, qFileName + ".out");
        this.outputFile = new File(this.outputDirectory, qFileName + ".out");
        return this;
    }

    public QFileClient setQFileDirectory(String qFileDirectory) {
        this.qFileDirectory = new File(qFileDirectory);
        return this;
    }

    public QFileClient setOutputDirectory(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
        return this;
    }

    public QFileClient setExpectedDirectory(String expectedDirectory) {
        this.expectedDirectory = new File(expectedDirectory);
        return this;
    }

    public QFileClient setTestDataDirectory(String testDataDirectory) {
        this.testDataDirectory = new File(testDataDirectory);
        return this;
    }

    public QFileClient setTestScriptDirectory(String testScriptDirectory) {
        this.testScriptDirectory = new File(testScriptDirectory);
        return this;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void initBeeLine() throws Exception {
        this.beeLine = new BeeLine();
        this.beelineOutputStream = new PrintStream(new File(this.outputDirectory, this.qFileName + ".beeline"));
        this.beeLine.setOutputStream(this.beelineOutputStream);
        this.beeLine.setErrorStream(this.beelineOutputStream);
        this.beeLine.runCommands(new String[]{"!set verbose true", "!set shownestederrs true", "!set showwarnings true", "!set showelapsedtime false", "!set maxwidth -1", "!connect " + this.jdbcUrl + " " + this.username + " " + this.password + " " + this.jdbcDriver});
    }

    private void setUp() {
        this.beeLine.runCommands(new String[]{"USE default;", "SHOW TABLES;", "DROP DATABASE IF EXISTS `" + this.testname + "` CASCADE;", "CREATE DATABASE `" + this.testname + "`;", "USE `" + this.testname + "`;", "set test.data.dir=" + this.testDataDirectory + ";", "set test.script.dir=" + this.testScriptDirectory + ";", "!run " + this.testScriptDirectory + "/q_test_init.sql"});
    }

    private void tearDown() {
        this.beeLine.runCommands(new String[]{"!set outputformat table", "USE default;", "DROP DATABASE IF EXISTS `" + this.testname + "` CASCADE;"});
    }

    private void runQFileTest() throws Exception {
        this.hasErrors = false;
        this.beeLine.runCommands(new String[]{"!set outputformat csv", "!record " + this.outputDirectory + "/" + this.qFileName + ".raw"});
        if (1 != this.beeLine.runCommands(new String[]{"!run " + this.qFileDirectory + "/" + this.qFileName})) {
            this.hasErrors = true;
        }
        this.beeLine.runCommands(new String[]{"!record"});
    }

    private void filterResults() throws IOException {
        this.initFilterSet();
        String rawOutput = FileUtils.readFileToString((File)new File(this.outputDirectory, this.qFileName + ".raw"));
        FileUtils.writeStringToFile((File)this.outputFile, (String)this.filterSet.filter(rawOutput));
    }

    public void cleanup() {
        if (this.beeLine != null) {
            this.beeLine.runCommands(new String[]{"!quit"});
        }
        if (this.beelineOutputStream != null) {
            this.beelineOutputStream.close();
        }
        if (this.hasErrors) {
            String oldFileName = this.outputDirectory + "/" + this.qFileName + ".raw";
            String newFileName = oldFileName + ".error";
            try {
                FileUtils.moveFile((File)new File(oldFileName), (File)new File(newFileName));
            }
            catch (IOException e) {
                System.out.println("Failed to move '" + oldFileName + "' to '" + newFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            this.initBeeLine();
            this.setUp();
            this.runQFileTest();
            this.tearDown();
            this.filterResults();
        }
        finally {
            this.cleanup();
        }
    }

    public boolean hasExpectedResults() {
        return this.expectedFile.exists();
    }

    public boolean compareResults() throws IOException {
        if (!this.expectedFile.exists()) {
            LOG.error((Object)("Expected results file does not exist: " + this.expectedFile));
            return false;
        }
        return FileUtils.contentEquals((File)this.expectedFile, (File)this.outputFile);
    }

    public void overwriteResults() {
        try {
            if (this.expectedFile.exists()) {
                FileUtils.forceDelete((File)this.expectedFile);
            }
            FileUtils.copyFileToDirectory((File)this.outputFile, (File)this.expectedDirectory, (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to overwrite results!", (Throwable)e);
        }
    }

    private class RegexFilterSet {
        private final Map<Pattern, String> regexFilters = new LinkedHashMap<Pattern, String>();

        private RegexFilterSet() {
        }

        public RegexFilterSet addFilter(String regex, String replacement) {
            this.regexFilters.put(Pattern.compile(regex), replacement);
            return this;
        }

        public String filter(String input) {
            for (Pattern pattern : this.regexFilters.keySet()) {
                input = pattern.matcher(input).replaceAll(this.regexFilters.get(pattern));
            }
            return input;
        }
    }
}

