/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.File;
import java.net.URL;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final String HIVE_L4J = "hive-log4j2.properties";
    private static final String HIVE_EXEC_L4J = "hive-exec-log4j2.properties";
    private static final Logger l4j = LoggerFactory.getLogger(LogUtils.class);

    public static String initHiveLog4j() throws LogInitializationException {
        return LogUtils.initHiveLog4jCommon(HiveConf.ConfVars.HIVE_LOG4J_FILE);
    }

    public static String initHiveExecLog4j() throws LogInitializationException {
        return LogUtils.initHiveLog4jCommon(HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE);
    }

    private static String initHiveLog4jCommon(HiveConf.ConfVars confVarName) throws LogInitializationException {
        HiveConf conf = new HiveConf();
        if (HiveConf.getVar(conf, confVarName).equals("")) {
            return LogUtils.initHiveLog4jDefault(conf, "", confVarName);
        }
        String log4jFileName = HiveConf.getVar(conf, confVarName);
        File log4jConfigFile = new File(log4jFileName);
        boolean fileExists = log4jConfigFile.exists();
        if (!fileExists) {
            return LogUtils.initHiveLog4jDefault(conf, "Not able to find conf file: " + log4jConfigFile, confVarName);
        }
        if (confVarName == HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE) {
            String queryId = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEQUERYID);
            if (queryId == null || (queryId = queryId.trim()).isEmpty()) {
                queryId = "unknown-" + System.currentTimeMillis();
            }
            System.setProperty(HiveConf.ConfVars.HIVEQUERYID.toString(), queryId);
        }
        Configurator.initialize(null, (String)log4jFileName);
        LogUtils.logConfigLocation(conf);
        return "Logging initialized using configuration in " + log4jConfigFile;
    }

    private static String initHiveLog4jDefault(HiveConf conf, String logMessage, HiveConf.ConfVars confVarName) throws LogInitializationException {
        URL hive_l4j = null;
        switch (confVarName) {
            case HIVE_EXEC_LOG4J_FILE: {
                hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_EXEC_L4J);
                if (hive_l4j == null) {
                    hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_L4J);
                }
                System.setProperty(HiveConf.ConfVars.HIVEQUERYID.toString(), HiveConf.getVar(conf, HiveConf.ConfVars.HIVEQUERYID));
                break;
            }
            case HIVE_LOG4J_FILE: {
                hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_L4J);
                break;
            }
        }
        if (hive_l4j != null) {
            Configurator.initialize(null, (String)hive_l4j.toString());
            LogUtils.logConfigLocation(conf);
            return logMessage + "\n" + "Logging initialized using configuration in " + hive_l4j;
        }
        throw new LogInitializationException(logMessage + "Unable to initialize logging using " + HIVE_L4J + ", not found on CLASSPATH!");
    }

    private static void logConfigLocation(HiveConf conf) throws LogInitializationException {
        if (conf.getHiveDefaultLocation() != null) {
            l4j.warn("DEPRECATED: Ignoring hive-default.xml found on the CLASSPATH at " + conf.getHiveDefaultLocation().getPath());
        }
        if (conf.getHiveSiteLocation() == null) {
            l4j.warn("hive-site.xml not found on CLASSPATH");
        } else {
            l4j.debug("Using hive-site.xml found on CLASSPATH at " + conf.getHiveSiteLocation().getPath());
        }
    }

    public static class LogInitializationException
    extends Exception {
        public LogInitializationException(String msg) {
            super(msg);
        }
    }
}

