/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.ConcurrentRule;
import com.google.code.tempusfugit.concurrency.RepeatingRule;
import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveChar {
    @Rule
    public ConcurrentRule concurrentRule = new ConcurrentRule();
    @Rule
    public RepeatingRule repeatingRule = new RepeatingRule();

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testBasic() {
        HiveChar hc = new HiveChar("abc", 10);
        Assert.assertEquals((Object)"abc       ", (Object)hc.toString());
        Assert.assertEquals((Object)"abc       ", (Object)hc.getPaddedValue());
        Assert.assertEquals((Object)"abc", (Object)hc.getStrippedValue());
        Assert.assertEquals((long)3L, (long)hc.getCharacterLength());
        hc.setValue("abc123");
        Assert.assertEquals((Object)"abc123", (Object)hc.toString());
        Assert.assertEquals((Object)"abc123", (Object)hc.getPaddedValue());
        Assert.assertEquals((Object)"abc123", (Object)hc.getStrippedValue());
        Assert.assertEquals((long)6L, (long)hc.getCharacterLength());
        hc.setValue("xyz", 15);
        Assert.assertEquals((Object)"xyz            ", (Object)hc.toString());
        Assert.assertEquals((Object)"xyz            ", (Object)hc.getPaddedValue());
        Assert.assertEquals((Object)"xyz", (Object)hc.getStrippedValue());
        Assert.assertEquals((long)3L, (long)hc.getCharacterLength());
        hc.setValue("abc   ", 5);
        Assert.assertEquals((Object)"abc  ", (Object)hc.toString());
        Assert.assertEquals((Object)"abc", (Object)hc.getStrippedValue());
        Assert.assertEquals((long)3L, (long)hc.getCharacterLength());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testStringLength() {
        HiveChar hc = new HiveChar();
        hc.setValue("0123456789", 5);
        Assert.assertEquals((Object)"01234", (Object)hc.toString());
        hc.setValue("0123456789", 10);
        Assert.assertEquals((Object)"0123456789", (Object)hc.toString());
        hc.setValue("0123456789", 15);
        Assert.assertEquals((Object)"0123456789     ", (Object)hc.toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testComparison() {
        HiveChar hc1 = new HiveChar();
        HiveChar hc2 = new HiveChar();
        hc1.setValue("abc", 3);
        hc2.setValue("abc", 3);
        Assert.assertEquals((Object)hc1, (Object)hc2);
        Assert.assertEquals((Object)hc2, (Object)hc1);
        Assert.assertEquals((long)0L, (long)hc1.compareTo(hc2));
        Assert.assertEquals((long)0L, (long)hc2.compareTo(hc1));
        hc1.setValue("abc", 3);
        hc1.setValue("123", 3);
        Assert.assertFalse((boolean)hc1.equals((Object)hc2));
        Assert.assertFalse((boolean)hc2.equals((Object)hc1));
        Assert.assertFalse((0 == hc1.compareTo(hc2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == hc2.compareTo(hc1) ? 1 : 0) != 0);
        hc1.setValue("abc", 3);
        hc2.setValue("abc", 5);
        Assert.assertEquals((Object)"abc", (Object)hc1.toString());
        Assert.assertEquals((Object)"abc  ", (Object)hc2.toString());
        Assert.assertEquals((Object)hc1, (Object)hc2);
        Assert.assertEquals((Object)hc2, (Object)hc1);
        Assert.assertEquals((long)0L, (long)hc1.compareTo(hc2));
        Assert.assertEquals((long)0L, (long)hc2.compareTo(hc1));
        hc1.setValue(" abc", 4);
        hc2.setValue("abc", 4);
        Assert.assertFalse((boolean)hc1.equals((Object)hc2));
        Assert.assertFalse((boolean)hc2.equals((Object)hc1));
        Assert.assertFalse((0 == hc1.compareTo(hc2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == hc2.compareTo(hc1) ? 1 : 0) != 0);
    }
}

