/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.ConcurrentRule;
import com.google.code.tempusfugit.concurrency.RepeatingRule;
import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveIntervalYearMonth {
    @Rule
    public ConcurrentRule concurrentRule = new ConcurrentRule();
    @Rule
    public RepeatingRule repeatingRule = new RepeatingRule();

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testGetters() throws Exception {
        HiveIntervalYearMonth i1 = new HiveIntervalYearMonth(1, 2);
        Assert.assertEquals((long)1L, (long)i1.getYears());
        Assert.assertEquals((long)2L, (long)i1.getMonths());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testCompare() throws Exception {
        HiveIntervalYearMonth i1 = new HiveIntervalYearMonth(1, 2);
        HiveIntervalYearMonth i2 = new HiveIntervalYearMonth(1, 2);
        HiveIntervalYearMonth i3 = new HiveIntervalYearMonth(1, 3);
        Assert.assertEquals((String)(i1 + " compareTo " + i1), (long)0L, (long)i1.compareTo(i1));
        Assert.assertEquals((String)(i1 + " compareTo " + i2), (long)0L, (long)i1.compareTo(i2));
        Assert.assertEquals((String)(i2 + " compareTo " + i1), (long)0L, (long)i2.compareTo(i1));
        Assert.assertEquals((String)(i3 + " compareTo " + i3), (long)0L, (long)i3.compareTo(i3));
        Assert.assertTrue((String)(i1 + " compareTo " + i3), (0 > i1.compareTo(i3) ? 1 : 0) != 0);
        Assert.assertTrue((String)(i3 + " compareTo " + i1), (0 < i3.compareTo(i1) ? 1 : 0) != 0);
        Assert.assertTrue((String)(i1 + " equals " + i1), (boolean)i1.equals((Object)i1));
        Assert.assertTrue((String)(i1 + " equals " + i2), (boolean)i1.equals((Object)i2));
        Assert.assertFalse((String)(i1 + " equals " + i3), (boolean)i1.equals((Object)i3));
        Assert.assertFalse((String)(i3 + " equals " + i1), (boolean)i3.equals((Object)i1));
        Assert.assertEquals((String)(i1 + " hashCode " + i1), (long)i1.hashCode(), (long)i1.hashCode());
        Assert.assertEquals((String)(i1 + " hashCode " + i1), (long)i1.hashCode(), (long)i2.hashCode());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testValueOf() throws Exception {
        String[] invalidValues;
        HiveIntervalYearMonth i1 = HiveIntervalYearMonth.valueOf((String)"1-2");
        Assert.assertEquals((long)1L, (long)i1.getYears());
        Assert.assertEquals((long)2L, (long)i1.getMonths());
        HiveIntervalYearMonth i2 = HiveIntervalYearMonth.valueOf((String)"+8-9");
        Assert.assertEquals((long)8L, (long)i2.getYears());
        Assert.assertEquals((long)9L, (long)i2.getMonths());
        HiveIntervalYearMonth i3 = HiveIntervalYearMonth.valueOf((String)"-10-11");
        Assert.assertEquals((long)-10L, (long)i3.getYears());
        Assert.assertEquals((long)-11L, (long)i3.getMonths());
        HiveIntervalYearMonth i4 = HiveIntervalYearMonth.valueOf((String)"-0-0");
        Assert.assertEquals((long)0L, (long)i4.getYears());
        Assert.assertEquals((long)0L, (long)i4.getMonths());
        for (String invalidValue : invalidValues = new String[]{null, "abc", "0-12", "0 1:2:3"}) {
            boolean caughtException = false;
            try {
                HiveIntervalYearMonth.valueOf((String)invalidValue);
                Assert.fail((String)"Expected exception");
            }
            catch (IllegalArgumentException err) {
                caughtException = true;
            }
            Assert.assertTrue((String)"Expected exception", (boolean)caughtException);
        }
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"0-0", (Object)HiveIntervalYearMonth.valueOf((String)"0-0").toString());
        Assert.assertEquals((Object)"1-2", (Object)HiveIntervalYearMonth.valueOf((String)"1-2").toString());
        Assert.assertEquals((Object)"-1-2", (Object)HiveIntervalYearMonth.valueOf((String)"-1-2").toString());
        Assert.assertEquals((Object)"1-0", (Object)HiveIntervalYearMonth.valueOf((String)"1-0").toString());
        Assert.assertEquals((Object)"-1-0", (Object)HiveIntervalYearMonth.valueOf((String)"-1-0").toString());
        Assert.assertEquals((Object)"0-0", (Object)HiveIntervalYearMonth.valueOf((String)"-0-0").toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testNormalize() throws Exception {
        HiveIntervalYearMonth i1 = new HiveIntervalYearMonth(1, -6);
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"0-6"), (Object)i1);
        Assert.assertEquals((long)0L, (long)i1.getYears());
        Assert.assertEquals((long)6L, (long)i1.getMonths());
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"0-0"), (Object)new HiveIntervalYearMonth(0, 0));
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"0-0"), (Object)new HiveIntervalYearMonth(-1, 12));
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"0-4"), (Object)new HiveIntervalYearMonth(-1, 16));
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"0-11"), (Object)new HiveIntervalYearMonth(1, -1));
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"-0-11"), (Object)new HiveIntervalYearMonth(-1, 1));
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"5-1"), (Object)new HiveIntervalYearMonth(-5, 121));
    }
}

