/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import junit.framework.TestCase;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.SystemVariables;
import org.junit.Test;

public class TestSystemVariables {
    public static final String SYSTEM = "system";

    private String makeVarName(String prefix, String value) {
        return String.format("${%s:%s}", prefix, value);
    }

    @Test
    public void test_RelativeJavaIoTmpDir_CoercedTo_AbsolutePath() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "./relativePath");
        Path relativePath = new Path(localFileSystem.getWorkingDirectory(), "./relativePath");
        TestCase.assertEquals((String)relativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
        System.setProperty("java.io.tmpdir", "this/is/a/relative/path");
        Path thisIsARelativePath = new Path(localFileSystem.getWorkingDirectory(), "this/is/a/relative/path");
        TestCase.assertEquals((String)thisIsARelativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_AbsoluteJavaIoTmpDir_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "file:/this/is/an/absolute/path");
        Path absolutePath = new Path("file:/this/is/an/absolute/path");
        TestCase.assertEquals((String)absolutePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_RelativePathWithNoCoercion_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io._NOT_tmpdir");
        System.setProperty("java.io._NOT_tmpdir", "this/is/an/relative/path");
        Path relativePath = new Path("this/is/an/relative/path");
        TestCase.assertEquals((String)relativePath.toString(), (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }

    @Test
    public void test_EmptyJavaIoTmpDir_NotChanged() {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        String systemJavaIoTmpDir = this.makeVarName(SYSTEM, "java.io.tmpdir");
        System.setProperty("java.io.tmpdir", "");
        TestCase.assertEquals((String)"", (String)SystemVariables.substitute((String)systemJavaIoTmpDir));
    }
}

