/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.junit.Test;

public class TestVariableSubstitution {
    private static ThreadLocal<LocalMySource> localSource = new ThreadLocal<LocalMySource>(){

        @Override
        protected LocalMySource initialValue() {
            return new LocalMySource();
        }
    };

    private static LocalMySource getMySource() {
        return localSource.get();
    }

    @Test
    public void testVariableSource() throws InterruptedException {
        VariableSubstitution variableSubstitution = new VariableSubstitution(new HiveVariableSource(){

            public Map<String, String> getHiveVariable() {
                return TestVariableSubstitution.getMySource().map;
            }
        });
        String v = variableSubstitution.substitute(new HiveConf(), "${a}");
        Assert.assertEquals((String)"${a}", (String)v);
        TestVariableSubstitution.getMySource().put("a", "b");
        v = variableSubstitution.substitute(new HiveConf(), "${a}");
        Assert.assertEquals((String)"b", (String)v);
    }

    private static class LocalMySource {
        final Map<String, String> map = new HashMap<String, String>();

        private LocalMySource() {
        }

        public void put(String k, String v) {
            this.map.put(k, v);
        }

        public String get(String k) {
            return this.map.get(k);
        }
    }
}

