/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hive.common.util.ACLConfigurationParser;
import org.junit.Assert;
import org.junit.Test;

public class TestACLConfigurationParser {
    @Test(timeout=10000L)
    public void test() {
        Configuration conf = new Configuration();
        conf.set("ACL_ALL_ACCESS", "*");
        ACLConfigurationParser aclConf = new ACLConfigurationParser(conf, "ACL_ALL_ACCESS");
        Assert.assertEquals((long)1L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("*"));
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedGroups().size());
        Assert.assertEquals((Object)"*", (Object)aclConf.toAclString());
        conf.set("ACL_INVALID1", "u1, u2, u3");
        aclConf = new ACLConfigurationParser(conf, "ACL_INVALID1");
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedUsers().size());
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedGroups().size());
        Assert.assertEquals((Object)" ", (Object)aclConf.toAclString());
        conf.set("ACL_NONE", " ");
        aclConf = new ACLConfigurationParser(conf, "ACL_NONE");
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedUsers().size());
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedGroups().size());
        Assert.assertEquals((Object)" ", (Object)aclConf.toAclString());
        conf.set("ACL_VALID1", "user1,user2");
        aclConf = new ACLConfigurationParser(conf, "ACL_VALID1");
        Assert.assertEquals((long)2L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user1"));
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user2"));
        Assert.assertEquals((long)0L, (long)aclConf.getAllowedGroups().size());
        Assert.assertEquals((Object)"user1,user2", (Object)aclConf.toAclString());
        conf.set("ACL_VALID2", "user1,user2 group1,group2");
        aclConf = new ACLConfigurationParser(conf, "ACL_VALID2");
        Assert.assertEquals((long)2L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user1"));
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user2"));
        Assert.assertEquals((long)2L, (long)aclConf.getAllowedGroups().size());
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().contains("group1"));
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().contains("group2"));
        Assert.assertEquals((Object)"user1,user2 group1,group2", (Object)aclConf.toAclString());
        conf.set("ACL_VALID3", "user1 group1");
        aclConf = new ACLConfigurationParser(conf, "ACL_VALID3");
        Assert.assertEquals((long)1L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user1"));
        Assert.assertEquals((long)1L, (long)aclConf.getAllowedGroups().size());
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().contains("group1"));
        Assert.assertEquals((Object)"user1 group1", (Object)aclConf.toAclString());
        aclConf.addAllowedUser("user2");
        Assert.assertEquals((long)2L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user1"));
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("user2"));
        Assert.assertEquals((Object)"user1,user2 group1", (Object)aclConf.toAclString());
        aclConf.addAllowedGroup("group2");
        Assert.assertEquals((long)2L, (long)aclConf.getAllowedGroups().size());
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().contains("group1"));
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().contains("group2"));
        Assert.assertEquals((Object)"user1,user2 group1,group2", (Object)aclConf.toAclString());
        aclConf.addAllowedUser("*");
        Assert.assertEquals((long)1L, (long)aclConf.getAllowedUsers().size());
        Assert.assertTrue((boolean)aclConf.getAllowedUsers().contains("*"));
        Assert.assertTrue((boolean)aclConf.getAllowedGroups().isEmpty());
    }
}

