/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.rcfile.merge.BlockMergeTask;
import org.apache.hadoop.hive.ql.io.rcfile.merge.MergeWork;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PartitionSpec;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.DDLTask");
    transient HiveConf conf;
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;
    private MetaDataFormatter formatter;

    @Override
    public boolean requireLock() {
        return this.work != null && ((DDLWork)this.work).getNeedLock();
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        this.conf = conf;
        this.formatter = "json".equals(conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text")) ? new JsonMetaDataFormatter() : new TextMetaDataFormatter();
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            DescDatabaseDesc descDatabaseDesc = ((DDLWork)this.work).getDescDatabaseDesc();
            if (descDatabaseDesc != null) {
                return this.descDatabase(descDatabaseDesc);
            }
            AlterDatabaseDesc alterDatabaseDesc = ((DDLWork)this.work).getAlterDatabaseDesc();
            if (alterDatabaseDesc != null) {
                return this.alterDatabase(alterDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateIndexDesc crtIndex = ((DDLWork)this.work).getCreateIndexDesc();
            if (crtIndex != null) {
                return this.createIndex(db, crtIndex);
            }
            AlterIndexDesc alterIndex = ((DDLWork)this.work).getAlterIndexDesc();
            if (alterIndex != null) {
                return this.alterIndex(db, alterIndex);
            }
            DropIndexDesc dropIdx = ((DDLWork)this.work).getDropIdxDesc();
            if (dropIdx != null) {
                return this.dropIndex(db, dropIdx);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                return this.dropTable(db, dropTbl);
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartition(db, addPartitionDesc);
            }
            RenamePartitionDesc renamePartitionDesc = ((DDLWork)this.work).getRenamePartitionDesc();
            if (renamePartitionDesc != null) {
                return this.renamePartition(db, renamePartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            ShowColumnsDesc showCols = ((DDLWork)this.work).getShowColumnsDesc();
            if (showCols != null) {
                return this.showColumns(db, showCols);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowTblPropertiesDesc showTblProperties = ((DDLWork)this.work).getShowTblPropertiesDesc();
            if (showTblProperties != null) {
                return this.showTableProperties(db, showTblProperties);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            ShowLocksDesc showLocks = ((DDLWork)this.work).getShowLocksDesc();
            if (showLocks != null) {
                return this.showLocks(showLocks);
            }
            LockTableDesc lockTbl = ((DDLWork)this.work).getLockTblDesc();
            if (lockTbl != null) {
                return this.lockTable(lockTbl);
            }
            UnlockTableDesc unlockTbl = ((DDLWork)this.work).getUnlockTblDesc();
            if (unlockTbl != null) {
                return this.unlockTable(unlockTbl);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
            ShowCreateTableDesc showCreateTbl = ((DDLWork)this.work).getShowCreateTblDesc();
            if (showCreateTbl != null) {
                return this.showCreateTable(db, showCreateTbl);
            }
            RoleDDLDesc roleDDLDesc = ((DDLWork)this.work).getRoleDDLDesc();
            if (roleDDLDesc != null) {
                return this.roleDDL(roleDDLDesc);
            }
            GrantDesc grantDesc = ((DDLWork)this.work).getGrantDesc();
            if (grantDesc != null) {
                return this.grantOrRevokePrivileges(grantDesc.getPrincipals(), grantDesc.getPrivileges(), grantDesc.getPrivilegeSubjectDesc(), grantDesc.getGrantor(), grantDesc.getGrantorType(), grantDesc.isGrantOption(), true);
            }
            RevokeDesc revokeDesc = ((DDLWork)this.work).getRevokeDesc();
            if (revokeDesc != null) {
                return this.grantOrRevokePrivileges(revokeDesc.getPrincipals(), revokeDesc.getPrivileges(), revokeDesc.getPrivilegeSubjectDesc(), null, null, false, false);
            }
            ShowGrantDesc showGrantDesc = ((DDLWork)this.work).getShowGrantDesc();
            if (showGrantDesc != null) {
                return this.showGrants(showGrantDesc);
            }
            GrantRevokeRoleDDL grantOrRevokeRoleDDL = ((DDLWork)this.work).getGrantRevokeRoleDDL();
            if (grantOrRevokeRoleDDL != null) {
                return this.grantOrRevokeRole(grantOrRevokeRoleDDL);
            }
            ShowIndexesDesc showIndexes = ((DDLWork)this.work).getShowIndexesDesc();
            if (showIndexes != null) {
                return this.showIndexes(db, showIndexes);
            }
            AlterTablePartMergeFilesDesc mergeFilesDesc = ((DDLWork)this.work).getMergeFilesDesc();
            if (mergeFilesDesc != null) {
                return this.mergeFiles(db, mergeFilesDesc);
            }
        }
        catch (InvalidTableException e) {
            this.formatter.consoleError(this.console, "Table " + e.getTableName() + " does not exist", 404);
            LOG.debug((Object)StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (AlreadyExistsException e) {
            this.formatter.consoleError(this.console, e.getMessage(), 409);
            return 1;
        }
        catch (NoSuchObjectException e) {
            this.formatter.consoleError(this.console, e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e), 404);
            return 1;
        }
        catch (HiveException e) {
            this.formatter.consoleError(this.console, "FAILED: Error in metadata: " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e), 500);
            LOG.debug((Object)StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            this.formatter.consoleError(this.console, "Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e), 500);
            return 1;
        }
        assert (false);
        return 0;
    }

    private int mergeFiles(Hive db, AlterTablePartMergeFilesDesc mergeFilesDesc) throws HiveException {
        MergeWork mergeWork = new MergeWork(mergeFilesDesc.getInputDir(), mergeFilesDesc.getOutputDir());
        DriverContext driverCxt = new DriverContext();
        BlockMergeTask taskExec = new BlockMergeTask();
        taskExec.initialize(db.getConf(), null, driverCxt);
        taskExec.setWork(mergeWork);
        taskExec.setQueryPlan(this.getQueryPlan());
        int ret = taskExec.execute(driverCxt);
        return ret;
    }

    private int grantOrRevokeRole(GrantRevokeRoleDDL grantOrRevokeRoleDDL) throws HiveException {
        try {
            boolean grantRole = grantOrRevokeRoleDDL.getGrant();
            List<PrincipalDesc> principals = grantOrRevokeRoleDDL.getPrincipalDesc();
            List<String> roles = grantOrRevokeRoleDDL.getRoles();
            for (PrincipalDesc principal : principals) {
                String userName = principal.getName();
                for (String roleName : roles) {
                    if (grantRole) {
                        this.db.grantRole(roleName, userName, principal.getType(), grantOrRevokeRoleDDL.getGrantor(), grantOrRevokeRoleDDL.getGrantorType(), grantOrRevokeRoleDDL.isGrantOption());
                        continue;
                    }
                    this.db.revokeRole(roleName, userName, principal.getType());
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int showGrants(ShowGrantDesc showGrantDesc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int grantOrRevokePrivileges(List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectDesc, String grantor, PrincipalType grantorType, boolean grantOption, boolean isGrant) {
        if (privileges == null || privileges.size() == 0) {
            this.console.printError("No privilege found.");
            return 1;
        }
        String dbName = null;
        String tableName = null;
        Table tableObj = null;
        Database dbObj = null;
        try {
            if (privSubjectDesc != null) {
                if (privSubjectDesc.getPartSpec() != null && isGrant) {
                    throw new HiveException("Grant does not support partition level.");
                }
                String obj = privSubjectDesc.getObject();
                boolean notFound = true;
                if (privSubjectDesc.getTable()) {
                    String[] dbTab = obj.split("\\.");
                    if (dbTab.length == 2) {
                        dbName = dbTab[0];
                        tableName = dbTab[1];
                    } else {
                        dbName = this.db.getCurrentDatabase();
                        tableName = obj;
                    }
                    dbObj = this.db.getDatabase(dbName);
                    tableObj = this.db.getTable(dbName, tableName);
                    notFound = dbObj == null || tableObj == null;
                } else {
                    dbName = privSubjectDesc.getObject();
                    dbObj = this.db.getDatabase(dbName);
                    boolean bl = notFound = dbObj == null;
                }
                if (notFound) {
                    throw new HiveException(obj + " can not be found");
                }
            }
            PrivilegeBag privBag = new PrivilegeBag();
            if (privSubjectDesc == null) {
                for (int idx = 0; idx < privileges.size(); ++idx) {
                    Privilege priv = privileges.get(idx).getPrivilege();
                    if (privileges.get(idx).getColumns() != null && privileges.get(idx).getColumns().size() > 0) {
                        throw new HiveException("For user-level privileges, column sets should be null. columns=" + privileges.get(idx).getColumns().toString());
                    }
                    privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                }
            } else {
                org.apache.hadoop.hive.metastore.api.Partition partObj = null;
                List partValues = null;
                if (tableObj != null) {
                    if (!tableObj.isPartitioned() && privSubjectDesc.getPartSpec() != null) {
                        throw new HiveException("Table is not partitioned, but partition name is present: partSpec=" + privSubjectDesc.getPartSpec().toString());
                    }
                    if (privSubjectDesc.getPartSpec() != null) {
                        partObj = this.db.getPartition(tableObj, privSubjectDesc.getPartSpec(), false).getTPartition();
                        partValues = partObj.getValues();
                    }
                }
                for (PrivilegeDesc privDesc : privileges) {
                    List<String> columns = privDesc.getColumns();
                    Privilege priv = privDesc.getPrivilege();
                    if (columns != null && columns.size() > 0) {
                        if (!priv.supportColumnLevel()) {
                            throw new HiveException(priv.toString() + " does not support column level.");
                        }
                        if (privSubjectDesc == null || tableName == null) {
                            throw new HiveException("For user-level/database-level privileges, column sets should be null. columns=" + columns);
                        }
                        for (int i = 0; i < columns.size(); ++i) {
                            privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, partValues, columns.get(i)), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                        }
                        continue;
                    }
                    if (privSubjectDesc.getTable()) {
                        if (privSubjectDesc.getPartSpec() != null) {
                            privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                            continue;
                        }
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                        continue;
                    }
                    privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), null, null, new PrivilegeGrantInfo(priv.toString(), 0, grantor, grantorType, grantOption)));
                }
            }
            for (PrincipalDesc principal : principals) {
                for (int i = 0; i < privBag.getPrivileges().size(); ++i) {
                    HiveObjectPrivilege objPrivs = (HiveObjectPrivilege)privBag.getPrivileges().get(i);
                    objPrivs.setPrincipalName(principal.getName());
                    objPrivs.setPrincipalType(principal.getType());
                }
                if (isGrant) {
                    this.db.grantPrivileges(privBag);
                    continue;
                }
                this.db.revokePrivileges(privBag);
            }
        }
        catch (Exception e) {
            this.console.printError("Error: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int roleDDL(RoleDDLDesc roleDDLDesc) {
        block12: {
            RoleDDLDesc.RoleOperation operation = roleDDLDesc.getOperation();
            FSDataOutputStream outStream = null;
            try {
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.CREATE_ROLE)) {
                    this.db.createRole(roleDDLDesc.getName(), roleDDLDesc.getRoleOwnerName());
                    break block12;
                }
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.DROP_ROLE)) {
                    this.db.dropRole(roleDDLDesc.getName());
                    break block12;
                }
                if (operation.equals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT)) {
                    List<Role> roles = this.db.showRoleGrant(roleDDLDesc.getName(), roleDDLDesc.getPrincipalType());
                    if (roles != null && roles.size() > 0) {
                        Path resFile = new Path(roleDDLDesc.getResFile());
                        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                        outStream = fs.create(resFile);
                        for (Role role : roles) {
                            outStream.writeBytes("role name:" + role.getRoleName());
                            outStream.write(10);
                        }
                        outStream.close();
                        outStream = null;
                    }
                    break block12;
                }
                throw new HiveException("Unkown role operation " + operation.getOperationName());
            }
            catch (HiveException e) {
                this.console.printError("Error in role operation " + operation.getOperationName() + " on role name " + roleDDLDesc.getName() + ", error message " + e.getMessage());
                int n = 1;
                return n;
            }
            catch (IOException e) {
                LOG.info((Object)("role ddl exception: " + StringUtils.stringifyException((Throwable)e)));
                int n = 1;
                return n;
            }
            finally {
                IOUtils.closeStream((Closeable)outStream);
            }
        }
        return 0;
    }

    private int alterDatabase(AlterDatabaseDesc alterDbDesc) throws HiveException {
        String dbName = alterDbDesc.getDatabaseName();
        Database database = this.db.getDatabase(dbName);
        Map<String, String> newParams = alterDbDesc.getDatabaseProperties();
        if (database != null) {
            Map params = database.getParameters();
            if (params != null && newParams != null) {
                params.putAll(newParams);
                database.setParameters(params);
            } else {
                database.setParameters(newParams);
            }
        } else {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        this.db.alterDatabase(database.getName(), database);
        return 0;
    }

    private int dropIndex(Hive db, DropIndexDesc dropIdx) throws HiveException {
        db.dropIndex(db.getCurrentDatabase(), dropIdx.getTableName(), dropIdx.getIndexName(), true);
        return 0;
    }

    private int createIndex(Hive db, CreateIndexDesc crtIndex) throws HiveException {
        if (crtIndex.getSerde() != null) {
            this.validateSerDe(crtIndex.getSerde());
        }
        db.createIndex(crtIndex.getTableName(), crtIndex.getIndexName(), crtIndex.getIndexTypeHandlerClass(), crtIndex.getIndexedCols(), crtIndex.getIndexTableName(), crtIndex.getDeferredRebuild(), crtIndex.getInputFormat(), crtIndex.getOutputFormat(), crtIndex.getSerde(), crtIndex.getStorageHandler(), crtIndex.getLocation(), crtIndex.getIdxProps(), crtIndex.getTblProps(), crtIndex.getSerdeProps(), crtIndex.getCollItemDelim(), crtIndex.getFieldDelim(), crtIndex.getFieldEscape(), crtIndex.getLineDelim(), crtIndex.getMapKeyDelim(), crtIndex.getIndexComment());
        if (HiveUtils.getIndexHandler(this.conf, crtIndex.getIndexTypeHandlerClass()).usesIndexTable()) {
            String indexTableName = crtIndex.getIndexTableName() != null ? crtIndex.getIndexTableName() : MetaStoreUtils.getIndexTableName((String)db.getCurrentDatabase(), (String)crtIndex.getTableName(), (String)crtIndex.getIndexName());
            Table indexTable = db.getTable(indexTableName);
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(indexTable));
        }
        return 0;
    }

    private int alterIndex(Hive db, AlterIndexDesc alterIndex) throws HiveException {
        String dbName = alterIndex.getDbName();
        String baseTableName = alterIndex.getBaseTableName();
        String indexName = alterIndex.getIndexName();
        Index idx = db.getIndex(dbName, baseTableName, indexName);
        switch (alterIndex.getOp()) {
            case ADDPROPS: {
                idx.getParameters().putAll(alterIndex.getProps());
                break;
            }
            case UPDATETIMESTAMP: {
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    HashMap<LinkedHashMap<String, String>, Long> basePartTs = new HashMap<LinkedHashMap<String, String>, Long>();
                    Table baseTbl = db.getTable(db.getCurrentDatabase(), baseTableName);
                    if (baseTbl.isPartitioned()) {
                        List<Partition> baseParts = alterIndex.getSpec() != null ? db.getPartitions(baseTbl, alterIndex.getSpec()) : db.getPartitions(baseTbl);
                        if (baseParts != null) {
                            for (Partition p : baseParts) {
                                FileSystem fs = p.getPartitionPath().getFileSystem((Configuration)db.getConf());
                                FileStatus fss = fs.getFileStatus(p.getPartitionPath());
                                basePartTs.put(p.getSpec(), fss.getModificationTime());
                            }
                        }
                    } else {
                        FileSystem fs = baseTbl.getPath().getFileSystem((Configuration)db.getConf());
                        FileStatus fss = fs.getFileStatus(baseTbl.getPath());
                        basePartTs.put(null, fss.getModificationTime());
                    }
                    for (Map spec : basePartTs.keySet()) {
                        if (spec != null) {
                            props.put(spec.toString(), ((Long)basePartTs.get(spec)).toString());
                            continue;
                        }
                        props.put("base_timestamp", ((Long)basePartTs.get(null)).toString());
                    }
                    idx.getParameters().putAll(props);
                    break;
                }
                catch (HiveException e) {
                    throw new HiveException("ERROR: Failed to update index timestamps");
                }
                catch (IOException e) {
                    throw new HiveException("ERROR: Failed to look up timestamps on filesystem");
                }
            }
            default: {
                this.console.printError("Unsupported Alter commnad");
                return 1;
            }
        }
        if (!this.updateModifiedParameters(idx.getParameters(), this.conf)) {
            return 1;
        }
        try {
            db.alterIndex(dbName, baseTableName, indexName, idx);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter index: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int addPartition(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = db.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        Partition checkPart = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        if (checkPart != null && addPartitionDesc.getIfNotExists()) {
            return 0;
        }
        if (addPartitionDesc.getLocation() == null) {
            db.createPartition(tbl, addPartitionDesc.getPartSpec(), null, addPartitionDesc.getPartParams(), addPartitionDesc.getInputFormat(), addPartitionDesc.getOutputFormat(), addPartitionDesc.getNumBuckets(), addPartitionDesc.getCols(), addPartitionDesc.getSerializationLib(), addPartitionDesc.getSerdeParams(), addPartitionDesc.getBucketCols(), addPartitionDesc.getSortCols());
        } else {
            if (tbl.isView()) {
                throw new HiveException("LOCATION clause illegal for view partition");
            }
            db.createPartition(tbl, addPartitionDesc.getPartSpec(), new Path(tbl.getPath(), addPartitionDesc.getLocation()), addPartitionDesc.getPartParams(), addPartitionDesc.getInputFormat(), addPartitionDesc.getOutputFormat(), addPartitionDesc.getNumBuckets(), addPartitionDesc.getCols(), addPartitionDesc.getSerializationLib(), addPartitionDesc.getSerdeParams(), addPartitionDesc.getBucketCols(), addPartitionDesc.getSortCols());
        }
        Partition part = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        return 0;
    }

    private int renamePartition(Hive db, RenamePartitionDesc renamePartitionDesc) throws HiveException {
        Table tbl = db.getTable(renamePartitionDesc.getDbName(), renamePartitionDesc.getTableName());
        Partition oldPart = db.getPartition(tbl, renamePartitionDesc.getOldPartSpec(), false);
        Partition part = db.getPartition(tbl, renamePartitionDesc.getOldPartSpec(), false);
        part.setValues(renamePartitionDesc.getNewPartSpec());
        db.renamePartition(tbl, renamePartitionDesc.getOldPartSpec(), part);
        Partition newPart = db.getPartition(tbl, renamePartitionDesc.getNewPartSpec(), false);
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldPart));
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(newPart));
        return 0;
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        String dbName = touchDesc.getDbName();
        String tblName = touchDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        if (touchDesc.getPartSpec() == null) {
            try {
                db.alterTable(tblName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Uable to update table");
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(tblName, part);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        }
        return 0;
    }

    private void setIsArchived(Partition p, boolean state, int level) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
            params.put(ArchiveUtils.ARCHIVING_LEVEL, Integer.toString(level));
        } else {
            params.remove("is_archived");
            params.remove(ArchiveUtils.ARCHIVING_LEVEL);
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private void setArchived(Partition p, Path harPath, int level) {
        assert (!ArchiveUtils.isArchived(p));
        this.setIsArchived(p, true, level);
        this.setOriginalLocation(p, p.getLocation());
        p.setLocation(harPath.toString());
    }

    private void setUnArchived(Partition p) {
        assert (ArchiveUtils.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false, 0);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(Path p) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem((Configuration)this.conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir) throws HiveException {
        try {
            Warehouse wh = new Warehouse((Configuration)this.conf);
            wh.deleteDir(dir, true);
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    boolean partitionInCustomLocation(Table tbl, Partition p) throws HiveException {
        String subdir = null;
        try {
            subdir = Warehouse.makePartName(tbl.getPartCols(), p.getValues());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to get partition's directory", e);
        }
        URI tableDir = tbl.getDataLocation();
        if (tableDir == null) {
            throw new HiveException("Table has no location set");
        }
        String standardLocation = new Path(tableDir.toString(), subdir).toString();
        if (ArchiveUtils.isArchived(p)) {
            return !this.getOriginalLocation(p).equals(standardLocation);
        }
        return !p.getLocation().equals(standardLocation);
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        String tblName;
        String dbName = simpleDesc.getDbName();
        Table tbl = db.getTable(dbName, tblName = simpleDesc.getTableName());
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("ARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : p.getPartitionPath();
        }
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        this.console.printInfo("intermediate.archived is " + intermediateArchivedDir.toString());
        this.console.printInfo("intermediate.original is " + intermediateOriginalDir.toString());
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        URI archiveUri = new Path(originalDir, archiveName).toUri();
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        for (Partition p : partitions) {
            if (!ArchiveUtils.isArchived(p)) continue;
            if (ArchiveUtils.getArchivingLevel(p) != partSpecInfo.values.size()) {
                String name = ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
                String m = String.format("Conflict with existing archive %s", name);
                throw new HiveException(m);
            }
            throw new HiveException("Partition(s) already archived");
        }
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateOriginalDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed ARCHIVE");
        }
        HadoopShims shim = ShimLoader.getHadoopShims();
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(intermediateOriginalDir)) {
            Path tmpPath = new Path(driverContext.getCtx().getExternalTmpFileURI(originalDir.toUri()), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + tmpPath);
            this.console.printInfo("Please wait... (this may take a while)");
            int ret = 0;
            try {
                int maxJobNameLen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
                String jobname = String.format("Archiving %s@%s", tbl.getTableName(), partSpecInfo.getName());
                jobname = Utilities.abbreviate(jobname, maxJobNameLen - 6);
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname);
                ret = shim.createHadoopArchive(this.conf, originalDir, tmpPath, archiveName);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateArchivedDir);
                if (this.pathExists(intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpPath, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. " + "Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        try {
            for (Partition p : partitions) {
                URI originalPartitionUri = ArchiveUtils.addSlash(p.getPartitionPath().toUri());
                URI test = p.getPartitionPath().toUri();
                URI harPartitionDir = harHelper.getHarUri(originalPartitionUri, shim);
                Path harPath = new Path(harPartitionDir.getScheme(), harPartitionDir.getAuthority(), harPartitionDir.getPath());
                this.setArchived(p, harPath, partSpecInfo.values.size());
                db.alterPartition(tblName, p);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        if (this.pathExists(intermediateOriginalDir)) {
            this.deleteDir(intermediateOriginalDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after ARCHIVE succeeded");
        }
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException {
        String dbName = simpleDesc.getDbName();
        String tblName = simpleDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("UNARCHIVE is for partitions only");
        }
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        int partSpecLevel = partSpec.size();
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("UNARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : new Path(p.getLocation());
        }
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateExtractedDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed UNARCHIVE");
        }
        for (Partition p : partitions) {
            this.checkArchiveProperty(partSpecLevel, recovery, p);
        }
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        Path archivePath = new Path(originalDir, archiveName);
        URI archiveUri = archivePath.toUri();
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        HadoopShims shim = ShimLoader.getHadoopShims();
        URI sourceUri = harHelper.getHarUri(originalUri, shim);
        Path sourceDir = new Path(sourceUri.getScheme(), sourceUri.getAuthority(), sourceUri.getPath());
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(archivePath)) {
            throw new HiveException("Haven't found any archive where it should be");
        }
        Path tmpPath = new Path(this.driverContext.getCtx().getExternalTmpFileURI(originalDir.toUri()));
        try {
            fs = tmpPath.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (originalDir == null) {
            throw new HiveException("Missing archive data in the partition");
        }
        if (!this.pathExists(intermediateExtractedDir) && !this.pathExists(intermediateArchivedDir)) {
            try {
                String copySource = sourceDir.toString();
                String copyDest = tmpPath.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FileSystem srcFs = FileSystem.get((URI)sourceDir.toUri(), (Configuration)this.conf);
                srcFs.initialize(sourceDir.toUri(), (Configuration)this.conf);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive, return code=" + ret);
                }
                this.console.printInfo("Succefully Copied " + copySource + " to " + copyDest);
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpPath, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(intermediateArchivedDir)) {
            try {
                this.console.printInfo("Moving " + originalDir + " to " + intermediateArchivedDir);
                fs.rename(originalDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchivedDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(originalDir)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalDir);
                fs.rename(intermediateExtractedDir, originalDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the extracted files in the partition");
        }
        for (Partition p : partitions) {
            this.setUnArchived(p);
            try {
                db.alterPartition(tblName, p);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.deleteDir(intermediateArchivedDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after UNARCHIVE succeeded");
        }
        return 0;
    }

    private void checkArchiveProperty(int partSpecLevel, boolean recovery, Partition p) throws HiveException {
        if (!ArchiveUtils.isArchived(p) && !recovery) {
            throw new HiveException("Partition " + p.getName() + " is not archived.");
        }
        int archiveLevel = ArchiveUtils.getArchivingLevel(p);
        if (partSpecLevel > archiveLevel) {
            throw new HiveException("Partition " + p.getName() + " is archived at level " + archiveLevel + ", and given partspec only has " + partSpecLevel + " specs.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        CheckResult result = new CheckResult();
        ArrayList<String> repairOutput = new ArrayList<String>();
        try {
            HiveMetaStoreChecker checker = new HiveMetaStoreChecker(db);
            Table t = db.newTable(msckDesc.getTableName());
            checker.checkMetastore(t.getDbName(), t.getTableName(), msckDesc.getPartSpecs(), result);
            if (!msckDesc.isRepairPartitions()) return 0;
            Table table = db.getTable(msckDesc.getTableName());
            Iterator<CheckResult.PartitionResult> i$ = result.getPartitionsNotInMs().iterator();
            while (i$.hasNext()) {
                CheckResult.PartitionResult part = i$.next();
                try {
                    db.createPartition(table, Warehouse.makeSpecFromName((String)part.getPartitionName()));
                    repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Repair error, could not add partition to metastore: ", (Throwable)e);
                }
            }
            return 0;
        }
        catch (HiveException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            BufferedWriter resultOut = null;
            try {
                Path resFile = new Path(msckDesc.getResFile());
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to save metacheck output: ", (Throwable)e);
                int fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showCreateTable(Hive db, ShowCreateTableDesc showCreateTbl) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int showIndexes(Hive db, ShowIndexesDesc showIndexes) throws HiveException {
        String tableName = showIndexes.getTableName();
        Table tbl = null;
        List<Index> indexes = null;
        tbl = db.getTable(tableName);
        indexes = db.getIndexes(tbl.getDbName(), tbl.getTableName(), (short)-1);
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showIndexes.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            if (showIndexes.isFormatted()) {
                outStream.writeBytes(MetaDataFormatUtils.getIndexColumnsHeader());
                outStream.write(10);
                outStream.write(10);
            }
            for (Index index : indexes) {
                outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(index));
            }
            outStream.close();
            outStream = null;
        }
        catch (FileNotFoundException e) {
            try {
                LOG.info((Object)("show indexes: " + StringUtils.stringifyException((Throwable)e)));
                throw new HiveException(e.toString());
                catch (IOException e2) {
                    LOG.info((Object)("show indexes: " + StringUtils.stringifyException((Throwable)e2)));
                    throw new HiveException(e2.toString());
                }
                catch (Exception e3) {
                    throw new HiveException(e3.toString());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream((Closeable)outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showTables(Hive db, ShowTablesDesc showTbls) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showColumns(Hive db, ShowColumnsDesc showCols) throws HiveException {
        String dbName = showCols.getDbName();
        String tableName = showCols.getTableName();
        Table table = null;
        table = dbName == null ? db.getTable(tableName) : db.getTable(dbName, tableName);
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showCols.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            List<FieldSchema> cols = table.getCols();
            cols.addAll(table.getPartCols());
            outStream.writeBytes(MetaDataFormatUtils.displayColsUnformatted(cols));
            outStream.close();
            outStream = null;
        }
        catch (IOException e) {
            int n;
            try {
                LOG.warn((Object)("show columns: " + StringUtils.stringifyException((Throwable)e)));
                n = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream((Closeable)outStream);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)outStream);
            return n;
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int showFunctions(ShowFunctionsDesc showFuncs) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showLocks(ShowLocksDesc showLocks) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int lockTable(LockTableDesc lockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        if (lockMgr == null) {
            throw new HiveException("lock Table LockManager not specified");
        }
        HiveLockMode mode = HiveLockMode.valueOf(lockTbl.getMode());
        String tabName = lockTbl.getTableName();
        Table tbl = this.db.getTable("default", tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        Map<String, String> partSpec = lockTbl.getPartSpec();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockTbl.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT", lockTbl.getQueryStr());
        if (partSpec == null) {
            HiveLock lck = lockMgr.lock(new HiveLockObject(tbl, lockData), mode, true);
            if (lck == null) {
                return 1;
            }
            return 0;
        }
        Partition par = this.db.getPartition(tbl, partSpec, false);
        if (par == null) {
            throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
        }
        HiveLock lck = lockMgr.lock(new HiveLockObject(par, lockData), mode, true);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    private HiveLockObject getHiveObject(String tabName, Map<String, String> partSpec) throws HiveException {
        Table tbl = this.db.getTable(tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        HiveLockObject obj = null;
        if (partSpec == null) {
            obj = new HiveLockObject(tbl, null);
        } else {
            Partition par = this.db.getPartition(tbl, partSpec, false);
            if (par == null) {
                throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
            }
            obj = new HiveLockObject(par, null);
        }
        return obj;
    }

    private int unlockTable(UnlockTableDesc unlockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        if (lockMgr == null) {
            throw new HiveException("unlock Table LockManager not specified");
        }
        String tabName = unlockTbl.getTableName();
        HiveLockObject obj = this.getHiveObject(tabName, unlockTbl.getPartSpec());
        List<HiveLock> locks = lockMgr.getLocks(obj, false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Table " + tabName + " is not locked ");
        }
        for (HiveLock lock : locks) {
            lockMgr.unlock(lock);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int describeFunction(DescFunctionDesc descFunc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int descDatabase(DescDatabaseDesc descDatabase) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showTableProperties(Hive db, ShowTblPropertiesDesc showTblPrpt) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException {
        Path resFile;
        FSDataOutputStream outStream;
        Partition part;
        Table tbl;
        String tableName;
        String colPath;
        block21: {
            block22: {
                block20: {
                    colPath = descTbl.getColumnPath();
                    tableName = descTbl.getTableName();
                    tbl = db.getTable(tableName, false);
                    part = null;
                    outStream = null;
                    resFile = new Path(descTbl.getResFile());
                    if (tbl != null) break block20;
                    FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                    outStream = fs.create(resFile);
                    String errMsg = "Table " + tableName + " does not exist";
                    this.formatter.error((OutputStream)outStream, errMsg, 404);
                    outStream.close();
                    outStream = null;
                    int n = 0;
                    IOUtils.closeStream((Closeable)outStream);
                    return n;
                }
                if (descTbl.getPartSpec() == null) break block21;
                part = db.getPartition(tbl, descTbl.getPartSpec(), false);
                if (part != null) break block22;
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                outStream = fs.create(resFile);
                String errMsg = "Partition " + descTbl.getPartSpec() + " for table " + tableName + " does not exist";
                this.formatter.error((OutputStream)outStream, errMsg, 404);
                outStream.close();
                outStream = null;
                int n = 0;
                IOUtils.closeStream((Closeable)outStream);
                return n;
            }
            try {
                tbl = part.getTable();
            }
            catch (FileNotFoundException e) {
                this.formatter.logInfo((OutputStream)outStream, "describe table: " + StringUtils.stringifyException((Throwable)e), 500);
                int fs = 1;
                IOUtils.closeStream((Closeable)outStream);
                return fs;
            }
            catch (IOException e) {
                this.formatter.logInfo((OutputStream)outStream, "describe table: " + StringUtils.stringifyException((Throwable)e), 500);
                int fs = 1;
                {
                    catch (Throwable throwable) {
                        IOUtils.closeStream((Closeable)outStream);
                        throw throwable;
                    }
                }
                IOUtils.closeStream((Closeable)outStream);
                return fs;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        try {
            LOG.info((Object)("DDLTask: got data for " + tbl.getTableName()));
            resFile = new Path(descTbl.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            List<FieldSchema> cols = null;
            if (colPath.equals(tableName)) {
                List<FieldSchema> list = cols = part == null || tbl.getTableType() == TableType.VIRTUAL_VIEW ? tbl.getCols() : part.getCols();
                if (!descTbl.isFormatted() && tableName.equals(colPath)) {
                    cols.addAll(tbl.getPartCols());
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, tbl.getDeserializer());
            }
            this.formatter.describeTable((DataOutputStream)outStream, colPath, tableName, tbl, part, cols, descTbl.isFormatted(), descTbl.isExt());
            LOG.info((Object)("DDLTask: written data for " + tbl.getTableName()));
            outStream.close();
            outStream = null;
        }
        catch (FileNotFoundException e) {
            this.formatter.logInfo((OutputStream)outStream, "describe table: " + StringUtils.stringifyException((Throwable)e), 500);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            this.formatter.logInfo((OutputStream)outStream, "describe table: " + StringUtils.stringifyException((Throwable)e), 500);
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    public static void writeGrantInfo(DataOutput outStream, PrincipalType principalType, String principalName, String dbName, String tableName, String partName, String columnName, PrivilegeGrantInfo grantInfo) throws IOException {
        String privilege = grantInfo.getPrivilege();
        long unixTimestamp = (long)grantInfo.getCreateTime() * 1000L;
        Date createTime = new Date(unixTimestamp);
        String grantor = grantInfo.getGrantor();
        if (dbName != null) {
            DDLTask.writeKeyValuePair(outStream, "database", dbName);
        }
        if (tableName != null) {
            DDLTask.writeKeyValuePair(outStream, "table", tableName);
        }
        if (partName != null) {
            DDLTask.writeKeyValuePair(outStream, "partition", partName);
        }
        if (columnName != null) {
            DDLTask.writeKeyValuePair(outStream, "columnName", columnName);
        }
        DDLTask.writeKeyValuePair(outStream, "principalName", principalName);
        DDLTask.writeKeyValuePair(outStream, "principalType", "" + principalType);
        DDLTask.writeKeyValuePair(outStream, "privilege", privilege);
        DDLTask.writeKeyValuePair(outStream, "grantTime", "" + createTime);
        if (grantor != null) {
            DDLTask.writeKeyValuePair(outStream, "grantor", grantor);
        }
    }

    private static void writeKeyValuePair(DataOutput outStream, String key, String value) throws IOException {
        outStream.write(10);
        outStream.writeBytes(key);
        outStream.write(9);
        outStream.writeBytes(value);
        outStream.write(9);
    }

    private void setAlterProtectMode(boolean protectModeEnable, AlterTableDesc.ProtectModeType protectMode, ProtectMode mode) {
        if (protectMode == AlterTableDesc.ProtectModeType.OFFLINE) {
            mode.offline = protectModeEnable;
        } else if (protectMode == AlterTableDesc.ProtectModeType.NO_DROP) {
            mode.noDrop = protectModeEnable;
        } else if (protectMode == AlterTableDesc.ProtectModeType.NO_DROP_CASCADE) {
            mode.noDropCascade = protectModeEnable;
        }
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable(alterTbl.getOldName());
        Partition part = null;
        List<Partition> allPartitions = null;
        if (alterTbl.getPartSpec() != null) {
            if (alterTbl.getOp() != AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE) {
                part = db.getPartition(tbl, alterTbl.getPartSpec(), false);
                if (part == null) {
                    this.formatter.consoleError(this.console, "Partition : " + alterTbl.getPartSpec().toString() + " does not exist.", 404);
                    return 1;
                }
            } else {
                allPartitions = db.getPartitions(tbl, alterTbl.getPartSpec());
            }
        }
        Table oldTbl = tbl.copy();
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setTableName(alterTbl.getNewName());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            List<FieldSchema> oldCols = tbl.getCols();
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                tbl.getTTable().getSd().setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        this.formatter.consoleError(this.console, "Column '" + newColName + "' exists", 409);
                        return 1;
                    }
                    oldCols.add(newCol);
                }
                tbl.getTTable().getSd().setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            List<FieldSchema> oldCols = tbl.getCols();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    this.formatter.consoleError(this.console, "Column '" + newName + "' exists", 409);
                    return 1;
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                this.formatter.consoleError(this.console, "Column '" + oldName + "' does not exists", 404);
                return 1;
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                this.formatter.consoleError(this.console, "Column '" + afterCol + "' does not exists", 404);
                return 1;
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            tbl.getTTable().getSd().setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(tbl.getSerializationLib().equals(MetadataTypedColumnsetSerDe.class.getName()) || tbl.getSerializationLib().equals(LazySimpleSerDe.class.getName()) || tbl.getSerializationLib().equals(ColumnarSerDe.class.getName()) || tbl.getSerializationLib().equals(DynamicSerDe.class.getName()))) {
                this.formatter.consoleError(this.console, "Replace columns is not supported for this table. SerDe may be incompatible.", 500);
                return 1;
            }
            tbl.getTTable().getSd().setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
            if (part != null) {
                part.getTPartition().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            } else {
                tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
            String serdeName = alterTbl.getSerdeName();
            if (part != null) {
                part.getTPartition().getSd().getSerdeInfo().setSerializationLib(serdeName);
                if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                    part.getTPartition().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
                }
                part.getTPartition().getSd().setCols(part.getTPartition().getSd().getCols());
            } else {
                tbl.setSerializationLib(alterTbl.getSerdeName());
                if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                    tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
                }
                tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), tbl.getDeserializer()));
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
            if (part != null) {
                part.getTPartition().getSd().setInputFormat(alterTbl.getInputFormat());
                part.getTPartition().getSd().setOutputFormat(alterTbl.getOutputFormat());
                if (alterTbl.getSerdeName() != null) {
                    part.getTPartition().getSd().getSerdeInfo().setSerializationLib(alterTbl.getSerdeName());
                }
            } else {
                tbl.getTTable().getSd().setInputFormat(alterTbl.getInputFormat());
                tbl.getTTable().getSd().setOutputFormat(alterTbl.getOutputFormat());
                if (alterTbl.getSerdeName() != null) {
                    tbl.setSerializationLib(alterTbl.getSerdeName());
                }
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE) {
            boolean protectModeEnable = alterTbl.isProtectModeEnable();
            AlterTableDesc.ProtectModeType protectMode = alterTbl.getProtectModeType();
            ProtectMode mode = null;
            if (allPartitions != null) {
                for (Partition tmpPart : allPartitions) {
                    mode = tmpPart.getProtectMode();
                    this.setAlterProtectMode(protectModeEnable, protectMode, mode);
                    tmpPart.setProtectMode(mode);
                }
            } else {
                mode = tbl.getProtectMode();
                this.setAlterProtectMode(protectModeEnable, protectMode, mode);
                tbl.setProtectMode(mode);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            int numBuckets = -1;
            ArrayList<String> bucketCols = null;
            ArrayList<Object> sortCols = null;
            if (alterTbl.getNumberBuckets() == -1) {
                bucketCols = new ArrayList();
                sortCols = new ArrayList();
                numBuckets = -1;
            } else {
                bucketCols = alterTbl.getBucketColumns();
                sortCols = alterTbl.getSortColumns();
                numBuckets = alterTbl.getNumberBuckets();
            }
            tbl.getTTable().getSd().setBucketCols(bucketCols);
            tbl.getTTable().getSd().setNumBuckets(numBuckets);
            tbl.getTTable().getSd().setSortCols(sortCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
            String newLocation = alterTbl.getNewLocation();
            try {
                URI locUri = new URI(newLocation);
                if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                    throw new HiveException(newLocation + " is not absolute or has no scheme information. " + "Please specify a complete absolute uri with scheme information.");
                }
                if (part != null) {
                    part.setLocation(newLocation);
                }
                tbl.setDataLocation(locUri);
            }
            catch (URISyntaxException e) {
                throw new HiveException(e);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSKEWEDBY) {
            List<String> skewedColNames = null;
            List<List<String>> skewedValues = null;
            if (alterTbl.isTurnOffSkewed()) {
                skewedColNames = new ArrayList<String>();
                skewedValues = new ArrayList<List<String>>();
            } else {
                skewedColNames = alterTbl.getSkewedColNames();
                skewedValues = alterTbl.getSkewedColValues();
            }
            if (null == tbl.getSkewedInfo()) {
                SkewedInfo skewedInfo = new SkewedInfo();
                skewedInfo.setSkewedColNames(skewedColNames);
                skewedInfo.setSkewedColValues(skewedValues);
                tbl.setSkewedInfo(skewedInfo);
            } else {
                tbl.setSkewedColNames(skewedColNames);
                tbl.setSkewedColValues(skewedValues);
            }
            tbl.setStoredAsSubDirectories(alterTbl.isStoredAsSubDirectories());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERSKEWEDLOCATION) {
            Map<List<String>, String> locMaps = alterTbl.getSkewedLocations();
            Set<List<String>> keys = locMaps.keySet();
            for (List<String> key : keys) {
                String newLocation = locMaps.get(key);
                try {
                    ArrayList<String> slk;
                    URI locUri = new URI(newLocation);
                    if (part != null) {
                        slk = new ArrayList<String>(key);
                        part.setSkewedValueLocationMap(slk, locUri.toString());
                        continue;
                    }
                    slk = new ArrayList<String>(key);
                    tbl.setSkewedValueLocationMap(slk, locUri.toString());
                }
                catch (URISyntaxException e) {
                    throw new HiveException(e);
                }
            }
        } else {
            this.formatter.consoleError(this.console, "Unsupported Alter commnad", 500);
            return 1;
        }
        if (part == null && allPartitions == null) {
            if (!this.updateModifiedParameters(tbl.getTTable().getParameters(), this.conf)) {
                return 1;
            }
            try {
                tbl.checkValidity();
            }
            catch (HiveException e) {
                this.formatter.consoleError(this.console, "Invalid table columns : " + e.getMessage(), 500);
                return 1;
            }
        } else if (part != null) {
            if (!this.updateModifiedParameters(part.getParameters(), this.conf)) {
                return 1;
            }
        } else {
            for (Partition tmpPart : allPartitions) {
                if (this.updateModifiedParameters(tmpPart.getParameters(), this.conf)) continue;
                return 1;
            }
        }
        try {
            if (part == null && allPartitions == null) {
                db.alterTable(alterTbl.getOldName(), tbl);
            } else if (part != null) {
                db.alterPartition(tbl.getTableName(), part);
            } else {
                db.alterPartitions(tbl.getTableName(), allPartitions);
            }
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter table: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            return 1;
        }
        if (part != null) {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        } else if (allPartitions != null) {
            for (Partition tmpPart : allPartitions) {
                ((DDLWork)this.work).getInputs().add(new ReadEntity(tmpPart));
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(tmpPart));
            }
        } else {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        }
        return 0;
    }

    private int dropTable(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException e) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            if (tbl != null) {
                if (tbl.isView()) {
                    if (!dropTbl.getExpectView()) {
                        if (dropTbl.getIfExists()) {
                            return 0;
                        }
                        throw new HiveException("Cannot drop a view with DROP TABLE");
                    }
                } else if (dropTbl.getExpectView()) {
                    if (dropTbl.getIfExists()) {
                        return 0;
                    }
                    throw new HiveException("Cannot drop a base table with DROP VIEW");
                }
            }
            if (tbl != null && !tbl.canDrop()) {
                throw new HiveException("Table " + tbl.getTableName() + " is protected from being dropped");
            }
            int partitionBatchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX);
            if (tbl != null && tbl.isPartitioned()) {
                List<String> partitionNames = db.getPartitionNames(tbl.getTableName(), (short)-1);
                for (int i = 0; i < partitionNames.size(); i += partitionBatchSize) {
                    List<String> partNames = partitionNames.subList(i, Math.min(i + partitionBatchSize, partitionNames.size()));
                    List<Partition> listPartitions = db.getPartitionsByNames(tbl, partNames);
                    for (Partition p : listPartitions) {
                        if (p.canDrop()) continue;
                        throw new HiveException("Table " + tbl.getTableName() + " Partition" + p.getName() + " is protected from being dropped");
                    }
                }
            }
            db.dropTable(dropTbl.getTableName());
            if (tbl != null) {
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
            }
        } else {
            ArrayList<Partition> partsToDelete = new ArrayList<Partition>();
            for (PartitionSpec partSpec : dropTbl.getPartSpecs()) {
                List<Partition> partitions = null;
                if (dropTbl.isStringPartitionColumns()) {
                    try {
                        partitions = db.getPartitionsByFilter(tbl, partSpec.toString());
                    }
                    catch (Exception e) {
                        throw new HiveException(e);
                    }
                } else {
                    partitions = db.getPartitions(tbl, partSpec.getPartSpecWithoutOperator());
                }
                int partPrefixToDrop = 0;
                for (FieldSchema fs : tbl.getPartCols()) {
                    if (!partSpec.existsKey(fs.getName())) break;
                    ++partPrefixToDrop;
                }
                for (Partition p : partitions) {
                    int partAchiveLevel;
                    if (!p.canDrop()) {
                        throw new HiveException("Table " + tbl.getTableName() + " Partition " + p.getName() + " is protected from being dropped");
                    }
                    if (!ArchiveUtils.isArchived(p) || (partAchiveLevel = ArchiveUtils.getArchivingLevel(p)) >= partPrefixToDrop) continue;
                    throw new HiveException("Cannot drop a subset of partitions in an archive, partition " + p.getName());
                }
                partsToDelete.addAll(partitions);
            }
            for (Partition partition : partsToDelete) {
                this.console.printInfo("Dropping the partition " + partition.getName());
                db.dropPartition(dropTbl.getTableName(), partition.getValues(), true);
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition));
            }
        }
        return 0;
    }

    private boolean updateModifiedParameters(Map<String, String> params, HiveConf conf) {
        String user = null;
        try {
            user = conf.getUser();
        }
        catch (IOException e) {
            this.formatter.consoleError(this.console, "Unable to get current user: " + e.getMessage(), StringUtils.stringifyException((Throwable)e), 500);
            return false;
        }
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        return true;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = SerDeUtils.lookupDeserializer(serdeName);
            if (d != null) {
                LOG.debug((Object)("Found class for " + serdeName));
            }
        }
        catch (SerDeException e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException, AlreadyExistsException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        database.setParameters(crtDb.getDatabaseProperties());
        db.createDatabase(database, crtDb.getIfNotExists());
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException, NoSuchObjectException {
        db.dropDatabase(dropDb.getDatabaseName(), true, dropDb.getIfExists(), dropDb.isCasdade());
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        db.setCurrentDatabase(dbName);
        Database database = db.getDatabase(dbName);
        assert (database != null);
        Map dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = (String)dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info((Object)("Changing " + var.varname + " from " + this.conf.getVar(var) + " to " + newValue));
                this.conf.setVar(var, newValue);
            }
        }
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        int rc;
        Table tbl = db.newTable(crtTbl.getTableName());
        if (crtTbl.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
        }
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tbl.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", crtTbl.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (crtTbl.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info((Object)("Default to LazySimpleSerDe for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info((Object)("Use StorageHandler-supplied " + serDeClassName + " for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            this.validateSerDe(crtTbl.getSerName());
            tbl.setSerializationLib(crtTbl.getSerName());
        }
        if (crtTbl.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
            tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
        }
        if (crtTbl.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
        }
        if (crtTbl.getCollItemDelim() != null) {
            tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
        }
        if (crtTbl.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
        }
        if (crtTbl.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
        }
        if (crtTbl.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : crtTbl.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        if (crtTbl.getBucketCols() != null) {
            tbl.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
        }
        if (crtTbl.getSkewedColNames() != null) {
            tbl.setSkewedColNames(crtTbl.getSkewedColNames());
        }
        if (crtTbl.getSkewedColValues() != null) {
            tbl.setSkewedColValues(crtTbl.getSkewedColValues());
        }
        tbl.setStoredAsSubDirectories(crtTbl.isStoredAsSubDirectories());
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
            return rc;
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws HiveException {
        Table tbl;
        String targetTableName;
        Table oldtbl = db.getTable(crtTbl.getLikeTableName());
        if (oldtbl.getTableType() == TableType.VIRTUAL_VIEW) {
            targetTableName = crtTbl.getTableName();
            tbl = db.newTable(targetTableName);
            tbl.setTableType(TableType.MANAGED_TABLE);
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            }
            tbl.setFields(oldtbl.getCols());
            tbl.setPartCols(oldtbl.getPartCols());
            if (crtTbl.getDefaultSerName() == null) {
                LOG.info((Object)("Default to LazySimpleSerDe for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                this.validateSerDe(crtTbl.getDefaultSerName());
                tbl.setSerializationLib(crtTbl.getDefaultSerName());
            }
            if (crtTbl.getDefaultSerdeProps() != null) {
                for (Map.Entry<String, String> m : crtTbl.getDefaultSerdeProps().entrySet()) {
                    tbl.setSerdeParam(m.getKey(), m.getValue());
                }
            }
            tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
            tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        } else {
            tbl = oldtbl;
            targetTableName = crtTbl.getTableName();
            Table newTable = db.newTable(targetTableName);
            tbl.setDbName(newTable.getDbName());
            tbl.setTableName(newTable.getTableName());
            if (crtTbl.getLocation() != null) {
                tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
            } else {
                tbl.unsetDataLocation();
            }
            Map<String, String> params = tbl.getParameters();
            String paramsStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.DDL_CTL_PARAMETERS_WHITELIST);
            if (paramsStr != null) {
                List<String> paramsList = Arrays.asList(paramsStr.split(","));
                params.keySet().retainAll(paramsList);
            } else {
                params.clear();
            }
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            } else {
                tbl.getParameters().remove("EXTERNAL");
            }
        }
        int rc = this.setGenericTableAttributes(tbl);
        if (rc != 0) {
            return rc;
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        Table oldview = db.getTable(crtView.getViewName(), false);
        if (crtView.getOrReplace() && oldview != null) {
            if (!oldview.getTableType().equals((Object)TableType.VIRTUAL_VIEW)) {
                throw new HiveException("Existing table is not a view");
            }
            if (!(crtView.getPartCols() != null && !crtView.getPartCols().isEmpty() && ((Object)crtView.getPartCols()).equals(oldview.getPartCols()) || oldview.getPartCols().isEmpty() || db.getPartitions(oldview).isEmpty())) {
                throw new HiveException("Cannot add or drop partition columns with CREATE OR REPLACE VIEW if partitions currently exist");
            }
            oldview.setViewOriginalText(crtView.getViewOriginalText());
            oldview.setViewExpandedText(crtView.getViewExpandedText());
            oldview.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                oldview.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                oldview.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            oldview.setPartCols(crtView.getPartCols());
            oldview.checkValidity();
            try {
                db.alterTable(crtView.getViewName(), oldview);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(oldview));
        } else {
            int rc;
            Table tbl = db.newTable(crtView.getViewName());
            tbl.setTableType(TableType.VIRTUAL_VIEW);
            tbl.setSerializationLib(null);
            tbl.clearSerDeInfo();
            tbl.setViewOriginalText(crtView.getViewOriginalText());
            tbl.setViewExpandedText(crtView.getViewExpandedText());
            tbl.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                tbl.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            if (crtView.getPartCols() != null) {
                tbl.setPartCols(crtView.getPartCols());
            }
            if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
                return rc;
            }
            db.createTable(tbl, crtView.getIfNotExists());
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        }
        return 0;
    }

    private int setGenericTableAttributes(Table tbl) {
        try {
            tbl.setOwner(this.conf.getUser());
        }
        catch (IOException e) {
            this.formatter.consoleError(this.console, "Unable to get current user: " + e.getMessage(), StringUtils.stringifyException((Throwable)e), 500);
            return 1;
        }
        tbl.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        return 0;
    }

    private String escapeHiveCommand(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }
}

