/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class ExprNodeFieldEvaluator
extends ExprNodeEvaluator {
    protected ExprNodeFieldDesc desc;
    transient ExprNodeEvaluator leftEvaluator;
    transient ObjectInspector leftInspector;
    transient StructObjectInspector structObjectInspector;
    transient StructField field;
    transient ObjectInspector structFieldObjectInspector;
    transient ObjectInspector resultObjectInspector;
    private List<Object> cachedList = new ArrayList<Object>();

    public ExprNodeFieldEvaluator(ExprNodeFieldDesc desc) {
        this.desc = desc;
        this.leftEvaluator = ExprNodeEvaluatorFactory.get(desc.getDesc());
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        this.leftInspector = this.leftEvaluator.initialize(rowInspector);
        this.structObjectInspector = this.desc.getIsList() != false ? (StructObjectInspector)((ListObjectInspector)this.leftInspector).getListElementObjectInspector() : (StructObjectInspector)this.leftInspector;
        this.field = this.structObjectInspector.getStructFieldRef(this.desc.getFieldName());
        this.structFieldObjectInspector = this.field.getFieldObjectInspector();
        this.resultObjectInspector = this.desc.getIsList() != false ? ObjectInspectorFactory.getStandardListObjectInspector(this.structFieldObjectInspector) : this.structFieldObjectInspector;
        return this.resultObjectInspector;
    }

    @Override
    public Object evaluate(Object row) throws HiveException {
        Object left = this.leftEvaluator.evaluate(row);
        if (this.desc.getIsList().booleanValue()) {
            List<?> list = ((ListObjectInspector)this.leftInspector).getList(left);
            if (list == null) {
                return null;
            }
            this.cachedList.clear();
            for (int i = 0; i < list.size(); ++i) {
                this.cachedList.add(this.structObjectInspector.getStructFieldData(list.get(i), this.field));
            }
            return this.cachedList;
        }
        return this.structObjectInspector.getStructFieldData(left, this.field);
    }
}

