/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDAFPercentile;
import org.apache.hadoop.hive.ql.udf.UDFAbs;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFCeil;
import org.apache.hadoop.hive.ql.udf.UDFConcat;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDate;
import org.apache.hadoop.hive.ql.udf.UDFDateAdd;
import org.apache.hadoop.hive.ql.udf.UDFDateDiff;
import org.apache.hadoop.hive.ql.udf.UDFDateSub;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFE;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFindInSet;
import org.apache.hadoop.hive.ql.udf.UDFFloor;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.hive.ql.udf.UDFLTrim;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFLower;
import org.apache.hadoop.hive.ql.udf.UDFLpad;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFOPBitAnd;
import org.apache.hadoop.hive.ql.udf.UDFOPBitNot;
import org.apache.hadoop.hive.ql.udf.UDFOPBitOr;
import org.apache.hadoop.hive.ql.udf.UDFOPBitXor;
import org.apache.hadoop.hive.ql.udf.UDFOPDivide;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFOPMinus;
import org.apache.hadoop.hive.ql.udf.UDFOPMod;
import org.apache.hadoop.hive.ql.udf.UDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.UDFOPNegative;
import org.apache.hadoop.hive.ql.udf.UDFOPPlus;
import org.apache.hadoop.hive.ql.udf.UDFOPPositive;
import org.apache.hadoop.hive.ql.udf.UDFPI;
import org.apache.hadoop.hive.ql.udf.UDFParseUrl;
import org.apache.hadoop.hive.ql.udf.UDFPosMod;
import org.apache.hadoop.hive.ql.udf.UDFPower;
import org.apache.hadoop.hive.ql.udf.UDFRTrim;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFRepeat;
import org.apache.hadoop.hive.ql.udf.UDFReverse;
import org.apache.hadoop.hive.ql.udf.UDFRound;
import org.apache.hadoop.hive.ql.udf.UDFRpad;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSpace;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFTrim;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.UDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.UDFUpper;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCollectSet;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFComputeStats;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFContextNGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEWAHBitmap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFHistogramNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileApprox;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFnGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayContains;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAssertTrue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcatWS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapEmpty;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFormatNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInFile;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIndex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInstr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLocate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapKeys;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapValues;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNamedStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPrintf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFReflect;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSentences;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSize;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSortArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSplit;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTranslate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnion;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFJSONTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFParseUrlTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFStack;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.xml.GenericUDFXPath;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathBoolean;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathDouble;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathFloat;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathInteger;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathLong;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathShort;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathString;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FunctionRegistry {
    private static Log LOG = LogFactory.getLog(FunctionRegistry.class);
    static Map<String, FunctionInfo> mFunctions = Collections.synchronizedMap(new LinkedHashMap());
    static Map<TypeInfo, Integer> numericTypes;
    static List<TypeInfo> numericTypeList;

    public static void registerTemporaryUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(false, functionName, UDFClass, isOperator);
    }

    static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(isNative, functionName, UDFClass, isOperator, functionName.toLowerCase());
    }

    public static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator, displayName);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        if (!UDF.class.isAssignableFrom(UDFClass)) {
            throw new RuntimeException("Registering UDF Class " + UDFClass + " which does not extend " + UDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, displayName, new GenericUDFBridge(displayName, isOperator, UDFClass));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static void registerTemporaryGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(false, functionName, genericUDFClass);
    }

    static void registerGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(true, functionName, genericUDFClass);
    }

    public static void registerGenericUDF(boolean isNative, String functionName, Class<? extends GenericUDF> genericUDFClass) {
        if (!GenericUDF.class.isAssignableFrom(genericUDFClass)) {
            throw new RuntimeException("Registering GenericUDF Class " + genericUDFClass + " which does not extend " + GenericUDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDF)ReflectionUtils.newInstance(genericUDFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static void registerTemporaryGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(false, functionName, genericUDTFClass);
    }

    static void registerGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(true, functionName, genericUDTFClass);
    }

    public static void registerGenericUDTF(boolean isNative, String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        if (!GenericUDTF.class.isAssignableFrom(genericUDTFClass)) {
            throw new RuntimeException("Registering GenericUDTF Class " + genericUDTFClass + " which does not extend " + GenericUDTF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDTF)ReflectionUtils.newInstance(genericUDTFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static FunctionInfo getFunctionInfo(String functionName) {
        return mFunctions.get(functionName.toLowerCase());
    }

    public static Set<String> getFunctionNames() {
        return mFunctions.keySet();
    }

    public static Set<String> getFunctionNames(String funcPatternStr) {
        TreeSet<String> funcNames = new TreeSet<String>();
        Pattern funcPattern = null;
        try {
            funcPattern = Pattern.compile(funcPatternStr);
        }
        catch (PatternSyntaxException e) {
            return funcNames;
        }
        for (String funcName : mFunctions.keySet()) {
            if (!funcPattern.matcher(funcName).matches()) continue;
            funcNames.add(funcName);
        }
        return funcNames;
    }

    public static Set<String> getFunctionSynonyms(String funcName) {
        HashSet<String> synonyms = new HashSet<String>();
        FunctionInfo funcInfo = FunctionRegistry.getFunctionInfo(funcName);
        if (null == funcInfo) {
            return synonyms;
        }
        Class<?> funcClass = funcInfo.getFunctionClass();
        for (String name : mFunctions.keySet()) {
            if (name.equals(funcName) || !mFunctions.get(name).getFunctionClass().equals(funcClass)) continue;
            synonyms.add(name);
        }
        return synonyms;
    }

    static void registerNumericType(String typeName, int level) {
        TypeInfo t = TypeInfoFactory.getPrimitiveTypeInfo(typeName);
        numericTypeList.add(t);
        numericTypes.put(t, level);
    }

    public static TypeInfo getCommonClassForUnionAll(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        if (FunctionRegistry.implicitConvertable(a, b)) {
            return b;
        }
        if (FunctionRegistry.implicitConvertable(b, a)) {
            return a;
        }
        for (TypeInfo t : numericTypeList) {
            if (!FunctionRegistry.implicitConvertable(a, t) || !FunctionRegistry.implicitConvertable(b, t)) continue;
            return t;
        }
        return null;
    }

    public static TypeInfo getCommonClassForComparison(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        for (TypeInfo t : numericTypeList) {
            if (!FunctionRegistry.implicitConvertable(a, t) || !FunctionRegistry.implicitConvertable(b, t)) continue;
            return t;
        }
        return null;
    }

    public static TypeInfo getCommonClass(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        Integer ai = numericTypes.get(a);
        Integer bi = numericTypes.get(b);
        if (ai == null || bi == null) {
            return null;
        }
        return ai > bi ? a : b;
    }

    public static boolean implicitConvertable(TypeInfo from, TypeInfo to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.equals(TypeInfoFactory.stringTypeInfo) && to.equals(TypeInfoFactory.doubleTypeInfo)) {
            return true;
        }
        if (from.equals(TypeInfoFactory.voidTypeInfo)) {
            return true;
        }
        if (from.equals(TypeInfoFactory.timestampTypeInfo) && to.equals(TypeInfoFactory.stringTypeInfo)) {
            return true;
        }
        Integer f = numericTypes.get(from);
        Integer t = numericTypes.get(to);
        if (f == null || t == null) {
            return false;
        }
        return f <= t;
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFResolver udafResolver = FunctionRegistry.getGenericUDAFResolver(name);
        if (udafResolver == null) {
            return null;
        }
        GenericUDAFEvaluator udafEvaluator = null;
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        for (int ii = 0; ii < argumentOIs.size(); ++ii) {
            args[ii] = argumentOIs.get(ii);
        }
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(args, isDistinct, isAllColumns);
        udafEvaluator = udafResolver instanceof GenericUDAFResolver2 ? ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo) : udafResolver.getEvaluator(paramInfo.getParameters());
        return udafEvaluator;
    }

    public static <T> Method getMethodInternal(Class<? extends T> udfClass, String methodName, boolean exact, List<TypeInfo> argumentClasses) throws UDFArgumentException {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return FunctionRegistry.getMethodInternal(udfClass, mlist, exact, argumentClasses);
    }

    public static void registerTemporaryGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(false, functionName, genericUDAFResolver);
    }

    static void registerGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(true, functionName, genericUDAFResolver);
    }

    public static void registerGenericUDAF(boolean isNative, String functionName, GenericUDAFResolver genericUDAFResolver) {
        mFunctions.put(functionName.toLowerCase(), new FunctionInfo(isNative, functionName.toLowerCase(), genericUDAFResolver));
    }

    public static void registerTemporaryUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(false, functionName, udafClass);
    }

    static void registerUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(true, functionName, udafClass);
    }

    public static void registerUDAF(boolean isNative, String functionName, Class<? extends UDAF> udafClass) {
        mFunctions.put(functionName.toLowerCase(), new FunctionInfo(isNative, functionName.toLowerCase(), new GenericUDAFBridge((UDAF)ReflectionUtils.newInstance(udafClass, null))));
    }

    public static void unregisterTemporaryUDF(String functionName) throws HiveException {
        FunctionInfo fi = mFunctions.get(functionName.toLowerCase());
        if (fi != null) {
            if (!fi.isNative()) {
                mFunctions.remove(functionName.toLowerCase());
            } else {
                throw new HiveException("Function " + functionName + " is hive native, it can't be dropped");
            }
        }
    }

    public static GenericUDAFResolver getGenericUDAFResolver(String functionName) {
        FunctionInfo finfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking up GenericUDAF: " + functionName));
        }
        if ((finfo = mFunctions.get(functionName.toLowerCase())) == null) {
            return null;
        }
        GenericUDAFResolver result = finfo.getGenericUDAFResolver();
        return result;
    }

    public static Object invoke(Method m, Object thisObject, Object ... arguments) throws HiveException {
        Object o;
        try {
            o = m.invoke(thisObject, arguments);
        }
        catch (Exception e) {
            String thisObjectString = "" + thisObject + " of class " + (thisObject == null ? "null" : thisObject.getClass().getName());
            StringBuilder argumentString = new StringBuilder();
            if (arguments == null) {
                argumentString.append("null");
            } else {
                argumentString.append("{");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        argumentString.append(", ");
                    }
                    if (arguments[i] == null) {
                        argumentString.append("null");
                        continue;
                    }
                    argumentString.append("" + arguments[i] + ":" + arguments[i].getClass().getName());
                }
                argumentString.append("} of size " + arguments.length);
            }
            throw new HiveException("Unable to execute method " + m + " " + " on object " + thisObjectString + " with arguments " + argumentString.toString(), e);
        }
        return o;
    }

    public static int matchCost(TypeInfo argumentPassed, TypeInfo argumentAccepted, boolean exact) {
        if (argumentAccepted.equals(argumentPassed)) {
            return 0;
        }
        if (argumentPassed.equals(TypeInfoFactory.voidTypeInfo)) {
            return 0;
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.LIST) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo argumentPassedElement = ((ListTypeInfo)argumentPassed).getListElementTypeInfo();
            TypeInfo argumentAcceptedElement = ((ListTypeInfo)argumentAccepted).getListElementTypeInfo();
            return FunctionRegistry.matchCost(argumentPassedElement, argumentAcceptedElement, exact);
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.MAP) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo argumentPassedKey = ((MapTypeInfo)argumentPassed).getMapKeyTypeInfo();
            TypeInfo argumentAcceptedKey = ((MapTypeInfo)argumentAccepted).getMapKeyTypeInfo();
            TypeInfo argumentPassedValue = ((MapTypeInfo)argumentPassed).getMapValueTypeInfo();
            TypeInfo argumentAcceptedValue = ((MapTypeInfo)argumentAccepted).getMapValueTypeInfo();
            int cost1 = FunctionRegistry.matchCost(argumentPassedKey, argumentAcceptedKey, exact);
            int cost2 = FunctionRegistry.matchCost(argumentPassedValue, argumentAcceptedValue, exact);
            if (cost1 < 0 || cost2 < 0) {
                return -1;
            }
            return Math.max(cost1, cost2);
        }
        if (argumentAccepted.equals(TypeInfoFactory.unknownTypeInfo)) {
            return 1;
        }
        if (!exact && FunctionRegistry.implicitConvertable(argumentPassed, argumentAccepted)) {
            return 1;
        }
        return -1;
    }

    public static Method getMethodInternal(Class<?> udfClass, List<Method> mlist, boolean exact, List<TypeInfo> argumentsPassed) throws UDFArgumentException {
        ArrayList<Method> udfMethods = new ArrayList<Method>();
        int leastConversionCost = Integer.MAX_VALUE;
        for (Method m : mlist) {
            List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
            if (argumentsAccepted == null) continue;
            boolean match = argumentsAccepted.size() == argumentsPassed.size();
            int conversionCost = 0;
            for (int i = 0; i < argumentsPassed.size() && match; ++i) {
                int cost = FunctionRegistry.matchCost(argumentsPassed.get(i), argumentsAccepted.get(i), exact);
                if (cost == -1) {
                    match = false;
                    continue;
                }
                conversionCost += cost;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Method " + (match ? "did" : "didn't") + " match: passed = " + argumentsPassed + " accepted = " + argumentsAccepted + " method = " + m));
            }
            if (!match) continue;
            if (conversionCost < leastConversionCost) {
                udfMethods.clear();
                udfMethods.add(m);
                leastConversionCost = conversionCost;
                if (leastConversionCost != 0) continue;
                break;
            }
            if (conversionCost != leastConversionCost) continue;
            udfMethods.add(m);
        }
        if (udfMethods.size() == 0) {
            throw new NoMatchingMethodException(udfClass, argumentsPassed, mlist);
        }
        if (udfMethods.size() > 1) {
            throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
        }
        return (Method)udfMethods.get(0);
    }

    public static GenericUDF getGenericUDFForIndex() {
        return FunctionRegistry.getFunctionInfo("index").getGenericUDF();
    }

    public static GenericUDF getGenericUDFForAnd() {
        return FunctionRegistry.getFunctionInfo("and").getGenericUDF();
    }

    public static GenericUDF cloneGenericUDF(GenericUDF genericUDF) {
        if (null == genericUDF) {
            return null;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)genericUDF;
            return new GenericUDFBridge(bridge.getUdfName(), bridge.isOperator(), bridge.getUdfClass());
        }
        return (GenericUDF)ReflectionUtils.newInstance(genericUDF.getClass(), null);
    }

    public static GenericUDTF cloneGenericUDTF(GenericUDTF genericUDTF) {
        if (null == genericUDTF) {
            return null;
        }
        return (GenericUDTF)ReflectionUtils.newInstance(genericUDTF.getClass(), null);
    }

    private static Class<? extends GenericUDF> getGenericUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        return genericFuncDesc.getGenericUDF().getClass();
    }

    private static Class<? extends UDF> getUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        if (!(genericFuncDesc.getGenericUDF() instanceof GenericUDFBridge)) {
            return null;
        }
        GenericUDFBridge bridge = (GenericUDFBridge)genericFuncDesc.getGenericUDF();
        return bridge.getUdfClass();
    }

    public static boolean isDeterministic(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        if (FunctionRegistry.isStateful(genericUDF)) {
            return false;
        }
        UDFType genericUDFType = genericUDF.getClass().getAnnotation(UDFType.class);
        if (genericUDFType != null && !genericUDFType.deterministic()) {
            return false;
        }
        return !(genericUDF instanceof GenericUDFBridge) || (bridgeUDFType = (bridge = (GenericUDFBridge)genericUDF).getUdfClass().getAnnotation(UDFType.class)) == null || bridgeUDFType.deterministic();
    }

    public static boolean isStateful(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        UDFType genericUDFType = genericUDF.getClass().getAnnotation(UDFType.class);
        if (genericUDFType != null && genericUDFType.stateful()) {
            return true;
        }
        return genericUDF instanceof GenericUDFBridge && (bridgeUDFType = (bridge = (GenericUDFBridge)genericUDF).getUdfClass().getAnnotation(UDFType.class)) != null && bridgeUDFType.stateful();
    }

    public static boolean isOpAndOrNot(ExprNodeDesc desc) {
        Class<? extends GenericUDF> genericUdfClass = FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
        return GenericUDFOPAnd.class == genericUdfClass || GenericUDFOPOr.class == genericUdfClass || GenericUDFOPNot.class == genericUdfClass;
    }

    public static boolean isOpAnd(ExprNodeDesc desc) {
        return GenericUDFOPAnd.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpOr(ExprNodeDesc desc) {
        return GenericUDFOPOr.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpNot(ExprNodeDesc desc) {
        return GenericUDFOPNot.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpPositive(ExprNodeDesc desc) {
        Class<? extends UDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(desc);
        return UDFOPPositive.class == udfClass;
    }

    public static boolean registerTemporaryFunction(String functionName, Class<?> udfClass) {
        if (UDF.class.isAssignableFrom(udfClass)) {
            FunctionRegistry.registerTemporaryUDF(functionName, udfClass, false);
        } else if (GenericUDF.class.isAssignableFrom(udfClass)) {
            FunctionRegistry.registerTemporaryGenericUDF(functionName, udfClass);
        } else if (GenericUDTF.class.isAssignableFrom(udfClass)) {
            FunctionRegistry.registerTemporaryGenericUDTF(functionName, udfClass);
        } else if (UDAF.class.isAssignableFrom(udfClass)) {
            FunctionRegistry.registerTemporaryUDAF(functionName, udfClass);
        } else if (GenericUDAFResolver.class.isAssignableFrom(udfClass)) {
            FunctionRegistry.registerTemporaryGenericUDAF(functionName, (GenericUDAFResolver)ReflectionUtils.newInstance(udfClass, null));
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFunctionsFromPluginJar(URL jarLocation, ClassLoader classLoader) throws Exception {
        URL url = new URL("jar:" + jarLocation + "!/META-INF/class-info.xml");
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals("ClassList")) {
                return;
            }
            NodeList children = root.getElementsByTagName("Class");
            for (int i = 0; i < children.getLength(); ++i) {
                Class<?> udfClass;
                Element child = (Element)children.item(i);
                String javaName = child.getAttribute("javaname");
                String sqlName = child.getAttribute("sqlname");
                boolean registered = FunctionRegistry.registerTemporaryFunction(sqlName, udfClass = Class.forName(javaName, true, classLoader));
                if (registered) continue;
                throw new RuntimeException("Class " + udfClass + " is not a Hive function implementation");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)inputStream);
        }
    }

    private FunctionRegistry() {
    }

    static {
        FunctionRegistry.registerUDF("concat", UDFConcat.class, false);
        FunctionRegistry.registerUDF("substr", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("substring", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("space", UDFSpace.class, false);
        FunctionRegistry.registerUDF("repeat", UDFRepeat.class, false);
        FunctionRegistry.registerUDF("ascii", UDFAscii.class, false);
        FunctionRegistry.registerUDF("lpad", UDFLpad.class, false);
        FunctionRegistry.registerUDF("rpad", UDFRpad.class, false);
        FunctionRegistry.registerGenericUDF("size", GenericUDFSize.class);
        FunctionRegistry.registerUDF("round", UDFRound.class, false);
        FunctionRegistry.registerUDF("floor", UDFFloor.class, false);
        FunctionRegistry.registerUDF("sqrt", UDFSqrt.class, false);
        FunctionRegistry.registerUDF("ceil", UDFCeil.class, false);
        FunctionRegistry.registerUDF("ceiling", UDFCeil.class, false);
        FunctionRegistry.registerUDF("rand", UDFRand.class, false);
        FunctionRegistry.registerUDF("abs", UDFAbs.class, false);
        FunctionRegistry.registerUDF("pmod", UDFPosMod.class, false);
        FunctionRegistry.registerUDF("ln", UDFLn.class, false);
        FunctionRegistry.registerUDF("log2", UDFLog2.class, false);
        FunctionRegistry.registerUDF("sin", UDFSin.class, false);
        FunctionRegistry.registerUDF("asin", UDFAsin.class, false);
        FunctionRegistry.registerUDF("cos", UDFCos.class, false);
        FunctionRegistry.registerUDF("acos", UDFAcos.class, false);
        FunctionRegistry.registerUDF("log10", UDFLog10.class, false);
        FunctionRegistry.registerUDF("log", UDFLog.class, false);
        FunctionRegistry.registerUDF("exp", UDFExp.class, false);
        FunctionRegistry.registerUDF("power", UDFPower.class, false);
        FunctionRegistry.registerUDF("pow", UDFPower.class, false);
        FunctionRegistry.registerUDF("sign", UDFSign.class, false);
        FunctionRegistry.registerUDF("pi", UDFPI.class, false);
        FunctionRegistry.registerUDF("degrees", UDFDegrees.class, false);
        FunctionRegistry.registerUDF("radians", UDFRadians.class, false);
        FunctionRegistry.registerUDF("atan", UDFAtan.class, false);
        FunctionRegistry.registerUDF("tan", UDFTan.class, false);
        FunctionRegistry.registerUDF("e", UDFE.class, false);
        FunctionRegistry.registerUDF("conv", UDFConv.class, false);
        FunctionRegistry.registerUDF("bin", UDFBin.class, false);
        FunctionRegistry.registerUDF("hex", UDFHex.class, false);
        FunctionRegistry.registerUDF("unhex", UDFUnhex.class, false);
        FunctionRegistry.registerUDF("upper", UDFUpper.class, false);
        FunctionRegistry.registerUDF("lower", UDFLower.class, false);
        FunctionRegistry.registerUDF("ucase", UDFUpper.class, false);
        FunctionRegistry.registerUDF("lcase", UDFLower.class, false);
        FunctionRegistry.registerUDF("trim", UDFTrim.class, false);
        FunctionRegistry.registerUDF("ltrim", UDFLTrim.class, false);
        FunctionRegistry.registerUDF("rtrim", UDFRTrim.class, false);
        FunctionRegistry.registerUDF("length", UDFLength.class, false);
        FunctionRegistry.registerUDF("reverse", UDFReverse.class, false);
        FunctionRegistry.registerGenericUDF("field", GenericUDFField.class);
        FunctionRegistry.registerUDF("find_in_set", UDFFindInSet.class, false);
        FunctionRegistry.registerUDF("like", UDFLike.class, true);
        FunctionRegistry.registerUDF("rlike", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp_replace", UDFRegExpReplace.class, false);
        FunctionRegistry.registerUDF("regexp_extract", UDFRegExpExtract.class, false);
        FunctionRegistry.registerUDF("parse_url", UDFParseUrl.class, false);
        FunctionRegistry.registerGenericUDF("split", GenericUDFSplit.class);
        FunctionRegistry.registerGenericUDF("str_to_map", GenericUDFStringToMap.class);
        FunctionRegistry.registerGenericUDF("translate", GenericUDFTranslate.class);
        FunctionRegistry.registerUDF("positive", UDFOPPositive.class, true, "+");
        FunctionRegistry.registerUDF("negative", UDFOPNegative.class, true, "-");
        FunctionRegistry.registerUDF("day", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("dayofmonth", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("month", UDFMonth.class, false);
        FunctionRegistry.registerUDF("year", UDFYear.class, false);
        FunctionRegistry.registerUDF("hour", UDFHour.class, false);
        FunctionRegistry.registerUDF("minute", UDFMinute.class, false);
        FunctionRegistry.registerUDF("second", UDFSecond.class, false);
        FunctionRegistry.registerUDF("from_unixtime", UDFFromUnixTime.class, false);
        FunctionRegistry.registerUDF("unix_timestamp", UDFUnixTimeStamp.class, false);
        FunctionRegistry.registerUDF("to_date", UDFDate.class, false);
        FunctionRegistry.registerUDF("weekofyear", UDFWeekOfYear.class, false);
        FunctionRegistry.registerUDF("date_add", UDFDateAdd.class, false);
        FunctionRegistry.registerUDF("date_sub", UDFDateSub.class, false);
        FunctionRegistry.registerUDF("datediff", UDFDateDiff.class, false);
        FunctionRegistry.registerUDF("get_json_object", UDFJson.class, false);
        FunctionRegistry.registerUDF("xpath_string", UDFXPathString.class, false);
        FunctionRegistry.registerUDF("xpath_boolean", UDFXPathBoolean.class, false);
        FunctionRegistry.registerUDF("xpath_number", UDFXPathDouble.class, false);
        FunctionRegistry.registerUDF("xpath_double", UDFXPathDouble.class, false);
        FunctionRegistry.registerUDF("xpath_float", UDFXPathFloat.class, false);
        FunctionRegistry.registerUDF("xpath_long", UDFXPathLong.class, false);
        FunctionRegistry.registerUDF("xpath_int", UDFXPathInteger.class, false);
        FunctionRegistry.registerUDF("xpath_short", UDFXPathShort.class, false);
        FunctionRegistry.registerGenericUDF("xpath", GenericUDFXPath.class);
        FunctionRegistry.registerUDF("+", UDFOPPlus.class, true);
        FunctionRegistry.registerUDF("-", UDFOPMinus.class, true);
        FunctionRegistry.registerUDF("*", UDFOPMultiply.class, true);
        FunctionRegistry.registerUDF("/", UDFOPDivide.class, true);
        FunctionRegistry.registerUDF("%", UDFOPMod.class, true);
        FunctionRegistry.registerUDF("div", UDFOPLongDivide.class, true);
        FunctionRegistry.registerUDF("&", UDFOPBitAnd.class, true);
        FunctionRegistry.registerUDF("|", UDFOPBitOr.class, true);
        FunctionRegistry.registerUDF("^", UDFOPBitXor.class, true);
        FunctionRegistry.registerUDF("~", UDFOPBitNot.class, true);
        FunctionRegistry.registerGenericUDF("isnull", GenericUDFOPNull.class);
        FunctionRegistry.registerGenericUDF("isnotnull", GenericUDFOPNotNull.class);
        FunctionRegistry.registerGenericUDF("if", GenericUDFIf.class);
        FunctionRegistry.registerGenericUDF("in", GenericUDFIn.class);
        FunctionRegistry.registerGenericUDF("and", GenericUDFOPAnd.class);
        FunctionRegistry.registerGenericUDF("or", GenericUDFOPOr.class);
        FunctionRegistry.registerGenericUDF("=", GenericUDFOPEqual.class);
        FunctionRegistry.registerGenericUDF("==", GenericUDFOPEqual.class);
        FunctionRegistry.registerGenericUDF("<=>", GenericUDFOPEqualNS.class);
        FunctionRegistry.registerGenericUDF("!=", GenericUDFOPNotEqual.class);
        FunctionRegistry.registerGenericUDF("<>", GenericUDFOPNotEqual.class);
        FunctionRegistry.registerGenericUDF("<", GenericUDFOPLessThan.class);
        FunctionRegistry.registerGenericUDF("<=", GenericUDFOPEqualOrLessThan.class);
        FunctionRegistry.registerGenericUDF(">", GenericUDFOPGreaterThan.class);
        FunctionRegistry.registerGenericUDF(">=", GenericUDFOPEqualOrGreaterThan.class);
        FunctionRegistry.registerGenericUDF("not", GenericUDFOPNot.class);
        FunctionRegistry.registerGenericUDF("!", GenericUDFOPNot.class);
        FunctionRegistry.registerGenericUDF("between", GenericUDFBetween.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_and", GenericUDFEWAHBitmapAnd.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_or", GenericUDFEWAHBitmapOr.class);
        FunctionRegistry.registerGenericUDF("ewah_bitmap_empty", GenericUDFEWAHBitmapEmpty.class);
        FunctionRegistry.registerUDF("boolean", UDFToBoolean.class, false, UDFToBoolean.class.getSimpleName());
        FunctionRegistry.registerUDF("tinyint", UDFToByte.class, false, UDFToByte.class.getSimpleName());
        FunctionRegistry.registerUDF("smallint", UDFToShort.class, false, UDFToShort.class.getSimpleName());
        FunctionRegistry.registerUDF("int", UDFToInteger.class, false, UDFToInteger.class.getSimpleName());
        FunctionRegistry.registerUDF("bigint", UDFToLong.class, false, UDFToLong.class.getSimpleName());
        FunctionRegistry.registerUDF("float", UDFToFloat.class, false, UDFToFloat.class.getSimpleName());
        FunctionRegistry.registerUDF("double", UDFToDouble.class, false, UDFToDouble.class.getSimpleName());
        FunctionRegistry.registerUDF("string", UDFToString.class, false, UDFToString.class.getSimpleName());
        FunctionRegistry.registerGenericUDF("timestamp", GenericUDFTimestamp.class);
        FunctionRegistry.registerGenericUDF("binary", GenericUDFToBinary.class);
        FunctionRegistry.registerGenericUDAF("max", new GenericUDAFMax());
        FunctionRegistry.registerGenericUDAF("min", new GenericUDAFMin());
        FunctionRegistry.registerGenericUDAF("sum", new GenericUDAFSum());
        FunctionRegistry.registerGenericUDAF("count", new GenericUDAFCount());
        FunctionRegistry.registerGenericUDAF("avg", new GenericUDAFAverage());
        FunctionRegistry.registerGenericUDAF("std", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_pop", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_samp", new GenericUDAFStdSample());
        FunctionRegistry.registerGenericUDAF("variance", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_pop", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_samp", new GenericUDAFVarianceSample());
        FunctionRegistry.registerGenericUDAF("covar_pop", new GenericUDAFCovariance());
        FunctionRegistry.registerGenericUDAF("covar_samp", new GenericUDAFCovarianceSample());
        FunctionRegistry.registerGenericUDAF("corr", new GenericUDAFCorrelation());
        FunctionRegistry.registerGenericUDAF("histogram_numeric", new GenericUDAFHistogramNumeric());
        FunctionRegistry.registerGenericUDAF("percentile_approx", new GenericUDAFPercentileApprox());
        FunctionRegistry.registerGenericUDAF("collect_set", new GenericUDAFCollectSet());
        FunctionRegistry.registerGenericUDAF("ngrams", new GenericUDAFnGrams());
        FunctionRegistry.registerGenericUDAF("context_ngrams", new GenericUDAFContextNGrams());
        FunctionRegistry.registerGenericUDAF("ewah_bitmap", new GenericUDAFEWAHBitmap());
        FunctionRegistry.registerGenericUDAF("compute_stats", new GenericUDAFComputeStats());
        FunctionRegistry.registerUDAF("percentile", UDAFPercentile.class);
        FunctionRegistry.registerGenericUDF("reflect", GenericUDFReflect.class);
        FunctionRegistry.registerGenericUDF("java_method", GenericUDFReflect.class);
        FunctionRegistry.registerGenericUDF("array", GenericUDFArray.class);
        FunctionRegistry.registerGenericUDF("assert_true", GenericUDFAssertTrue.class);
        FunctionRegistry.registerGenericUDF("map", GenericUDFMap.class);
        FunctionRegistry.registerGenericUDF("struct", GenericUDFStruct.class);
        FunctionRegistry.registerGenericUDF("named_struct", GenericUDFNamedStruct.class);
        FunctionRegistry.registerGenericUDF("create_union", GenericUDFUnion.class);
        FunctionRegistry.registerGenericUDF("case", GenericUDFCase.class);
        FunctionRegistry.registerGenericUDF("when", GenericUDFWhen.class);
        FunctionRegistry.registerGenericUDF("hash", GenericUDFHash.class);
        FunctionRegistry.registerGenericUDF("coalesce", GenericUDFCoalesce.class);
        FunctionRegistry.registerGenericUDF("index", GenericUDFIndex.class);
        FunctionRegistry.registerGenericUDF("in_file", GenericUDFInFile.class);
        FunctionRegistry.registerGenericUDF("instr", GenericUDFInstr.class);
        FunctionRegistry.registerGenericUDF("locate", GenericUDFLocate.class);
        FunctionRegistry.registerGenericUDF("elt", GenericUDFElt.class);
        FunctionRegistry.registerGenericUDF("concat_ws", GenericUDFConcatWS.class);
        FunctionRegistry.registerGenericUDF("sort_array", GenericUDFSortArray.class);
        FunctionRegistry.registerGenericUDF("array_contains", GenericUDFArrayContains.class);
        FunctionRegistry.registerGenericUDF("sentences", GenericUDFSentences.class);
        FunctionRegistry.registerGenericUDF("map_keys", GenericUDFMapKeys.class);
        FunctionRegistry.registerGenericUDF("map_values", GenericUDFMapValues.class);
        FunctionRegistry.registerGenericUDF("format_number", GenericUDFFormatNumber.class);
        FunctionRegistry.registerGenericUDF("printf", GenericUDFPrintf.class);
        FunctionRegistry.registerGenericUDF("from_utc_timestamp", GenericUDFFromUtcTimestamp.class);
        FunctionRegistry.registerGenericUDF("to_utc_timestamp", GenericUDFToUtcTimestamp.class);
        FunctionRegistry.registerGenericUDTF("explode", GenericUDTFExplode.class);
        FunctionRegistry.registerGenericUDTF("inline", GenericUDTFInline.class);
        FunctionRegistry.registerGenericUDTF("json_tuple", GenericUDTFJSONTuple.class);
        FunctionRegistry.registerGenericUDTF("parse_url_tuple", GenericUDTFParseUrlTuple.class);
        FunctionRegistry.registerGenericUDTF("stack", GenericUDTFStack.class);
        numericTypes = new HashMap<TypeInfo, Integer>();
        numericTypeList = new ArrayList<TypeInfo>();
        FunctionRegistry.registerNumericType("tinyint", 1);
        FunctionRegistry.registerNumericType("smallint", 2);
        FunctionRegistry.registerNumericType("int", 3);
        FunctionRegistry.registerNumericType("bigint", 4);
        FunctionRegistry.registerNumericType("float", 5);
        FunctionRegistry.registerNumericType("double", 6);
        FunctionRegistry.registerNumericType("string", 7);
    }
}

