/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinDoubleKeys
extends AbstractMapJoinKey {
    protected transient Object obj1;
    protected transient Object obj2;

    public MapJoinDoubleKeys() {
    }

    public MapJoinDoubleKeys(Object obj1, Object obj2) {
        this.obj1 = obj1;
        this.obj2 = obj2;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MapJoinDoubleKeys) {
            MapJoinDoubleKeys mObj = (MapJoinDoubleKeys)o;
            Object key1 = mObj.getObj1();
            Object key2 = mObj.getObj2();
            if (this.obj1 == null && key1 == null && this.obj2 == null && key2 == null) {
                return true;
            }
            if (this.obj1 != null && key1 != null && this.obj1.equals(key1) && this.obj2 != null && key2 != null && this.obj2.equals(key2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = this.obj1 == null ? metadataTag : (hashCode += 31 + this.obj1.hashCode());
        hashCode = this.obj2 == null ? (hashCode += metadataTag) : (hashCode += 31 + this.obj2.hashCode());
        return hashCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinMetaData.get(metadataTag);
            Writable val = ctx.getSerDe().getSerializedClass().newInstance();
            val.readFields((DataInput)in);
            ArrayList list = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (list == null) {
                this.obj1 = null;
                this.obj2 = null;
            } else {
                this.obj1 = list.get(0);
                this.obj2 = list.get(1);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinMetaData.get(metadataTag);
            ArrayList<Object> list = MapJoinMetaData.getList();
            list.add(this.obj1);
            list.add(this.obj2);
            Writable outVal = ctx.getSerDe().serialize(list, ctx.getStandardOI());
            outVal.write((DataOutput)out);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public Object getObj1() {
        return this.obj1;
    }

    public void setObj1(Object obj1) {
        this.obj1 = obj1;
    }

    public Object getObj2() {
        return this.obj2;
    }

    public void setObj2(Object obj2) {
        this.obj2 = obj2;
    }

    @Override
    public boolean hasAnyNulls(boolean[] nullsafes) {
        if (!(this.obj1 != null || nullsafes != null && nullsafes[0])) {
            return true;
        }
        return this.obj2 == null && (nullsafes == null || !nullsafes[1]);
    }
}

