/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenMRRedSink3
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(ctx.getCurrUnionOp());
        Task<? extends Serializable> unionTask = null;
        unionTask = mapredCtx != null ? mapredCtx.getCurrTask() : ctx.getCurrTask();
        MapredWork plan = (MapredWork)unionTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        Task<? extends Serializable> reducerTask = opTaskMap.get(reducer);
        ctx.setCurrTask(unionTask);
        if (reducerTask == null) {
            if (plan.getReducer() == null) {
                GenMapRedUtils.initUnionPlan(op, ctx, unionTask);
            } else {
                GenMapRedUtils.splitPlan(op, ctx);
            }
        } else if (plan.getReducer() == reducer) {
            GenMapRedUtils.initUnionPlan(op, ctx, unionTask);
        } else {
            GenMapRedUtils.joinUnionPlan(ctx, unionTask, reducerTask, false);
            ctx.setCurrTask(reducerTask);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
        ctx.setCurrUnionOp(null);
        return null;
    }
}

