/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Utils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.lineage.ExprProcFactory;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class OpProcFactory {
    protected static Operator<? extends OperatorDesc> getParent(Stack<Node> stack) {
        return (Operator)Utils.getNthAncestor(stack, 1);
    }

    public static NodeProcessor getJoinProc() {
        return new JoinLineage();
    }

    public static NodeProcessor getLateralViewJoinProc() {
        return new LateralViewJoinLineage();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanLineage();
    }

    public static NodeProcessor getTransformProc() {
        return new TransformLineage();
    }

    public static NodeProcessor getSelProc() {
        return new SelectLineage();
    }

    public static NodeProcessor getGroupByProc() {
        return new GroupByLineage();
    }

    public static NodeProcessor getUnionProc() {
        return new UnionLineage();
    }

    public static NodeProcessor getReduceSinkProc() {
        return new ReduceSinkLineage();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultLineage();
    }

    public static class DefaultLineage
    implements NodeProcessor {
        protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            RowSchema rs = op.getSchema();
            ArrayList<ColumnInfo> inp_cols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                lCtx.getIndex().putDependency(op, ci, lCtx.getIndex().getDependency(inpOp, inp_cols.get(cnt++)));
            }
            return null;
        }
    }

    public static class ReduceSinkLineage
    implements NodeProcessor {
        protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            ArrayList<ColumnInfo> col_infos = rop.getSchema().getSignature();
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            int cnt = 0;
            Operator<OperatorDesc> op = rop.getChildOperators().get(0);
            while (op instanceof ForwardOperator) {
                op = op.getChildOperators().get(0);
            }
            if (op instanceof GroupByOperator) {
                for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getKeyCols()) {
                    lCtx.getIndex().putDependency(rop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr));
                }
            }
            for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getValueCols()) {
                lCtx.getIndex().putDependency(rop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr));
            }
            return null;
        }
    }

    public static class UnionLineage
    extends DefaultLineage
    implements NodeProcessor {
        protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            RowSchema rs = op.getSchema();
            ArrayList<ColumnInfo> inp_cols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                LineageInfo.Dependency inp_dep = lCtx.getIndex().getDependency(inpOp, inp_cols.get(cnt++));
                if (inp_dep == null) continue;
                lCtx.getIndex().mergeDependency(op, ci, inp_dep);
            }
            return null;
        }
    }

    public static class GroupByLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            GroupByOperator gop = (GroupByOperator)nd;
            ArrayList<ColumnInfo> col_infos = gop.getSchema().getSignature();
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            int cnt = 0;
            for (ExprNodeDesc expr : ((GroupByDesc)gop.getConf()).getKeys()) {
                lctx.getIndex().putDependency(gop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lctx, inpOp, expr));
            }
            for (AggregationDesc agg : ((GroupByDesc)gop.getConf()).getAggregators()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.DependencyType new_type = LineageInfo.DependencyType.EXPRESSION;
                dep.setExpr(null);
                LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
                for (ExprNodeDesc expr : agg.getParameters()) {
                    LineageInfo.Dependency expr_dep = ExprProcFactory.getExprDependency(lctx, inpOp, expr);
                    if (expr_dep == null) continue;
                    new_type = LineageCtx.getNewDependencyType(expr_dep.getType(), new_type);
                    bci_set.addAll(expr_dep.getBaseCols());
                }
                if (bci_set.isEmpty()) {
                    LinkedHashSet<LineageInfo.TableAliasInfo> tai_set = new LinkedHashSet<LineageInfo.TableAliasInfo>();
                    if (inpOp.getSchema() != null && inpOp.getSchema().getSignature() != null) {
                        for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                            LineageInfo.Dependency inp_dep = lctx.getIndex().getDependency(inpOp, ci);
                            if (inp_dep == null) continue;
                            for (LineageInfo.BaseColumnInfo bci : inp_dep.getBaseCols()) {
                                new_type = LineageCtx.getNewDependencyType(inp_dep.getType(), new_type);
                                tai_set.add(bci.getTabAlias());
                            }
                        }
                    }
                    for (LineageInfo.TableAliasInfo tai : tai_set) {
                        LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                        bci.setTabAlias(tai);
                        bci.setColumn(null);
                        bci_set.add(bci);
                    }
                }
                dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>(bci_set));
                dep.setType(new_type);
                lctx.getIndex().putDependency(gop, col_infos.get(cnt++), dep);
            }
            return null;
        }
    }

    public static class SelectLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            SelectOperator sop = (SelectOperator)nd;
            if (((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                return super.process(nd, stack, procCtx, nodeOutputs);
            }
            ArrayList<ColumnInfo> col_infos = sop.getSchema().getSignature();
            int cnt = 0;
            for (ExprNodeDesc expr : ((SelectDesc)sop.getConf()).getColList()) {
                lctx.getIndex().putDependency(sop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lctx, OpProcFactory.getParent(stack), expr));
            }
            return null;
        }
    }

    public static class LateralViewJoinLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            boolean isUdtfPath = true;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            ArrayList<ColumnInfo> cols = inpOp.getSchema().getSignature();
            if (inpOp instanceof SelectOperator) {
                isUdtfPath = false;
            }
            ArrayList<ColumnInfo> out_cols = op.getSchema().getSignature();
            int out_cols_size = out_cols.size();
            int cols_size = cols.size();
            if (isUdtfPath) {
                for (int cnt = 0; cnt < cols_size; ++cnt) {
                    lCtx.getIndex().mergeDependency(op, out_cols.get(cnt), lCtx.getIndex().getDependency(inpOp, cols.get(cnt)));
                }
            } else {
                for (int cnt = cols_size - 1; cnt >= 0; --cnt) {
                    lCtx.getIndex().mergeDependency(op, out_cols.get(out_cols_size - cols_size + cnt), lCtx.getIndex().getDependency(inpOp, cols.get(cnt)));
                }
            }
            return null;
        }
    }

    public static class JoinLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            JoinOperator op = (JoinOperator)nd;
            JoinDesc jd = (JoinDesc)op.getConf();
            ReduceSinkOperator inpOp = (ReduceSinkOperator)OpProcFactory.getParent(stack);
            ReduceSinkDesc rd = (ReduceSinkDesc)inpOp.getConf();
            int tag = rd.getTag();
            int cnt = 0;
            List<ExprNodeDesc> exprs = jd.getExprs().get((byte)tag);
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                if (jd.getReversedExprs().get(ci.getInternalName()) != tag) continue;
                ExprNodeDesc expr = exprs.get(cnt++);
                lCtx.getIndex().mergeDependency(op, ci, ExprProcFactory.getExprDependency(lCtx, inpOp, expr));
            }
            return null;
        }
    }

    public static class TableScanLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            ParseContext pctx = lCtx.getParseCtx();
            TableScanOperator top = (TableScanOperator)nd;
            Table t = pctx.getTopToTable().get(top);
            org.apache.hadoop.hive.metastore.api.Table tab = t.getTTable();
            RowSchema rs = top.getSchema();
            List<FieldSchema> cols = t.getAllCols();
            HashMap<String, FieldSchema> fieldSchemaMap = new HashMap<String, FieldSchema>();
            for (FieldSchema col : cols) {
                fieldSchemaMap.put(col.getName(), col);
            }
            for (VirtualColumn vc : VirtualColumn.getRegistry(pctx.getConf())) {
                fieldSchemaMap.put(vc.getName(), new FieldSchema(vc.getName(), vc.getTypeInfo().getTypeName(), ""));
            }
            LineageInfo.TableAliasInfo tai = new LineageInfo.TableAliasInfo();
            tai.setAlias(((TableScanDesc)top.getConf()).getAlias());
            tai.setTable(tab);
            for (ColumnInfo ci : rs.getSignature()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                bci.setTabAlias(tai);
                bci.setColumn((FieldSchema)fieldSchemaMap.get(ci.getInternalName()));
                dep.setType(LineageInfo.DependencyType.SIMPLE);
                dep.setExpr(null);
                dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>());
                dep.getBaseCols().add(bci);
                lCtx.getIndex().putDependency(top, ci, dep);
            }
            return null;
        }
    }

    public static class TransformLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LineageInfo.DependencyType new_type = LineageInfo.DependencyType.SCRIPT;
            dep.setType(LineageInfo.DependencyType.SCRIPT);
            dep.setExpr(null);
            LinkedHashSet<LineageInfo.BaseColumnInfo> col_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                LineageInfo.Dependency d = lCtx.getIndex().getDependency(inpOp, ci);
                if (d == null) continue;
                new_type = LineageCtx.getNewDependencyType(d.getType(), new_type);
                col_set.addAll(d.getBaseCols());
            }
            dep.setType(new_type);
            dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>(col_set));
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                lCtx.getIndex().putDependency(op, ci, dep);
            }
            return null;
        }
    }
}

