/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;

public class ImportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private boolean tableExists = false;

    public ImportSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    public boolean existsTable() {
        return this.tableExists;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        try {
            Tree fromTree = ast.getChild(0);
            String tmpPath = ImportSemanticAnalyzer.stripQuotes(fromTree.getText());
            URI fromURI = EximUtil.getValidatedURI(this.conf, tmpPath);
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)this.conf);
            String dbname = null;
            CreateTableDesc tblDesc = null;
            ArrayList<AddPartitionDesc> partitionDescs = new ArrayList<AddPartitionDesc>();
            Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
            try {
                Path metadataPath = new Path(fromPath, "_metadata");
                Map.Entry<org.apache.hadoop.hive.metastore.api.Table, List<Partition>> rv = EximUtil.readMetaData(fs, metadataPath);
                dbname = this.db.getCurrentDatabase();
                org.apache.hadoop.hive.metastore.api.Table table = rv.getKey();
                tblDesc = new CreateTableDesc(table.getTableName(), false, table.getSd().getCols(), table.getPartitionKeys(), table.getSd().getBucketCols(), table.getSd().getSortCols(), table.getSd().getNumBuckets(), null, null, null, null, null, null, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), null, table.getSd().getSerdeInfo().getSerializationLib(), null, table.getSd().getSerdeInfo().getParameters(), table.getParameters(), false, null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColNames(), null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColValues());
                tblDesc.setStoredAsSubDirectories(table.getSd().isStoredAsSubDirectories());
                ArrayList<FieldSchema> partCols = tblDesc.getPartCols();
                ArrayList<String> partColNames = new ArrayList<String>(partCols.size());
                for (FieldSchema fsc : partCols) {
                    partColNames.add(fsc.getName());
                }
                List<Partition> partitions = rv.getValue();
                for (Partition partition : partitions) {
                    AddPartitionDesc partDesc = new AddPartitionDesc(dbname, tblDesc.getTableName(), EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues()), partition.getSd().getLocation(), partition.getParameters());
                    partDesc.setInputFormat(partition.getSd().getInputFormat());
                    partDesc.setOutputFormat(partition.getSd().getOutputFormat());
                    partDesc.setNumBuckets(partition.getSd().getNumBuckets());
                    partDesc.setCols(partition.getSd().getCols());
                    partDesc.setSerializationLib(partition.getSd().getSerdeInfo().getSerializationLib());
                    partDesc.setSerdeParams(partition.getSd().getSerdeInfo().getParameters());
                    partDesc.setBucketCols(partition.getSd().getBucketCols());
                    partDesc.setSortCols(partition.getSd().getSortCols());
                    partDesc.setLocation(new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), (List)partition.getValues())).toString());
                    partitionDescs.add(partDesc);
                }
            }
            catch (IOException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
            this.LOG.debug((Object)"metadata read and parsed");
            block14: for (int i = 1; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                switch (child.getToken().getType()) {
                    case 268: {
                        tblDesc.setExternal(true);
                        continue block14;
                    }
                    case 161: {
                        String location = ImportSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                        location = EximUtil.relativeToAbsolutePath(this.conf, location);
                        tblDesc.setLocation(location);
                        continue block14;
                    }
                    case 10: {
                        Tree tableTree = child.getChild(0);
                        String tableName = ImportSemanticAnalyzer.getUnescapedName((ASTNode)tableTree);
                        tblDesc.setTableName(tableName);
                        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                        if (child.getChildCount() != 2) continue block14;
                        ASTNode partspec = (ASTNode)child.getChild(1);
                        for (int j = 0; j < partspec.getChildCount(); ++j) {
                            ASTNode partspec_val = (ASTNode)partspec.getChild(j);
                            String val = null;
                            String colName = ImportSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                            if (partspec_val.getChildCount() < 2) {
                                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                            }
                            val = ImportSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                            partSpec.put(colName, val);
                        }
                        boolean found = false;
                        ListIterator partnIter = partitionDescs.listIterator();
                        while (partnIter.hasNext()) {
                            AddPartitionDesc addPartitionDesc = (AddPartitionDesc)partnIter.next();
                            if (!found && addPartitionDesc.getPartSpec().equals(partSpec)) {
                                found = true;
                                continue;
                            }
                            partnIter.remove();
                        }
                        if (found) continue block14;
                        throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Specified partition not found in import directory"));
                    }
                }
            }
            if (tblDesc.getTableName() == null) {
                throw new SemanticException(ErrorMsg.NEED_TABLE_SPECIFICATION.getMsg());
            }
            this.conf.set("import.destination.table", tblDesc.getTableName());
            for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                addPartitionDesc.setTableName(tblDesc.getTableName());
            }
            Warehouse wh = new Warehouse((Configuration)this.conf);
            try {
                Table table = this.db.getTable(tblDesc.getTableName());
                ImportSemanticAnalyzer.checkTable(table, tblDesc);
                this.LOG.debug((Object)("table " + tblDesc.getTableName() + " exists: metadata checked"));
                this.tableExists = true;
                this.conf.set("import.destination.dir", table.getDataLocation().toString());
                if (table.isPartitioned()) {
                    this.LOG.debug((Object)"table partitioned");
                    for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                        if (this.db.getPartition(table, addPartitionDesc.getPartSpec(), false) == null) {
                            this.rootTasks.add(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc));
                            continue;
                        }
                        throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(ImportSemanticAnalyzer.partSpecToString(addPartitionDesc.getPartSpec())));
                    }
                } else {
                    this.LOG.debug((Object)"table non-partitioned");
                    this.checkTargetLocationEmpty(fs, new Path(table.getDataLocation().toString()));
                    this.loadTable(fromURI, table);
                }
                this.outputs.add(new WriteEntity(table));
            }
            catch (InvalidTableException e) {
                this.LOG.debug((Object)("table " + tblDesc.getTableName() + " does not exist"));
                Task<DDLWork> t = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), tblDesc), this.conf, new Task[0]);
                Table table = new Table(dbname, tblDesc.getTableName());
                this.conf.set("import.destination.dir", wh.getTablePath(this.db.getDatabase(this.db.getCurrentDatabase()), tblDesc.getTableName()).toString());
                if (tblDesc.getPartCols() != null && tblDesc.getPartCols().size() != 0) {
                    for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                        t.addDependentTask(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc));
                    }
                } else {
                    this.LOG.debug((Object)"adding dependent CopyWork/MoveWork for table");
                    if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
                        this.LOG.debug((Object)"Importing in place, no emptiness check, no copying/loading");
                        Path dataPath = new Path(fromURI.toString(), "data");
                        tblDesc.setLocation(dataPath.toString());
                    } else {
                        Path tablePath = null;
                        tablePath = tblDesc.getLocation() != null ? new Path(tblDesc.getLocation()) : wh.getTablePath(this.db.getDatabase(this.db.getCurrentDatabase()), tblDesc.getTableName());
                        this.checkTargetLocationEmpty(fs, tablePath);
                        t.addDependentTask(this.loadTable(fromURI, table));
                    }
                }
                this.rootTasks.add(t);
            }
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg(), e);
        }
    }

    private Task<?> loadTable(URI fromURI, Table table) {
        Path dataPath = new Path(fromURI.toString(), "data");
        String tmpURI = this.ctx.getExternalTmpFileURI(fromURI);
        Task<CopyWork> copyTask = TaskFactory.get(new CopyWork(dataPath.toString(), tmpURI, false), this.conf, new Task[0]);
        LoadTableDesc loadTableWork = new LoadTableDesc(tmpURI.toString(), this.ctx.getExternalTmpFileURI(fromURI), Utilities.getTableDesc(table), new TreeMap<String, String>(), false);
        Task<MoveWork> loadTableTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, false), this.conf, new Task[0]);
        copyTask.addDependentTask(loadTableTask);
        this.rootTasks.add(copyTask);
        return loadTableTask;
    }

    private Task<?> addSinglePartition(URI fromURI, FileSystem fs, CreateTableDesc tblDesc, Table table, Warehouse wh, AddPartitionDesc addPartitionDesc) throws MetaException, IOException, HiveException {
        if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
            this.LOG.debug((Object)("Importing in-place: adding AddPart for partition " + ImportSemanticAnalyzer.partSpecToString(addPartitionDesc.getPartSpec())));
            Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]);
            return addPartTask;
        }
        String srcLocation = addPartitionDesc.getLocation();
        Path tgtPath = null;
        tgtPath = tblDesc.getLocation() == null ? (table.getDataLocation() != null ? new Path(table.getDataLocation().toString(), Warehouse.makePartPath(addPartitionDesc.getPartSpec())) : new Path(wh.getTablePath(this.db.getDatabase(this.db.getCurrentDatabase()), tblDesc.getTableName()), Warehouse.makePartPath(addPartitionDesc.getPartSpec()))) : new Path(tblDesc.getLocation(), Warehouse.makePartPath(addPartitionDesc.getPartSpec()));
        this.checkTargetLocationEmpty(fs, tgtPath);
        addPartitionDesc.setLocation(tgtPath.toString());
        this.LOG.debug((Object)("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(addPartitionDesc.getPartSpec()) + " with source location: " + srcLocation));
        String tmpURI = this.ctx.getExternalTmpFileURI(fromURI);
        Task<CopyWork> copyTask = TaskFactory.get(new CopyWork(srcLocation, tmpURI, false), this.conf, new Task[0]);
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]);
        LoadTableDesc loadTableWork = new LoadTableDesc(tmpURI, this.ctx.getExternalTmpFileURI(fromURI), Utilities.getTableDesc(table), addPartitionDesc.getPartSpec(), true);
        loadTableWork.setInheritTableSpecs(false);
        Task<MoveWork> loadPartTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, false), this.conf, new Task[0]);
        copyTask.addDependentTask(loadPartTask);
        addPartTask.addDependentTask(loadPartTask);
        this.rootTasks.add(copyTask);
        return addPartTask;
    }

    private void checkTargetLocationEmpty(FileSystem fs, Path targetPath) throws IOException, SemanticException {
        FileStatus[] status;
        this.LOG.debug((Object)("checking emptiness of " + targetPath.toString()));
        if (fs.exists(targetPath) && (status = fs.listStatus(targetPath)).length > 0) {
            this.LOG.debug((Object)("Files inc. " + status[0].getPath().toString() + " found in path : " + targetPath.toString()));
            throw new SemanticException(ErrorMsg.TABLE_DATA_EXISTS.getMsg());
        }
    }

    private static String partSpecToString(Map<String, String> partSpec) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            if (!firstTime) {
                sb.append(',');
            }
            firstTime = false;
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static void checkTable(Table table, CreateTableDesc tableDesc) throws SemanticException, URISyntaxException {
        String importedSerdeFormat;
        String importedSerde;
        Map<String, String> importedTableParams;
        EximUtil.validateTable(table);
        if (!table.isPartitioned() ? tableDesc.isExternal() : tableDesc.isExternal() && !table.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" External table cannot overwrite existing table. Drop existing table first."));
        }
        if (!table.isPartitioned() && tableDesc.getLocation() != null && !table.getDataLocation().equals(new URI(tableDesc.getLocation()))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Location does not match"));
        }
        List<FieldSchema> existingTableCols = table.getCols();
        ArrayList<FieldSchema> importedTableCols = tableDesc.getCols();
        if (!EximUtil.schemaCompare(importedTableCols, existingTableCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Column Schema does not match"));
        }
        List<FieldSchema> existingTablePartCols = table.getPartCols();
        ArrayList<FieldSchema> importedTablePartCols = tableDesc.getPartCols();
        if (!EximUtil.schemaCompare(importedTablePartCols, existingTablePartCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Partition Schema does not match"));
        }
        Map<String, String> existingTableParams = table.getParameters();
        String error = ImportSemanticAnalyzer.checkParams(existingTableParams, importedTableParams = tableDesc.getTblProps(), new String[]{"howl.isd", "howl.osd"});
        if (error != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table parameters do not match: " + error));
        }
        String existingifc = table.getInputFormatClass().getName();
        String importedifc = tableDesc.getInputFormat();
        String existingofc = table.getOutputFormatClass().getName();
        String importedofc = tableDesc.getOutputFormat();
        if (!existingifc.equals(importedifc) || !existingofc.equals(importedofc)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table inputformat/outputformats do not match"));
        }
        String existingSerde = table.getSerializationLib();
        if (!existingSerde.equals(importedSerde = tableDesc.getSerName())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde class does not match"));
        }
        String existingSerdeFormat = table.getSerdeParam("serialization.format");
        if (!ObjectUtils.equals((Object)existingSerdeFormat, (Object)(importedSerdeFormat = tableDesc.getSerdeProps().get("serialization.format")))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde format does not match"));
        }
        if (!ObjectUtils.equals(table.getBucketCols(), tableDesc.getBucketCols())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table bucketing spec does not match"));
        }
        List<Order> existingOrder = table.getSortCols();
        ArrayList<Order> importedOrder = tableDesc.getSortCols();
        if (existingOrder != null) {
            if (importedOrder != null) {
                final class OrderComparator
                implements Comparator<Order> {
                    OrderComparator() {
                    }

                    @Override
                    public int compare(Order o1, Order o2) {
                        if (o1.getOrder() < o2.getOrder()) {
                            return -1;
                        }
                        if (o1.getOrder() == o2.getOrder()) {
                            return 0;
                        }
                        return 1;
                    }
                }
                Collections.sort(existingOrder, new OrderComparator());
                Collections.sort(importedOrder, new OrderComparator());
                if (!((Object)existingOrder).equals(importedOrder)) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
                }
            }
        } else if (importedOrder != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
        }
    }

    private static String checkParams(Map<String, String> map1, Map<String, String> map2, String[] keys) {
        block6: {
            block5: {
                if (map1 == null) break block5;
                if (map2 != null) {
                    for (String key : keys) {
                        String v2;
                        String v1 = map1.get(key);
                        if (ObjectUtils.equals((Object)v1, (Object)(v2 = map2.get(key)))) continue;
                        return "Mismatch for " + key;
                    }
                } else {
                    for (String key : keys) {
                        if (map1.get(key) == null) continue;
                        return "Mismatch for " + key;
                    }
                }
                break block6;
            }
            if (map2 == null) break block6;
            for (String key : keys) {
                if (map2.get(key) == null) continue;
                return "Mismatch for " + key;
            }
        }
        return null;
    }
}

