/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 179: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 69: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 70: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 71: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 92: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 159: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 233: 
            case 237: 
            case 247: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 101: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 170: 
            case 171: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 204: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(179, HiveOperation.EXPLAIN);
        commandType.put(69, HiveOperation.LOAD);
        commandType.put(70, HiveOperation.EXPORT);
        commandType.put(71, HiveOperation.IMPORT);
        commandType.put(92, HiveOperation.CREATEDATABASE);
        commandType.put(135, HiveOperation.DROPDATABASE);
        commandType.put(134, HiveOperation.SWITCHDATABASE);
        commandType.put(93, HiveOperation.CREATETABLE);
        commandType.put(136, HiveOperation.DROPTABLE);
        commandType.put(99, HiveOperation.DESCTABLE);
        commandType.put(100, HiveOperation.DESCFUNCTION);
        commandType.put(122, HiveOperation.MSCK);
        commandType.put(103, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(106, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(104, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(102, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(108, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(107, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(110, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(111, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(112, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(118, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(159, HiveOperation.ALTERTABLE_CLUSTER_SORT);
        commandType.put(123, HiveOperation.SHOWDATABASES);
        commandType.put(124, HiveOperation.SHOWTABLES);
        commandType.put(125, HiveOperation.SHOWCOLUMNS);
        commandType.put(129, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(130, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(128, HiveOperation.SHOW_CREATETABLE);
        commandType.put(126, HiveOperation.SHOWFUNCTIONS);
        commandType.put(231, HiveOperation.SHOWINDEXES);
        commandType.put(127, HiveOperation.SHOWPARTITIONS);
        commandType.put(131, HiveOperation.SHOWLOCKS);
        commandType.put(170, HiveOperation.CREATEFUNCTION);
        commandType.put(171, HiveOperation.DROPFUNCTION);
        commandType.put(172, HiveOperation.CREATEVIEW);
        commandType.put(173, HiveOperation.DROPVIEW);
        commandType.put(94, HiveOperation.CREATEINDEX);
        commandType.put(97, HiveOperation.DROPINDEX);
        commandType.put(120, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(121, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(174, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(175, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(176, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(5, HiveOperation.QUERY);
        commandType.put(132, HiveOperation.LOCKTABLE);
        commandType.put(133, HiveOperation.UNLOCKTABLE);
        commandType.put(205, HiveOperation.CREATEROLE);
        commandType.put(206, HiveOperation.DROPROLE);
        commandType.put(207, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(208, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(209, HiveOperation.SHOW_GRANT);
        commandType.put(228, HiveOperation.GRANT_ROLE);
        commandType.put(229, HiveOperation.REVOKE_ROLE);
        commandType.put(230, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(237, HiveOperation.ALTERDATABASE);
        commandType.put(233, HiveOperation.DESCDATABASE);
        commandType.put(247, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(204, HiveOperation.ANALYZE_TABLE);
        tablePartitionCommandType.put(109, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(116, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(117, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(238, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(114, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(113, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(105, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(248, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
    }
}

