/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="concat", value="_FUNC_(str1, str2, ... strN) - returns the concatenation of str1, str2, ... strN or _FUNC_(bin1, bin2, ... binN) - returns the concatenation of bytes in binary data  bin1, bin2, ... binN", extended="Returns NULL if any argument is NULL.\nExample:\n  > SELECT _FUNC_('abc', 'def') FROM src LIMIT 1;\n  'abcdef'")
public class UDFConcat
extends UDF {
    private final Text text = new Text();

    public Text evaluate(Text ... args) {
        this.text.clear();
        for (Text arg : args) {
            if (arg == null) {
                return null;
            }
            this.text.append(arg.getBytes(), 0, arg.getLength());
        }
        return this.text;
    }

    public BytesWritable evaluate(BytesWritable ... bw) {
        int len = 0;
        for (BytesWritable bytes : bw) {
            if (bytes == null) {
                return null;
            }
            len += bytes.getLength();
        }
        byte[] out = new byte[len];
        int curLen = 0;
        for (BytesWritable bytes : bw) {
            System.arraycopy(bytes.getBytes(), 0, out, curLen, bytes.getLength());
            curLen += bytes.getLength();
        }
        return new BytesWritable(out);
    }
}

