/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="substr,substring", value="_FUNC_(str, pos[, len]) - returns the substring of str that starts at pos and is of length len or_FUNC_(bin, pos[, len]) - returns the slice of byte array that starts at pos and is of length len", extended="pos is a 1-based index. If pos<0 the starting position is determined by counting backwards from the end of str.\nExample:\n   > SELECT _FUNC_('Facebook', 5) FROM src LIMIT 1;\n  'book'\n  > SELECT _FUNC_('Facebook', -5) FROM src LIMIT 1;\n  'ebook'\n  > SELECT _FUNC_('Facebook', 5, 1) FROM src LIMIT 1;\n  'b'")
public class UDFSubstr
extends UDF {
    private final int[] index;
    private final Text r;
    private final IntWritable maxValue = new IntWritable(Integer.MAX_VALUE);

    public UDFSubstr() {
        this.index = new int[2];
        this.r = new Text();
    }

    public Text evaluate(Text t, IntWritable pos, IntWritable len) {
        if (t == null || pos == null || len == null) {
            return null;
        }
        this.r.clear();
        if (len.get() <= 0) {
            return this.r;
        }
        String s = t.toString();
        int[] index = this.makeIndex(pos.get(), len.get(), s.length());
        if (index == null) {
            return this.r;
        }
        this.r.set(s.substring(index[0], index[1]));
        return this.r;
    }

    private int[] makeIndex(int pos, int len, int inputLen) {
        if (Math.abs(pos) > inputLen) {
            return null;
        }
        int start = pos > 0 ? pos - 1 : (pos < 0 ? inputLen + pos : 0);
        int end = inputLen - start < len ? inputLen : start + len;
        this.index[0] = start;
        this.index[1] = end;
        return this.index;
    }

    public Text evaluate(Text s, IntWritable pos) {
        return this.evaluate(s, pos, this.maxValue);
    }

    public BytesWritable evaluate(BytesWritable bw, IntWritable pos, IntWritable len) {
        if (bw == null || pos == null || len == null) {
            return null;
        }
        if (len.get() <= 0) {
            return new BytesWritable();
        }
        int[] index = this.makeIndex(pos.get(), len.get(), bw.getLength());
        if (index == null) {
            return new BytesWritable();
        }
        return new BytesWritable(Arrays.copyOfRange(bw.getBytes(), index[0], index[1]));
    }

    public BytesWritable evaluate(BytesWritable bw, IntWritable pos) {
        return this.evaluate(bw, pos, this.maxValue);
    }
}

