/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

public class GenericUDFFromUtcTimestamp
extends GenericUDF {
    static final Log LOG = LogFactory.getLog(GenericUDFFromUtcTimestamp.class);
    private PrimitiveObjectInspector[] argumentOIs;
    private PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private PrimitiveObjectInspectorConverter.TextConverter textConverter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function " + this.getName() + " requires at least two " + "argument, got " + arguments.length);
        }
        try {
            this.argumentOIs = new PrimitiveObjectInspector[2];
            this.argumentOIs[0] = (PrimitiveObjectInspector)arguments[0];
            if (arguments.length > 1) {
                this.argumentOIs[1] = (PrimitiveObjectInspector)arguments[1];
            }
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function " + this.getName() + " takes only primitive types");
        }
        this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOIs[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
        this.textConverter = new PrimitiveObjectInspectorConverter.TextConverter(this.argumentOIs[1]);
        return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        TimeZone timezone = null;
        if (o0 == null) {
            return null;
        }
        if (arguments.length > 1 && arguments[1] != null) {
            Text text = this.textConverter.convert(arguments[1].get());
            if (text != null) {
                timezone = TimeZone.getTimeZone(text.toString());
            }
        } else {
            return null;
        }
        Timestamp timestamp = ((TimestampWritable)this.timestampConverter.convert(o0)).getTimestamp();
        int offset = timezone.getOffset(timestamp.getTime());
        if (this.invert()) {
            offset = -offset;
        }
        return this.applyOffset(offset, timestamp);
    }

    protected Timestamp applyOffset(long offset, Timestamp t) {
        long newTime = t.getTime() + offset;
        Timestamp t2 = new Timestamp(newTime);
        t2.setNanos(t.getNanos());
        return t2;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("Converting field ");
        sb.append(children[0]);
        sb.append(" from UTC to timezone: ");
        if (children.length > 1) {
            sb.append(children[1]);
        }
        return sb.toString();
    }

    public String getName() {
        return "from_utc_timestamp";
    }

    protected boolean invert() {
        return false;
    }
}

