/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.hive.ql.exec.HashForGroup;
import org.apache.hadoop.hive.ql.exec.HashForLimit0;
import org.apache.hadoop.hive.ql.exec.HashForRow;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.OutputCollector;

abstract class TopNHash {
    protected static final int FORWARD = -1;
    protected static final int EXCLUDED = -2;
    protected static final int FLUSH = -3;
    protected static final int DISABLE = -4;
    protected final int topN;
    protected final BinaryCollector collector;
    protected final long threshold;
    protected long usage;
    protected final byte[][] keys;
    protected final byte[][] values;
    protected final int[] hashes;
    protected int evicted;
    protected int excluded;
    protected final Comparator<Integer> C = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            byte[] key1 = TopNHash.this.keys[o1];
            byte[] key2 = TopNHash.this.keys[o2];
            return WritableComparator.compareBytes((byte[])key1, (int)0, (int)key1.length, (byte[])key2, (int)0, (int)key2.length);
        }
    };

    public static TopNHash create0() {
        return new HashForLimit0();
    }

    public static TopNHash create(boolean grouped, int topN, long threshold, BinaryCollector collector) {
        if (topN == 0) {
            return new HashForLimit0();
        }
        if (grouped) {
            return new HashForGroup(topN, threshold, collector);
        }
        return new HashForRow(topN, threshold, collector);
    }

    TopNHash(int topN, long threshold, BinaryCollector collector) {
        this.topN = topN;
        this.threshold = threshold;
        this.collector = collector;
        this.keys = new byte[topN + 1][];
        this.values = new byte[topN + 1][];
        this.hashes = new int[topN + 1];
        this.evicted = topN;
    }

    public int indexOf(HiveKey key) {
        int size = this.size();
        if (this.usage > this.threshold) {
            return this.excluded == 0 ? -4 : -3;
        }
        int index = size < this.topN ? size : this.evicted;
        this.keys[index] = Arrays.copyOf(key.getBytes(), key.getLength());
        this.hashes[index] = key.hashCode();
        if (!this.store(index)) {
            return -1;
        }
        if (size == this.topN) {
            this.evicted = this.removeBiggest();
            if (index == this.evicted) {
                ++this.excluded;
                return -2;
            }
            this.removed(this.evicted);
        }
        return index;
    }

    protected abstract int size();

    protected abstract boolean store(int var1);

    protected abstract int removeBiggest();

    protected abstract Iterable<Integer> indexes();

    public void removed(int index) {
        this.usage -= (long)this.keys[index].length;
        this.keys[index] = null;
        if (this.values[index] != null) {
            this.usage -= (long)this.values[index].length;
            this.values[index] = null;
        }
        this.hashes[index] = -1;
    }

    public void set(int index, BytesWritable value) {
        this.values[index] = Arrays.copyOf(value.getBytes(), value.getLength());
        this.usage += (long)(this.keys[index].length + this.values[index].length);
    }

    public void flush() throws IOException {
        for (int index : this.indexes()) {
            this.flush(index);
        }
        this.excluded = 0;
    }

    protected void flush(int index) throws IOException {
        if (index != this.evicted && this.values[index] != null) {
            HiveKey keyWritable = new HiveKey(this.keys[index], this.hashes[index]);
            BytesWritable valueWritable = new BytesWritable(this.values[index]);
            this.collector.collect((Object)keyWritable, valueWritable);
            this.usage -= (long)this.values[index].length;
            this.values[index] = null;
        }
    }

    public static interface BinaryCollector
    extends OutputCollector<BytesWritable, BytesWritable> {
    }
}

