/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class OneNullRowInputFormat
implements InputFormat<NullWritable, NullWritable>,
JobConfigurable {
    private static final Log LOG = LogFactory.getLog((String)OneNullRowInputFormat.class.getName());
    MapredWork mrwork = null;
    List<String> partitions;
    long len;

    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit arg0, JobConf arg1, Reporter arg2) throws IOException {
        return new OneNullRowRecordReader();
    }

    public InputSplit[] getSplits(JobConf arg0, int arg1) throws IOException {
        InputSplit[] ret = new InputSplit[]{new DummyInputSplit()};
        LOG.info((Object)"Calculating splits");
        return ret;
    }

    public void configure(JobConf job) {
        LOG.info((Object)"Using one null row input format");
    }

    public static class OneNullRowRecordReader
    implements RecordReader<NullWritable, NullWritable> {
        private boolean processed = false;

        public void close() throws IOException {
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public NullWritable createValue() {
            return NullWritable.get();
        }

        public long getPos() throws IOException {
            return this.processed ? 1 : 0;
        }

        public float getProgress() throws IOException {
            return (float)(this.processed ? 1.0 : 0.0);
        }

        public boolean next(NullWritable arg0, NullWritable arg1) throws IOException {
            if (this.processed) {
                return false;
            }
            this.processed = true;
            return true;
        }
    }

    public static class DummyInputSplit
    implements InputSplit {
        public long getLength() throws IOException {
            return 1L;
        }

        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public void readFields(DataInput arg0) throws IOException {
        }

        public void write(DataOutput arg0) throws IOException {
        }
    }
}

