/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="coalesce", value="_FUNC_(a1, a2, ...) - Returns the first non-null argument", extended="Example:\n  > SELECT _FUNC_(NULL, 1, NULL) FROM src LIMIT 1;\n  1")
public class GenericUDFCoalesce
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        this.argumentOIs = arguments;
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (int i = 0; i < arguments.length; ++i) {
            if (this.returnOIResolver.update(arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "The expressions after COALESCE should all have the same type: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i].getTypeName() + "\" is found");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 0; i < arguments.length; ++i) {
            Object ai = arguments[i].get();
            if (ai == null) continue;
            return this.returnOIResolver.convertIfNecessary(ai, this.argumentOIs[i]);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("COALESCE(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(",");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

