/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String internalName;
    private String alias = null;
    private boolean isSkewedCol;
    private String tabAlias;
    private boolean isVirtualCol;
    private ObjectInspector objectInspector;
    private boolean isHiddenVirtualCol;
    private String typeName;

    public ColumnInfo() {
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol) {
        this(internalName, type, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, Class type, String tabAlias, boolean isVirtualCol) {
        this(internalName, TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(type), tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this(internalName, TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(type), tabAlias, isVirtualCol, isHiddenVirtualCol);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, String tabAlias, boolean isVirtualCol) {
        this(internalName, objectInspector, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this.internalName = internalName;
        this.objectInspector = objectInspector;
        this.tabAlias = tabAlias;
        this.isVirtualCol = isVirtualCol;
        this.isHiddenVirtualCol = isHiddenVirtualCol;
        this.typeName = this.getType().getTypeName();
    }

    public ColumnInfo(ColumnInfo columnInfo) {
        this.internalName = columnInfo.getInternalName();
        this.alias = columnInfo.getAlias();
        this.isSkewedCol = columnInfo.isSkewedCol();
        this.tabAlias = columnInfo.getTabAlias();
        this.isVirtualCol = columnInfo.getIsVirtualCol();
        this.isHiddenVirtualCol = columnInfo.isHiddenVirtualCol();
        this.setType(columnInfo.getType());
        this.typeName = columnInfo.getType().getTypeName();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public TypeInfo getType() {
        return TypeInfoUtils.getTypeInfoFromObjectInspector(this.objectInspector);
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setType(TypeInfo type) {
        this.objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(type);
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public boolean getIsVirtualCol() {
        return this.isVirtualCol;
    }

    public boolean isHiddenVirtualCol() {
        return this.isHiddenVirtualCol;
    }

    public String toString() {
        return this.internalName + ": " + this.objectInspector.getTypeName();
    }

    public void setAlias(String col_alias) {
        this.alias = col_alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public void setVirtualCol(boolean isVirtualCol) {
        this.isVirtualCol = isVirtualCol;
    }

    public void setHiddenVirtualCol(boolean isHiddenVirtualCol) {
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }

    public boolean isSkewedCol() {
        return this.isSkewedCol;
    }

    public void setSkewedCol(boolean isSkewedCol) {
        this.isSkewedCol = isSkewedCol;
    }

    private boolean checkEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        return this.internalName.hashCode() + this.typeName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnInfo) || obj == null) {
            return false;
        }
        ColumnInfo dest = (ColumnInfo)obj;
        return this.checkEquals(this.internalName, dest.getInternalName()) && this.checkEquals(this.alias, dest.getAlias()) && this.checkEquals(this.getType(), dest.getType()) && this.isSkewedCol == dest.isSkewedCol() && this.isVirtualCol == dest.getIsVirtualCol() && this.isHiddenVirtualCol == dest.isHiddenVirtualCol();
    }

    public boolean isSameColumnForRR(ColumnInfo other) {
        return this.checkEquals(this.tabAlias, other.tabAlias) && this.checkEquals(this.alias, other.alias) && this.checkEquals(this.internalName, other.internalName) && this.checkEquals(this.getType(), other.getType());
    }

    public String toMappingString(String tab, String col) {
        return tab + "." + col + " => {" + this.tabAlias + ", " + this.alias + ", " + this.internalName + ": " + this.getType() + "}";
    }

    public void setObjectinspector(ObjectInspector writableObjectInspector) {
        this.objectInspector = writableObjectInspector;
    }
}

