/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchFormatter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;

public class DefaultFetchFormatter<T>
implements FetchFormatter<String> {
    private SerDe mSerde;

    @Override
    public void initialize(Configuration hconf, Properties props) throws HiveException {
        try {
            this.mSerde = this.initializeSerde(hconf, props);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private SerDe initializeSerde(Configuration conf, Properties props) throws Exception {
        String serdeName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE);
        Class<SerDe> serdeClass = Class.forName(serdeName, true, Utilities.getSessionSpecifiedClassLoader()).asSubclass(SerDe.class);
        SerDe serde = (SerDe)ReflectionUtils.newInstance(serdeClass, null);
        Properties serdeProps = new Properties();
        if (serde instanceof DelimitedJSONSerDe) {
            serdeProps.put("serialization.format", props.getProperty("serialization.format"));
            serdeProps.put("serialization.null.format", props.getProperty("serialization.null.format"));
        }
        SerDeUtils.initializeSerDe(serde, conf, serdeProps, null);
        return serde;
    }

    @Override
    public String convert(Object row, ObjectInspector rowOI) throws Exception {
        return this.mSerde.serialize(row, rowOI).toString();
    }

    @Override
    public void close() throws IOException {
    }
}

